/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.expressions;

import com.brein.time.expressions.ITemporalExpressionEvaluator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import net.objecthunter.exp4j.tokenizer.UnknownFunctionOrVariableException;
import org.apache.log4j.Logger;

public class Exp4JTemporalExpressionEvaluator
implements ITemporalExpressionEvaluator {
    public static final String GENERAL_VARIABLES = "generalVariables";
    public static final String ADDITIONAL_FUNCTIONS = "additionalFunctions";
    public static final String LOWEST_TIME_GRANULARITY = "smallestTimeUnit";
    public static final TimeUnit DEFAULT_LOWEST_TIME_GRANULARITY = TimeUnit.MILLISECONDS;
    private static final Logger LOGGER = Logger.getLogger(Exp4JTemporalExpressionEvaluator.class);
    private static final Map<String, TimeUnit> UNITS = Stream.of(new AbstractMap.SimpleEntry<String, TimeUnit>("ns", TimeUnit.NANOSECONDS), new AbstractMap.SimpleEntry<String, TimeUnit>("\u03bcs", TimeUnit.MICROSECONDS), new AbstractMap.SimpleEntry<String, TimeUnit>("ms", TimeUnit.MILLISECONDS), new AbstractMap.SimpleEntry<String, TimeUnit>("sec", TimeUnit.SECONDS), new AbstractMap.SimpleEntry<String, TimeUnit>("min", TimeUnit.MINUTES), new AbstractMap.SimpleEntry<String, TimeUnit>("h", TimeUnit.HOURS), new AbstractMap.SimpleEntry<String, TimeUnit>("d", TimeUnit.DAYS)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    private final Map<String, Expression> expressions = new ConcurrentHashMap<String, Expression>();
    private Map<String, Double> generalVariables;
    private List<Function> additionalFunctions;
    private TimeUnit lowestTimeGranularity;

    public void init() {
        this.init(Collections.emptyMap());
    }

    @Override
    public void init(Map<String, Object> settings) {
        this.lowestTimeGranularity = this.readLowestTimeGranularity(settings);
        this.generalVariables = new HashMap<String, Double>();
        this.generalVariables.putAll(this.createDefaultVariables());
        this.generalVariables.putAll(this.readGeneralVariables(settings));
        this.additionalFunctions = new ArrayList<Function>();
        this.additionalFunctions.addAll(this.createDefaultAdditionalFunctions());
        this.additionalFunctions.addAll(this.readAdditionalFunctions(settings));
    }

    @Override
    public String addFormula(String identifier, String formula, Set<String> variables) throws IllegalArgumentException {
        Set<Object> normalizedVariables = variables == null ? Collections.emptySet() : variables;
        try {
            this.expressions.put(identifier, new ExpressionBuilder(formula).functions(this.additionalFunctions).variables(this.generalVariables.keySet()).variables(normalizedVariables).build());
        }
        catch (UnknownFunctionOrVariableException e) {
            throw new IllegalArgumentException("Unable to parse the formula: " + formula, e);
        }
        return identifier;
    }

    @Override
    public void removeFormula(String identifier) {
        this.expressions.remove(identifier);
    }

    @Override
    public long evaluate(String identifier, Map<String, Long> variableBindings) throws IllegalArgumentException {
        Expression expression = this.expressions.get(identifier);
        if (expression == null) {
            throw new IllegalArgumentException("The identifier '" + identifier + "'" + " does not have any valid formula attached.");
        }
        Double result = expression.setVariables(this.generalVariables).setVariables(variableBindings.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), ((Long)e.getValue()).doubleValue())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue))).evaluate();
        if (result.isNaN() || result.isInfinite()) {
            LOGGER.warn((Object)"Received invalid long-result, returning 0 instead.");
            return 0L;
        }
        return result.longValue();
    }

    @Override
    public TimeUnit getEvaluationUnit() {
        return this.lowestTimeGranularity;
    }

    @Override
    public void close() {
        this.expressions.clear();
        this.generalVariables = null;
        this.additionalFunctions = null;
    }

    protected TimeUnit readLowestTimeGranularity(Map<String, Object> settings) {
        Object lowestGranularityObj = settings.get(LOWEST_TIME_GRANULARITY);
        if (lowestGranularityObj == null) {
            return DEFAULT_LOWEST_TIME_GRANULARITY;
        }
        if (TimeUnit.class.isInstance(lowestGranularityObj)) {
            return (TimeUnit)((Object)TimeUnit.class.cast(lowestGranularityObj));
        }
        if (String.class.isInstance(lowestGranularityObj)) {
            try {
                return TimeUnit.valueOf(((String)String.class.cast(lowestGranularityObj)).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                LOGGER.error((Object)String.format("Unable to parse the specified '%s' value '%s', using default '%s'.", new Object[]{LOWEST_TIME_GRANULARITY, lowestGranularityObj, DEFAULT_LOWEST_TIME_GRANULARITY}), (Throwable)e);
                return DEFAULT_LOWEST_TIME_GRANULARITY;
            }
        }
        LOGGER.warn((Object)String.format("Unable to parse the specified '%s' value '%s', using default '%s'.", new Object[]{LOWEST_TIME_GRANULARITY, lowestGranularityObj, DEFAULT_LOWEST_TIME_GRANULARITY}));
        return DEFAULT_LOWEST_TIME_GRANULARITY;
    }

    protected Map<String, Double> createDefaultVariables() {
        return UNITS.entrySet().stream().filter(e -> this.lowestTimeGranularity.compareTo((Enum)e.getValue()) <= 0).map(e -> {
            Long value = this.lowestTimeGranularity.convert(1L, (TimeUnit)((Object)((Object)e.getValue())));
            return new AbstractMap.SimpleEntry(e.getKey(), value.doubleValue());
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    protected Map<String, Double> readGeneralVariables(Map<String, Object> settings) {
        if (settings == null) {
            return Collections.emptyMap();
        }
        Object generalVariablesObj = settings.get(GENERAL_VARIABLES);
        if (generalVariablesObj == null) {
            return Collections.emptyMap();
        }
        if (!(generalVariablesObj instanceof Map)) {
            return Collections.emptyMap();
        }
        Map map = (Map)Map.class.cast(generalVariablesObj);
        return map.entrySet().stream().map(e -> {
            Object nameObj = e.getKey();
            Object valueObj = e.getValue();
            if (String.class.isInstance(nameObj) && Number.class.isInstance(valueObj)) {
                return new AbstractMap.SimpleEntry(String.class.cast(nameObj), ((Number)Number.class.cast(valueObj)).doubleValue());
            }
            LOGGER.warn((Object)String.format("Found invalid '%s' settings (key: %s, value: %s)", GENERAL_VARIABLES, nameObj, valueObj));
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    protected List<Function> createDefaultAdditionalFunctions() {
        ArrayList<Function> defaultAdditionalFunctions = new ArrayList<Function>();
        defaultAdditionalFunctions.add(new Function("now", 0){

            public double apply(double ... doubles) {
                TimeUnit unit = Exp4JTemporalExpressionEvaluator.this.lowestTimeGranularity;
                return unit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
        });
        defaultAdditionalFunctions.addAll(UNITS.entrySet().stream().filter(e -> this.lowestTimeGranularity.compareTo((Enum)e.getValue()) <= 0).map(e -> new Function(this.createToFunctionName((TimeUnit)((Object)((Object)e.getValue()))), 1, (Map.Entry)e){
            final /* synthetic */ Map.Entry val$e;
            {
                this.val$e = entry;
                super(x0, x1);
            }

            public double apply(double ... args) {
                Double value = args[0];
                long mappedValue = value.longValue();
                TimeUnit unit = Exp4JTemporalExpressionEvaluator.this.lowestTimeGranularity;
                return ((TimeUnit)((Object)this.val$e.getValue())).convert(mappedValue, unit);
            }
        }).collect(Collectors.toList()));
        return defaultAdditionalFunctions;
    }

    protected String createToFunctionName(TimeUnit unit) {
        String lowerCase = unit.name().toLowerCase();
        return "to" + lowerCase.substring(0, 1).toUpperCase() + lowerCase.substring(1);
    }

    protected List<Function> readAdditionalFunctions(Map<String, Object> settings) {
        if (settings == null) {
            return Collections.emptyList();
        }
        Object additionalFunctionsObj = settings.get(ADDITIONAL_FUNCTIONS);
        if (additionalFunctionsObj == null) {
            return Collections.emptyList();
        }
        if (!(additionalFunctionsObj instanceof Map)) {
            return Collections.emptyList();
        }
        Map map = (Map)Map.class.cast(additionalFunctionsObj);
        return map.entrySet().stream().map(e -> {
            Object nameObj = e.getKey();
            final Object valueObj = e.getValue();
            if (!String.class.isInstance(nameObj)) {
                LOGGER.warn((Object)String.format("Found invalid %s (key: %s, value: %s)", ADDITIONAL_FUNCTIONS, nameObj, valueObj));
                return null;
            }
            String name = (String)String.class.cast(nameObj);
            if (Function.class.isInstance(valueObj)) {
                Function func = (Function)Function.class.cast(valueObj);
                if (!name.equals(func.getName())) {
                    LOGGER.warn((Object)String.format("Mismatch in function name (%s vs. %s)", name, func.getName()));
                }
                return func;
            }
            if (Supplier.class.isInstance(valueObj)) {
                return new Function(name, 0){

                    public double apply(double ... args) {
                        Object result = ((Supplier)Supplier.class.cast(valueObj)).get();
                        return Exp4JTemporalExpressionEvaluator.this.toDouble(result);
                    }
                };
            }
            if (java.util.function.Function.class.isInstance(valueObj)) {
                return new Function(name, 1){

                    public double apply(double ... args) {
                        Object result = ((java.util.function.Function)java.util.function.Function.class.cast(valueObj)).apply(Exp4JTemporalExpressionEvaluator.this.toDouble(args[0]));
                        return Exp4JTemporalExpressionEvaluator.this.toDouble(result);
                    }
                };
            }
            if (BiFunction.class.isInstance(valueObj)) {
                return new Function(name, 2){

                    public double apply(double ... args) {
                        Object result = ((BiFunction)BiFunction.class.cast(valueObj)).apply(Exp4JTemporalExpressionEvaluator.this.toDouble(args[0]), Exp4JTemporalExpressionEvaluator.this.toDouble(args[1]));
                        return Exp4JTemporalExpressionEvaluator.this.toDouble(result);
                    }
                };
            }
            LOGGER.warn((Object)String.format("Found invalid additionalFunction (key: %s, value: %s)", name, valueObj));
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected double toDouble(Object val) {
        if (val == null) {
            return Double.NaN;
        }
        if (Double.class.isInstance(val)) {
            return (Double)Double.class.cast(val);
        }
        if (Number.class.isInstance(val)) {
            return ((Number)Number.class.cast(val)).doubleValue();
        }
        if (Double.TYPE.isInstance(val)) {
            return Double.TYPE.cast(val);
        }
        if (Long.TYPE.isInstance(val)) {
            return Long.TYPE.cast(val).longValue();
        }
        if (Integer.TYPE.isInstance(val)) {
            return Integer.TYPE.cast(val).intValue();
        }
        if (Byte.TYPE.isInstance(val)) {
            return Byte.TYPE.cast(val).byteValue();
        }
        if (Float.TYPE.isInstance(val)) {
            return Float.TYPE.cast(val).floatValue();
        }
        return Double.NaN;
    }
}

