/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.expressions;

import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public interface ITemporalExpressionEvaluator
extends Closeable {
    public void init(Map<String, Object> var1);

    default public String addFormula(String formula) throws IllegalArgumentException {
        return this.addFormula(formula, Collections.emptySet());
    }

    default public String addFormula(String identifier, String formula) throws IllegalArgumentException {
        return this.addFormula(identifier, formula, Collections.emptySet());
    }

    default public String addFormula(String formula, Collection<String> variables) throws IllegalArgumentException {
        String id = UUID.randomUUID().toString();
        return this.addFormula(id, formula, variables);
    }

    default public String addFormula(String identifier, String formula, Collection<String> variables) throws IllegalArgumentException {
        return this.addFormula(identifier, formula, (Set<String>)new HashSet<String>(variables));
    }

    public String addFormula(String var1, String var2, Set<String> var3) throws IllegalArgumentException;

    public void removeFormula(String var1);

    default public long evaluateFormula(String formula) throws IllegalArgumentException {
        return this.evaluateFormula(formula, Collections.emptyMap());
    }

    default public long evaluateFormula(String formula, Map<String, Long> variableBindings) throws IllegalArgumentException {
        String id = this.addFormula(formula);
        long result = this.evaluate(id, variableBindings);
        this.removeFormula(id);
        return result;
    }

    default public long evaluate(String identifier) throws IllegalArgumentException {
        return this.evaluate(identifier, Collections.emptyMap());
    }

    public long evaluate(String var1, Map<String, Long> var2) throws IllegalArgumentException;

    public TimeUnit getEvaluationUnit();
}

