/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.collections;

import com.brein.time.exceptions.FailedConnection;
import com.brein.time.exceptions.FailedIO;
import com.brein.time.exceptions.FailedLoad;
import com.brein.time.exceptions.IllegalConfiguration;
import com.brein.time.timeintervals.collections.IntervalCollection;
import com.brein.time.timeintervals.collections.IntervalCollectionEvent;
import com.brein.time.timeintervals.collections.IntervalCollectionPersistor;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class CassandraIntervalCollectionPersistor
implements IntervalCollectionPersistor,
Closeable {
    public static final String KEY_COLUMN = "interval_key";
    public static final String COLL_COLUMN = "interval_collection";
    private static final Logger LOGGER = Logger.getLogger(CassandraIntervalCollectionPersistor.class);
    private final transient Lock sessionLock = new ReentrantLock();
    private transient Cluster cluster = null;
    private transient Session session = null;
    private transient PreparedStatement select;
    private transient PreparedStatement upsert;
    private transient PreparedStatement delete;
    private String replicator = "{'class': 'SimpleStrategy', 'replication_factor' : 1}";
    private String columnFamily = "intervalTree";
    private String keySpace = "intervalTree";

    public void connect(String node, int port) {
        this.sessionLock.lock();
        try {
            if (this.session != null) {
                return;
            }
            if (this.cluster == null) {
                this.cluster = Cluster.builder().addContactPoint(node).withPort(port).build();
                Metadata metadata = this.cluster.getMetadata();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)String.format("Connected to cluster: %s", metadata.getClusterName()));
                    for (Host host : metadata.getAllHosts()) {
                        LOGGER.info((Object)String.format("Datacenter: %s; Host: %s; Rack: %s", host.getDatacenter(), host.getAddress(), host.getRack()));
                    }
                }
            }
            this.session = this.cluster.connect();
        }
        catch (Exception e) {
            String msg = String.format("Unable to open a connection at '%s:%d (%s)'.", node, port, this.keySpace);
            try {
                this.cluster.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cluster = null;
            throw new FailedConnection(msg, e);
        }
        finally {
            this.sessionLock.unlock();
        }
        this.createKeySpace();
        this.createColumnFamily();
    }

    protected void createKeySpace() {
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Checking for key-space: " + this.keySpace));
            }
            this.getSession().execute("USE " + this.keySpace);
        }
        catch (InvalidQueryException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Creating key-space: " + this.keySpace), (Throwable)e);
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Creating key-space: " + this.keySpace));
            }
            this.getSession().execute("CREATE KEYSPACE " + this.keySpace + " with replication = " + this.replicator);
            this.getSession().execute("USE " + this.keySpace);
        }
    }

    protected void createColumnFamily() {
        String ks = this.getKeySpace();
        String cf = this.getColumnFamily();
        KeyspaceMetadata keySpaceMeta = this.cluster.getMetadata().getKeyspace(ks);
        TableMetadata tableMetadata = keySpaceMeta.getTable(cf);
        if (tableMetadata != null) {
            return;
        }
        String stmt = String.format("CREATE TABLE %s (\n  interval_key text,\n  interval_collection blob,\n  PRIMARY KEY (interval_key)\n);", cf);
        this.getSession().execute(stmt);
    }

    public String getKeySpace() {
        return this.keySpace;
    }

    public void setKeySpace(String keySpace) {
        this.keySpace = keySpace;
    }

    public String getReplicator() {
        return this.replicator;
    }

    public CassandraIntervalCollectionPersistor setReplicator(String replicator) {
        this.replicator = replicator;
        return this;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public CassandraIntervalCollectionPersistor setColumnFamily(String columnFamily) {
        this.columnFamily = columnFamily;
        return this;
    }

    public Session getSession() {
        if (this.session == null) {
            throw new FailedConnection("You have to establish a connection using connect(...).");
        }
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.sessionLock.lock();
        try {
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Unable to close the session.", (Throwable)e);
                }
                finally {
                    this.session = null;
                }
            }
            if (this.cluster != null) {
                try {
                    this.cluster.close();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Unable to close the cluster.", (Throwable)e);
                }
                finally {
                    this.cluster = null;
                }
            }
            this.select = null;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Closed database connection with keyspace '" + this.keySpace + "'."));
            }
        }
        finally {
            this.sessionLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IntervalCollection load(String key) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Loading IntervalCollection: " + key));
        }
        if (this.select == null) {
            this.select = this.getSession().prepare((RegularStatement)QueryBuilder.select((String[])new String[]{COLL_COLUMN}).from(this.keySpace, this.columnFamily).where(QueryBuilder.eq((String)KEY_COLUMN, (Object)QueryBuilder.bindMarker())));
        }
        BoundStatement boundStmt = new BoundStatement(this.select);
        boundStmt.setString(0, key);
        ResultSet result = this.getSession().execute((Statement)boundStmt);
        if (result.isExhausted()) {
            return null;
        }
        ByteBuffer bytes = result.one().getBytes(0);
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.array()));){
            IntervalCollection intervalCollection = (IntervalCollection)IntervalCollection.class.cast(in.readObject());
            return intervalCollection;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new FailedLoad("Unable ot load instance for " + key, e);
        }
    }

    @Override
    public void upsert(IntervalCollectionEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Upserting IntervalCollection '" + event.getKey() + "': " + event.getCollection()));
        }
        if (this.upsert == null) {
            this.upsert = this.getSession().prepare((RegularStatement)QueryBuilder.update((String)this.keySpace, (String)this.columnFamily).with(QueryBuilder.set((String)COLL_COLUMN, (Object)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)KEY_COLUMN, (Object)QueryBuilder.bindMarker())));
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(byteStream);){
            IntervalCollection coll = event.getCollection();
            if (!Serializable.class.isInstance(coll)) {
                throw new IllegalConfiguration("The collection to be written is not serializable.");
            }
            out.writeObject(coll);
            out.flush();
        }
        catch (IOException e) {
            throw new FailedIO("Unable ot upsert instance for " + event.getKey(), e);
        }
        BoundStatement boundStmt = new BoundStatement(this.upsert);
        boundStmt.setBytes(0, ByteBuffer.wrap(byteStream.toByteArray()));
        boundStmt.setString(1, event.getKey());
        this.getSession().execute((Statement)boundStmt);
    }

    @Override
    public void remove(IntervalCollectionEvent event) {
        if (event.getCollection().isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Removing IntervalCollection: " + event.getKey()));
            }
            if (this.delete == null) {
                this.delete = this.getSession().prepare((RegularStatement)QueryBuilder.delete().from(this.keySpace, this.columnFamily).where(QueryBuilder.eq((String)KEY_COLUMN, (Object)QueryBuilder.bindMarker())));
            }
            BoundStatement boundStmt = new BoundStatement(this.delete);
            boundStmt.setString(0, event.getKey());
            this.getSession().execute((Statement)boundStmt);
        } else {
            this.upsert(event);
        }
    }

    public void dropKeySpace() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Dropping key-space: " + this.keySpace));
        }
        this.getSession().execute("DROP KEYSPACE " + this.keySpace);
    }
}

