/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.collections;

import com.brein.time.timeintervals.collections.IntervalCollection;
import com.brein.time.timeintervals.collections.IntervalCollectionEvent;
import com.brein.time.timeintervals.collections.IntervalCollectionEventType;
import com.brein.time.timeintervals.collections.IntervalCollectionObserver;
import com.brein.time.timeintervals.filters.IntervalFilter;
import com.brein.time.timeintervals.indexes.IntervalValueComparator;
import com.brein.time.timeintervals.intervals.IInterval;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Observable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.apache.log4j.Logger;

public class ObservableIntervalCollection
extends Observable
implements IntervalCollection {
    private static final Logger LOGGER = Logger.getLogger(ObservableIntervalCollection.class);
    private final transient AtomicBoolean disableNotification = new AtomicBoolean(false);
    private IntervalCollection collection;

    public ObservableIntervalCollection() {
    }

    public ObservableIntervalCollection(IntervalCollectionObserver observer, IntervalCollection collection) {
        this.addObserver(observer);
        this.collection = collection;
    }

    @Override
    public Iterator<IInterval> iterator() {
        final Iterator it = this.collection.iterator();
        return new Iterator<IInterval>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public IInterval next() {
                return (IInterval)it.next();
            }
        };
    }

    @Override
    public boolean add(IInterval interval) {
        return this.notifyObservers(interval, IntervalCollectionEventType.UPSERTED, this.collection.add(interval));
    }

    @Override
    public boolean remove(IInterval interval) {
        return this.notifyObservers(interval, IntervalCollectionEventType.REMOVED, this.collection.remove(interval));
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public Collection<IInterval> find(IInterval interval, IntervalValueComparator cmp) {
        return this.collection.find(interval, cmp);
    }

    @Override
    public Collection<IInterval> find(IInterval interval, IntervalValueComparator cmp, IntervalFilter filter) {
        return this.collection.find(interval, cmp, filter);
    }

    @Override
    public Stream<IInterval> stream() {
        return this.collection.stream();
    }

    public boolean notifyObservers(IInterval interval, IntervalCollectionEventType eventType, boolean result) {
        if (interval == null || this.countObservers() == 0 || !result) {
            return false;
        }
        if (!this.disableNotification.get()) {
            String key = interval.getUniqueIdentifier();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Notifying observers for '" + key + "'."));
            }
            this.setChanged();
            IntervalCollectionEvent event = new IntervalCollectionEvent(key, interval, this.getWrappedCollection(), eventType);
            super.notifyObservers(event);
        }
        return true;
    }

    public int hashCode() {
        return this.collection.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (ObservableIntervalCollection.class.equals(obj.getClass())) {
            ObservableIntervalCollection coll = (ObservableIntervalCollection)ObservableIntervalCollection.class.cast(obj);
            return Objects.equals(this.collection, coll.collection);
        }
        return false;
    }

    public String toString() {
        return this.collection.toString();
    }

    public IntervalCollection getWrappedCollection() {
        return this.collection;
    }
}

