/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.collections;

import com.brein.time.timeintervals.collections.IntervalCollection;
import com.brein.time.timeintervals.filters.IntervalFilter;
import com.brein.time.timeintervals.indexes.IntervalValueComparator;
import com.brein.time.timeintervals.intervals.IInterval;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class ShallowIntervalCollection
implements IntervalCollection {
    public static final ShallowIntervalCollection SHALLOW_COLLECTION = new ShallowIntervalCollection();

    @Override
    public Iterator<IInterval> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public boolean add(IInterval iInterval) {
        return false;
    }

    @Override
    public boolean remove(IInterval o) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Collection<IInterval> find(IInterval interval, IntervalValueComparator cmp) {
        return this.find(interval, cmp, null);
    }

    @Override
    public Collection<IInterval> find(IInterval interval, IntervalValueComparator cmp, IntervalFilter filter) {
        return Collections.singletonList(interval);
    }

    private Object readResolve() {
        return SHALLOW_COLLECTION;
    }
}

