/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.indexes;

import com.brein.time.exceptions.FailedIO;
import com.brein.time.exceptions.IllegalConfiguration;
import com.brein.time.timeintervals.filters.IntervalFilter;
import com.brein.time.timeintervals.indexes.IntervalTreeBuilder;
import com.brein.time.timeintervals.indexes.IntervalTreeConfiguration;
import com.brein.time.timeintervals.indexes.IntervalTreeNode;
import com.brein.time.timeintervals.indexes.IntervalTreeNodeChildType;
import com.brein.time.timeintervals.indexes.IntervalTreeNodeContext;
import com.brein.time.timeintervals.indexes.PositionedNode;
import com.brein.time.timeintervals.intervals.IInterval;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;

public class IntervalTree
implements Collection<IInterval>,
Externalizable {
    private static final Logger LOGGER = Logger.getLogger(IntervalTree.class);
    private transient IntervalTreeConfiguration configuration = null;
    private IntervalTreeNode root = null;
    private long size = 0L;

    public Collection<IInterval> find(IInterval query) {
        return this.find(query, this.configuration.getIntervalFilter());
    }

    public Collection<IInterval> find(IInterval query, IntervalFilter filter) {
        if (this.root == null) {
            return Collections.emptyList();
        }
        return this._find(this.root, query, filter);
    }

    protected IntervalTreeNode getRoot() {
        return this.root;
    }

    protected Collection<IInterval> _find(IntervalTreeNode node, IInterval query, IntervalFilter filter) {
        if (node == null) {
            return Collections.emptyList();
        }
        int cmpNode = node.compareTo(query);
        if (cmpNode == 0) {
            return node.find(query, filter);
        }
        if (cmpNode < 0) {
            return this._find(node.getRight(), query, filter);
        }
        return this._find(node.getLeft(), query, filter);
    }

    public Stream<IInterval> overlapStream(IInterval query) {
        if (this.root == null) {
            return Stream.empty();
        }
        return this._overlap(this.root, query);
    }

    public Collection<IInterval> overlap(IInterval query) {
        if (this.root == null) {
            return Collections.emptyList();
        }
        return this._overlap(this.root, query).collect(Collectors.toList());
    }

    protected Stream<IInterval> _overlap(IntervalTreeNode node, IInterval query) {
        if (node == null) {
            return Stream.empty();
        }
        Stream<Object> nodeStream = node.compare(node.getStart(), query.getNormEnd()) <= 0 && node.compare(node.getEnd(), query.getNormStart()) >= 0 ? node.getIntervals().stream() : Stream.empty();
        Stream<Object> leftNodeStream = node.hasLeft() && node.compare(node.getLeft().getMax(), query.getNormStart()) >= 0 ? this._overlap(node.getLeft(), query) : Stream.empty();
        Stream<IInterval> rightNodeStream = this._overlap(node.getRight(), query);
        return Stream.of(nodeStream, leftNodeStream, rightNodeStream).flatMap(s -> s);
    }

    public IntervalTree insert(IInterval interval) {
        this.add(interval);
        return this;
    }

    protected IntervalTreeNode _add(IntervalTreeNode node, IInterval interval, AtomicBoolean changed) {
        if (node == null) {
            changed.set(true);
            return this.createNode(interval);
        }
        int cmpNode = node.compareTo(interval);
        if (cmpNode == 0) {
            changed.set(node.addInterval(interval));
            return node;
        }
        IntervalTreeNodeChildType childType = cmpNode < 0 ? IntervalTreeNodeChildType.RIGHT : IntervalTreeNodeChildType.LEFT;
        node.setChild(this._add(node.getChild(childType), interval, changed), childType);
        return this.isAutoBalancing() ? this.balance(node) : node;
    }

    protected IntervalTreeNode createNode(IInterval interval) {
        IntervalTreeNode node = new IntervalTreeNode();
        node.setConfiguration(this.configuration);
        node.init(interval);
        node.addInterval(interval);
        return node;
    }

    public void balance() {
        this.nodeIterator().forEachRemaining(node -> {
            if (!node.isLeaf()) {
                if (node.isRoot()) {
                    this.root = this.balance((IntervalTreeNode)node);
                } else {
                    node.setLeft(this.balance(node.getLeft()));
                    node.setRight(this.balance(node.getRight()));
                }
            }
        });
    }

    public boolean isBalanced() {
        return this.isBalanced(this.root);
    }

    protected boolean isBalanced(IntervalTreeNode node) {
        if (node == null) {
            return true;
        }
        return Math.abs(this.determineBalance(node)) <= 1L && this.isBalanced(node.getLeft()) && this.isBalanced(node.getRight());
    }

    protected IntervalTreeNode balance(IntervalTreeNode node) {
        long balanceRight;
        long balance = this.determineBalance(node);
        if (Math.abs(balance) <= 1L) {
            return node;
        }
        long balanceLeft = balance > 1L ? this.determineBalance(node.getLeft()) : 0L;
        long l = balanceRight = balance < -1L ? this.determineBalance(node.getRight()) : 0L;
        if (balance > 1L && balanceLeft >= 0L) {
            return this.rightRotate(node);
        }
        if (balance < -1L && balanceRight <= 0L) {
            return this.leftRotate(node);
        }
        if (balance > 1L && balanceLeft < 0L) {
            node.setLeft(this.leftRotate(node.getLeft()));
            return this.rightRotate(node);
        }
        if (balance < -1L && balanceRight > 0L) {
            node.setRight(this.rightRotate(node.getRight()));
            return this.leftRotate(node);
        }
        LOGGER.warn((Object)String.format("Balancing node '%s' reached an unexpected state (b: %d, l: %d, r: %d)", node, balance, balanceLeft, balanceRight));
        LOGGER.warn((Object)this);
        return node;
    }

    public IntervalTree delete(IInterval interval) {
        this.remove(interval);
        return this;
    }

    protected IntervalTreeNode _remove(IntervalTreeNode node, IInterval interval, AtomicBoolean changed) {
        if (node == null) {
            changed.set(false);
            return null;
        }
        int cmpNode = node.compareTo(interval);
        if (cmpNode == 0) {
            if (node.removeInterval(interval)) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Removed interval '" + interval + "' from node '" + node + "'."));
                }
                changed.set(true);
                return this.removeEmptyNode(node);
            }
            changed.set(false);
            return node;
        }
        IntervalTreeNodeChildType childType = cmpNode < 0 ? IntervalTreeNodeChildType.RIGHT : IntervalTreeNodeChildType.LEFT;
        node.setChild(this._remove(node.getChild(childType), interval, changed), childType);
        return this.isAutoBalancing() ? this.balance(node) : node;
    }

    protected IntervalTreeNode removeEmptyNode(IntervalTreeNode node) {
        IntervalTreeNode actionNode;
        IntervalTreeNode rootNode;
        if (!node.isEmpty()) {
            return node;
        }
        if (node.isLeaf()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Removing leaf '" + node + "' from tree."));
            }
            rootNode = null;
            actionNode = null;
        } else if (node.isSingleParent()) {
            rootNode = node.getSingleChild();
            actionNode = null;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Removing node '" + node + "' and replacing with '" + rootNode + "' from tree."));
            }
        } else {
            rootNode = this.findLeftLeaf(node.getRight());
            IntervalTreeNode intervalTreeNode = actionNode = node == rootNode.getParent() ? null : rootNode.getParent();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Removing node '" + node + "' and replacing with smallest '" + rootNode + "' from tree."));
            }
            IntervalTreeNodeContext nodeCtx = node.detach();
            IntervalTreeNodeChildType replacementChildType = rootNode.determineChildType();
            IntervalTreeNodeContext replacementCtx = rootNode.detach();
            if (replacementCtx.isSingleParent()) {
                replacementCtx.getParent().setChild(replacementCtx.getSingleChild(), replacementChildType);
            }
            if (nodeCtx.getLeft() == rootNode) {
                rootNode.setLeft(replacementCtx.getLeft());
                rootNode.setRight(nodeCtx.getRight());
                rootNode.setParent(nodeCtx.getParent());
            } else if (nodeCtx.getRight() == rootNode) {
                rootNode.setRight(replacementCtx.getRight());
                rootNode.setLeft(nodeCtx.getLeft());
                rootNode.setParent(nodeCtx.getParent());
            } else {
                rootNode.setContext(nodeCtx);
            }
        }
        if (rootNode != null && node.isRoot()) {
            rootNode.setParent(null);
            rootNode.setLevel(0L);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("rootNode: " + rootNode));
            LOGGER.trace((Object)("actionNode: " + actionNode));
        }
        if (!this.isAutoBalancing()) {
            return rootNode;
        }
        if (rootNode == null) {
            return null;
        }
        if (actionNode == null) {
            return this.balance(rootNode);
        }
        IntervalTreeNodeChildType childType = actionNode.determineChildType();
        IntervalTreeNode n = actionNode.getParent();
        while (true) {
            IntervalTreeNode child = n.getChild(childType);
            n.setChild(this.balance(child), childType);
            if (n == rootNode) break;
            childType = n.determineChildType();
            n = n.getParent();
        }
        return this.balance(rootNode);
    }

    protected long determineBalance(IntervalTreeNode node) {
        if (node == null) {
            return 0L;
        }
        return (node.hasLeft() ? node.getLeft().getHeight() : 0L) - (node.hasRight() ? node.getRight().getHeight() : 0L);
    }

    protected IntervalTreeNode leftRotate(IntervalTreeNode node) {
        IntervalTreeNode right = node.getRight();
        IntervalTreeNodeContext rightCtx = right.detach();
        IntervalTreeNodeContext nodeCtx = node.detach();
        node.setLeft(nodeCtx.getLeft());
        node.setRight(rightCtx.getLeft());
        right.setLeft(node);
        right.setRight(rightCtx.getRight());
        return right;
    }

    protected IntervalTreeNode rightRotate(IntervalTreeNode node) {
        IntervalTreeNode left = node.getLeft();
        IntervalTreeNodeContext leftCtx = left.detach();
        IntervalTreeNodeContext nodeCtx = node.detach();
        node.setLeft(leftCtx.getRight());
        node.setRight(nodeCtx.getRight());
        left.setRight(node);
        left.setLeft(leftCtx.getLeft());
        return left;
    }

    protected IntervalTreeNode findLeftLeaf(IntervalTreeNode startNode) {
        if (startNode == null) {
            return null;
        }
        IntervalTreeNode node = startNode;
        while (node.getLeft() != null) {
            node = node.getLeft();
        }
        return node;
    }

    protected PositionedNode findLeftLeaf(PositionedNode posNode) {
        if (posNode == null || posNode.getNode() == null) {
            return null;
        }
        IntervalTreeNode node = posNode.getNode();
        long offset = 0L;
        while (node.getLeft() != null) {
            node = node.getLeft();
            ++offset;
        }
        return PositionedNode.moveLeft(node, posNode, offset);
    }

    @Override
    public int size() {
        return this.size < Integer.MAX_VALUE ? Long.valueOf(this.size).intValue() : Integer.MAX_VALUE;
    }

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof IInterval) {
            return !this.find((IInterval)IInterval.class.cast(o)).isEmpty();
        }
        return false;
    }

    @Override
    public Iterator<IInterval> iterator() {
        final Iterator<IntervalTreeNode> outerNodeIt = this.nodeIterator();
        return new Iterator<IInterval>(){
            private Iterator<IInterval> nodeCollectionIt = null;
            private IInterval next = this.findNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            protected IInterval findNext() {
                if (this.nodeCollectionIt == null || !this.nodeCollectionIt.hasNext()) {
                    if (outerNodeIt.hasNext()) {
                        this.nodeCollectionIt = ((IntervalTreeNode)outerNodeIt.next()).iterator();
                    } else {
                        return null;
                    }
                }
                return this.nodeCollectionIt.next();
            }

            @Override
            public IInterval next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IInterval result = this.next;
                this.next = this.findNext();
                return result;
            }
        };
    }

    @Override
    public Object[] toArray() {
        if ((long)this.size() == 0L) {
            return new IInterval[0];
        }
        Object[] intervals = new IInterval[this.size()];
        AtomicInteger pos = new AtomicInteger(0);
        this.iterator().forEachRemaining(arg_0 -> IntervalTree.lambda$toArray$2((IInterval[])intervals, pos, arg_0));
        return intervals;
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        Object[] intervals = (long)arr.length < this.size ? (Object[])Array.newInstance(arr.getClass().getComponentType(), this.size()) : arr;
        AtomicInteger pos = new AtomicInteger(0);
        this.iterator().forEachRemaining(i -> {
            intervals[pos.getAndIncrement()] = i;
        });
        for (int i2 = intervals.length; i2 < this.size(); ++i2) {
            intervals[i2] = null;
        }
        return intervals;
    }

    @Override
    public boolean add(IInterval interval) {
        AtomicBoolean changed = new AtomicBoolean(false);
        this.root = this._add(this.root, interval, changed);
        this.size += changed.get() ? 1L : 0L;
        return changed.get();
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof IInterval)) {
            return false;
        }
        IInterval interval = (IInterval)IInterval.class.cast(o);
        AtomicBoolean changed = new AtomicBoolean(false);
        this.root = this._remove(this.root, interval, changed);
        this.size -= changed.get() ? 1L : 0L;
        return changed.get();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends IInterval> c) {
        AtomicBoolean changed = new AtomicBoolean(false);
        c.forEach(interval -> changed.compareAndSet(false, this.add((IInterval)interval)));
        return changed.get();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        AtomicBoolean changed = new AtomicBoolean(false);
        c.forEach(interval -> changed.compareAndSet(false, this.remove(interval)));
        return changed.get();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        List contained = c.stream().filter(this::contains).map(IInterval.class::cast).collect(Collectors.toList());
        if (contained.size() == this.size()) {
            return false;
        }
        this.clear();
        this.addAll(contained);
        return true;
    }

    @Override
    public void clear() {
        this.root = null;
        this.size = 0L;
    }

    public Iterator<IntervalTreeNode> nodeIterator() {
        final IntervalTreeNode outerFirstNext = this.findLeftLeaf(this.root);
        return new Iterator<IntervalTreeNode>(){
            private IntervalTreeNode next;
            {
                this.next = outerFirstNext;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public IntervalTreeNode next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IntervalTreeNode result = this.next;
                if (this.next.getRight() != null) {
                    this.next = IntervalTree.this.findLeftLeaf(this.next.getRight());
                    return result;
                }
                while (true) {
                    IntervalTreeNode parent;
                    if ((parent = this.next.getParent()) == null) {
                        this.next = null;
                        return result;
                    }
                    if (parent.getLeft() == this.next) {
                        this.next = parent;
                        return result;
                    }
                    this.next = parent;
                }
            }
        };
    }

    public Iterator<PositionedNode> positionIterator() {
        final PositionedNode outerFirstNext = this.findLeftLeaf(new PositionedNode(this.root, 0L, 0L));
        return new Iterator<PositionedNode>(){
            private PositionedNode next;
            {
                this.next = outerFirstNext;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public PositionedNode next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                PositionedNode result = this.next;
                IntervalTreeNode right = this.next.getNode().getRight();
                if (right == null) {
                    while (true) {
                        IntervalTreeNode node;
                        IntervalTreeNode parent;
                        if ((parent = (node = this.next.getNode()).getParent()) == null) {
                            this.next = null;
                            return result;
                        }
                        PositionedNode posParent = PositionedNode.moveUp(parent, this.next, 1L);
                        if (parent.getLeft() == node) {
                            this.next = posParent;
                            return result;
                        }
                        this.next = posParent;
                    }
                }
                PositionedNode posRight = PositionedNode.moveRight(right, this.next, 1L);
                this.next = IntervalTree.this.findLeftLeaf(posRight);
                return result;
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString("", this.root, sb, true);
        return sb.toString();
    }

    private void toString(String prefix, IntervalTreeNode node, StringBuilder sb, boolean tail) {
        sb.append(prefix).append(tail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ").append(node).append(System.lineSeparator());
        if (node == null || node.isLeaf()) {
            return;
        }
        String newPrefix = prefix + (tail ? "    " : "\u2502   ");
        this.toString(newPrefix, node.getLeft(), sb, false);
        this.toString(newPrefix, node.getRight(), sb, true);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.size);
        if (this.root != null) {
            this.root.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readLong();
        if (this.size > 0L) {
            this.root = new IntervalTreeNode();
            this.root.setConfiguration(this.configuration);
            this.root.readExternal(in);
        }
    }

    public boolean isAutoBalancing() {
        return this.configuration.isAutoBalancing();
    }

    public IntervalTreeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IntervalTreeConfiguration configuration) {
        if (this.root != null) {
            throw new IllegalConfiguration("The configuration cannot be changed once the tree is created.");
        }
        this.configuration = configuration;
    }

    public void saveToFile(File file) throws FailedIO {
        IntervalTreeBuilder.saveToFile(file, this);
    }

    private static /* synthetic */ void lambda$toArray$2(IInterval[] intervals, AtomicInteger pos, IInterval i) {
        intervals[pos.getAndIncrement()] = i;
    }
}

