/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.indexes;

import com.brein.time.exceptions.FailedIO;
import com.brein.time.timeintervals.collections.IntervalCollectionFactory;
import com.brein.time.timeintervals.collections.IntervalCollectionPersistor;
import com.brein.time.timeintervals.filters.IntervalFilter;
import com.brein.time.timeintervals.filters.IntervalFilters;
import com.brein.time.timeintervals.indexes.IntervalTree;
import com.brein.time.timeintervals.indexes.IntervalTreeConfiguration;
import com.brein.time.timeintervals.indexes.IntervalValueComparator;
import com.brein.time.timeintervals.intervals.DoubleInterval;
import com.brein.time.timeintervals.intervals.IInterval;
import com.brein.time.timeintervals.intervals.IntegerInterval;
import com.brein.time.timeintervals.intervals.LongInterval;
import com.brein.time.timeintervals.intervals.NumberInterval;
import com.brein.time.timeintervals.intervals.TimestampInterval;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class IntervalTreeBuilder {
    private File file = null;
    private IntervalCollectionPersistor persistor = null;
    private IntervalCollectionFactory factory = null;
    private IntervalFilter filter = null;
    private IntervalValueComparator valueComparator = null;
    private boolean autoBalancing = true;
    private boolean writeCollections = false;

    public static IntervalTreeBuilder newBuilder() {
        return new IntervalTreeBuilder();
    }

    public static void saveToFile(File file, IntervalTree tree) throws FailedIO {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new FailedIO("Could not create parent directory: " + parent);
        }
        try (FileOutputStream fos = new FileOutputStream(file, false);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            tree.getConfiguration().writeExternal(oos);
            tree.writeExternal(oos);
        }
        catch (IOException e) {
            throw new FailedIO("Could not save the tree to the file: " + file, e);
        }
    }

    public IntervalTreeBuilder loadFromFile(File file) {
        this.file = file;
        return this;
    }

    public IntervalTreeBuilder usePersistor(IntervalCollectionPersistor persistor) {
        this.persistor = persistor;
        return this;
    }

    public IntervalTreeBuilder collectIntervals(IntervalCollectionFactory factory) {
        this.factory = factory;
        return this;
    }

    public IntervalTreeBuilder overrideComparator(IntervalValueComparator comparator) {
        this.valueComparator = comparator;
        return this;
    }

    public IntervalTreeBuilder overrideFilter(IntervalFilter filter) {
        this.filter = filter;
        return this;
    }

    public IntervalTreeBuilder usePredefinedType(IntervalType intervalType) {
        return this.usePredefinedType(intervalType, false);
    }

    public IntervalTreeBuilder usePredefinedType(IntervalType intervalType, boolean strict) {
        this.valueComparator = intervalType.getComparator(strict);
        this.filter = intervalType.getIntervalFilter();
        return this;
    }

    public IntervalTreeBuilder disableAutoBalancing() {
        return this.setAutoBalancing(false);
    }

    public IntervalTreeBuilder setAutoBalancing(boolean autoBalancing) {
        this.autoBalancing = autoBalancing;
        return this;
    }

    public IntervalTreeBuilder enableWriteCollections() {
        return this.setWriteCollections(true);
    }

    public IntervalTreeBuilder setWriteCollections(boolean writeCollections) {
        this.writeCollections = writeCollections;
        return this;
    }

    public IntervalTree build() throws FailedIO {
        if (this.file == null) {
            return this.buildFromSettings();
        }
        if (!this.file.exists() || !this.file.isFile()) {
            return this.buildFromSettings();
        }
        IntervalTree tree = new IntervalTree();
        IntervalTreeConfiguration configuration = new IntervalTreeConfiguration();
        try (FileInputStream fis = new FileInputStream(this.file);
             ObjectInputStream oin = new ObjectInputStream(fis);){
            configuration.readExternal(oin);
            configuration.setPersistor(this.persistor);
            tree.setConfiguration(configuration);
            tree.readExternal(oin);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new FailedIO("Could not load the tree from the file: " + this.file, e);
        }
        return tree;
    }

    protected IntervalTree buildFromSettings() {
        IntervalTree tree = new IntervalTree();
        IntervalTreeConfiguration configuration = new IntervalTreeConfiguration();
        configuration.setAutoBalancing(this.autoBalancing);
        configuration.setValueComparator(this.valueComparator);
        configuration.setIntervalFilter(this.filter);
        configuration.setWritingCollectionsToFile(this.writeCollections);
        configuration.setFactory(this.factory);
        configuration.setPersistor(this.persistor);
        tree.setConfiguration(configuration);
        return tree;
    }

    public static enum IntervalType {
        NUMBER(NumberInterval.class, IntervalFilters::weakEqual, IntervalValueComparator::compareNumbers, IntervalValueComparator::compareNumbers),
        INTEGER(IntegerInterval.class, IntervalFilters::weakEqual, IntervalValueComparator::compareNumbers, IntervalValueComparator::compareInts),
        LONG(LongInterval.class, IntervalFilters::weakEqual, IntervalValueComparator::compareNumbers, IntervalValueComparator::compareLongs),
        DOUBLE(DoubleInterval.class, IntervalFilters::weakEqual, IntervalValueComparator::compareNumbers, IntervalValueComparator::compareDoubles),
        TIMESTAMP(TimestampInterval.class, IntervalFilters::weakEqual, IntervalValueComparator::compareNumbers, IntervalValueComparator::compareLongs);

        private final Class<? extends IInterval> clazz;
        private final IntervalFilter intervalFilter;
        private final IntervalValueComparator comparator;
        private final IntervalValueComparator strictComparator;

        private IntervalType(Class<? extends IInterval> clazz, IntervalFilter intervalFilter, IntervalValueComparator comparator, IntervalValueComparator strictComparator) {
            this.clazz = clazz;
            this.intervalFilter = intervalFilter;
            this.comparator = comparator;
            this.strictComparator = comparator;
        }

        public IntervalFilter getIntervalFilter() {
            return this.intervalFilter;
        }

        public IntervalValueComparator getComparator(boolean strict) {
            return strict ? this.strictComparator : this.comparator;
        }
    }
}

