/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.indexes;

import com.brein.time.exceptions.IllegalConfiguration;
import com.brein.time.timeintervals.collections.IntervalCollectionFactory;
import com.brein.time.timeintervals.collections.IntervalCollectionPersistor;
import com.brein.time.timeintervals.filters.IntervalFilter;
import com.brein.time.timeintervals.indexes.IntervalValueComparator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.log4j.Logger;

public class IntervalTreeConfiguration
implements Externalizable {
    private static final Logger LOGGER = Logger.getLogger(IntervalTreeConfiguration.class);
    private boolean autoBalancing = true;
    private boolean usesPersistor = false;
    private boolean writingCollectionsToFile = false;
    private IntervalValueComparator valueComparator = null;
    private IntervalFilter intervalFilter = null;
    private IntervalCollectionFactory factory = null;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.autoBalancing);
        out.writeBoolean(this.usesPersistor);
        out.writeBoolean(this.writingCollectionsToFile);
        out.writeObject(this.valueComparator);
        out.writeObject(this.intervalFilter);
        out.writeObject(this.factory);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.autoBalancing = in.readBoolean();
        this.usesPersistor = in.readBoolean();
        this.writingCollectionsToFile = in.readBoolean();
        this.valueComparator = (IntervalValueComparator)IntervalValueComparator.class.cast(in.readObject());
        this.intervalFilter = (IntervalFilter)IntervalFilter.class.cast(in.readObject());
        this.factory = (IntervalCollectionFactory)IntervalCollectionFactory.class.cast(in.readObject());
    }

    public boolean isAutoBalancing() {
        return this.autoBalancing;
    }

    public void setAutoBalancing(boolean autoBalancing) {
        this.autoBalancing = autoBalancing;
    }

    public IntervalValueComparator getValueComparator() {
        return this.valueComparator;
    }

    public void setValueComparator(IntervalValueComparator valueComparator) {
        this.valueComparator = valueComparator;
    }

    public IntervalCollectionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(IntervalCollectionFactory factory) {
        this.factory = factory;
    }

    public void setPersistor(IntervalCollectionPersistor persistor) throws IllegalConfiguration {
        if (this.factory != null) {
            this.factory.usePersistor(persistor);
            this.usesPersistor = persistor != null;
        } else {
            this.usesPersistor = false;
        }
    }

    public boolean isUsingPersistor() {
        return this.usesPersistor;
    }

    public boolean isWritingCollectionsToFile() {
        return this.writingCollectionsToFile;
    }

    public void setWritingCollectionsToFile(boolean writingCollectionsToFile) {
        this.writingCollectionsToFile = writingCollectionsToFile;
    }

    public IntervalFilter getIntervalFilter() {
        return this.intervalFilter;
    }

    public void setIntervalFilter(IntervalFilter intervalFilter) {
        this.intervalFilter = intervalFilter;
    }
}

