/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.indexes;

import com.brein.time.timeintervals.collections.IntervalCollection;
import com.brein.time.timeintervals.collections.IntervalCollectionFactory;
import com.brein.time.timeintervals.collections.IntervalCollectionObserver;
import com.brein.time.timeintervals.collections.ObservableIntervalCollection;
import com.brein.time.timeintervals.collections.UnmodifiableIntervalCollection;
import com.brein.time.timeintervals.filters.IntervalFilter;
import com.brein.time.timeintervals.indexes.IntervalTreeConfiguration;
import com.brein.time.timeintervals.indexes.IntervalTreeNodeChildType;
import com.brein.time.timeintervals.indexes.IntervalTreeNodeContext;
import com.brein.time.timeintervals.intervals.IInterval;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

public class IntervalTreeNode
extends IntervalTreeNodeContext
implements Externalizable,
Iterable<IInterval>,
Comparable<IntervalTreeNode> {
    private transient WeakReference<IntervalCollection> referenceCollection;
    private IntervalCollection collection;
    private String key;
    private Comparable start;
    private Comparable end;
    private Comparable max;
    private long level;
    private long height;
    private IntervalTreeConfiguration configuration;

    public void init(IInterval interval) {
        this.start = interval.getNormStart();
        this.end = interval.getNormEnd();
        this.max = interval.getNormEnd();
        this.key = interval.getUniqueIdentifier();
        this.level = 0L;
        this.height = 1L;
    }

    public Comparable getStart() {
        return this.start;
    }

    public Comparable getEnd() {
        return this.end;
    }

    public Comparable getMax() {
        return this.max;
    }

    public void setMax(Comparable max) {
        if (this.compare(this.max, max) == 0) {
            return;
        }
        this.max = max;
        if (this.hasParent()) {
            this.getParent().updateMax();
        }
    }

    public long getLevel() {
        return this.level;
    }

    public void setLevel(long level) {
        if (this.level == level) {
            return;
        }
        this.level = level;
        if (this.hasLeft()) {
            this.getLeft().setLevel(level + 1L);
        }
        if (this.hasRight()) {
            this.getRight().setLevel(level + 1L);
        }
    }

    public void updateMax() {
        if (this.isLeaf()) {
            this.setMax(this.end);
        } else if (this.isSingleParent()) {
            Comparable singleChildMax = this.getSingleChild().max;
            this.setMax(this.compare(this.end, singleChildMax) < 0 ? singleChildMax : this.end);
        } else {
            Comparable leftMax = this.getLeft().max;
            Comparable rightMax = this.getRight().max;
            Comparable thisMax = this.end;
            if (this.compare(leftMax, rightMax) < 0) {
                this.setMax(this.compare(thisMax, rightMax) < 0 ? rightMax : thisMax);
            } else {
                this.setMax(this.compare(thisMax, leftMax) < 0 ? leftMax : thisMax);
            }
        }
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        if (this.height == height) {
            return;
        }
        this.height = height;
        if (this.hasParent()) {
            this.getParent().updateHeight();
        }
    }

    public void updateHeight() {
        if (this.isLeaf()) {
            this.setHeight(1L);
        } else if (this.isSingleParent()) {
            this.setHeight(this.getSingleChild().getHeight() + 1L);
        } else {
            this.setHeight(Math.max(this.getLeft().getHeight(), this.getRight().getHeight()) + 1L);
        }
    }

    public IntervalCollection getIntervals() {
        return new UnmodifiableIntervalCollection(this.getCollection());
    }

    public boolean addInterval(IInterval interval) {
        assert (this.key.equals(interval.getUniqueIdentifier()));
        assert (this.compareTo(interval) == 0);
        return this.getCollection().add(interval);
    }

    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    public boolean removeInterval(IInterval interval) {
        return this.getCollection().remove(interval);
    }

    public Collection<IInterval> find(IInterval interval, IntervalFilter filter) {
        return this.getCollection().find(interval, this.configuration.getValueComparator(), filter);
    }

    public String getId() {
        return String.format("[%s, %s]", this.start, this.end);
    }

    @Override
    public int compareTo(IntervalTreeNode node) {
        return this.compareTo(node.start, node.end);
    }

    @Override
    public int compareTo(IInterval interval) {
        return this.compareTo((Comparable)interval.getNormStart(), (Comparable)interval.getNormEnd());
    }

    public int compareTo(Comparable start, Comparable end) {
        int cmpStart = this.compare(this.start, start);
        if (cmpStart < 0) {
            return -1;
        }
        if (cmpStart == 0) {
            return this.compare(this.end, end);
        }
        return 1;
    }

    public int compare(Object val1, Object val2) {
        return this.configuration.getValueComparator().compare(val1, val2);
    }

    @Override
    public void setLeft(IntervalTreeNode left) {
        this.setChild(left, IntervalTreeNodeChildType.LEFT);
    }

    @Override
    public void setRight(IntervalTreeNode right) {
        this.setChild(right, IntervalTreeNodeChildType.RIGHT);
    }

    @Override
    public String toString() {
        return String.format("[%s, %s] (max: %s, count: %d, level: %d, height: %d)", this.start, this.end, this.max, this.getCollection().size(), this.level, this.height);
    }

    protected void setChild(IntervalTreeNode node, IntervalTreeNodeChildType childType) {
        if (IntervalTreeNodeChildType.LEFT.equals((Object)childType)) {
            super.setLeft(node);
        } else if (IntervalTreeNodeChildType.RIGHT.equals((Object)childType)) {
            super.setRight(node);
        }
        if (node != null) {
            node.setParent(this);
            node.setLevel(this.level + 1L);
        }
        this.updateMax();
        this.updateHeight();
    }

    protected IntervalTreeNode get(IntervalTreeNodeChildType childType) {
        if (IntervalTreeNodeChildType.LEFT.equals((Object)childType)) {
            return this.getLeft();
        }
        if (IntervalTreeNodeChildType.RIGHT.equals((Object)childType)) {
            return this.getRight();
        }
        return null;
    }

    public IntervalTreeNodeContext detach() {
        IntervalTreeNodeContext ctx = new IntervalTreeNodeContext(this);
        IntervalTreeNode parent = this.getParent();
        if (parent != null) {
            parent.removeChild(this);
        }
        this.setParent(null);
        this.setLeft(null);
        this.setRight(null);
        this.max = this.end;
        this.level = 0L;
        return ctx;
    }

    public void removeChild(IntervalTreeNode node) {
        this.replaceChild(node, (IntervalTreeNode)IntervalTreeNode.class.cast(null));
    }

    public void replaceChild(IntervalTreeNode replacement, IntervalTreeNodeChildType childType) {
        if (IntervalTreeNodeChildType.LEFT.equals((Object)childType)) {
            this.setLeft(replacement);
        } else if (IntervalTreeNodeChildType.RIGHT.equals((Object)childType)) {
            this.setRight(replacement);
        }
    }

    public void replaceChild(IntervalTreeNode replacee, IntervalTreeNode replacement) {
        if (this.getLeft() == replacee) {
            this.setLeft(replacement);
        } else if (this.getRight() == replacee) {
            this.setRight(replacement);
        }
    }

    @Override
    public Iterator<IInterval> iterator() {
        return this.getCollection().iterator();
    }

    public IntervalTreeNodeChildType determineChildType() {
        if (!this.hasParent()) {
            return IntervalTreeNodeChildType.NONE;
        }
        if (this.getParent().getLeft() == this) {
            return IntervalTreeNodeChildType.LEFT;
        }
        if (this.getParent().getRight() == this) {
            return IntervalTreeNodeChildType.RIGHT;
        }
        return IntervalTreeNodeChildType.NONE;
    }

    public int hashCode() {
        return Objects.hash(this.getStart(), this.getEnd());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (IntervalTreeNode.class.equals(obj.getClass())) {
            IntervalTreeNode node = (IntervalTreeNode)IntervalTreeNode.class.cast(obj);
            return this.compareTo(node) == 0;
        }
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.key);
        out.writeObject(this.start);
        out.writeObject(this.end);
        out.writeObject(this.max);
        out.writeLong(this.level);
        out.writeLong(this.height);
        if (this.configuration.isWritingCollectionsToFile()) {
            if (ObservableIntervalCollection.class.isInstance(this.collection)) {
                ObservableIntervalCollection observable = (ObservableIntervalCollection)ObservableIntervalCollection.class.cast(this.collection);
                out.writeObject(observable.getWrappedCollection());
            } else {
                out.writeObject(this.collection);
            }
        }
        this.writeChild(out, IntervalTreeNodeChildType.LEFT);
        this.writeChild(out, IntervalTreeNodeChildType.RIGHT);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.key = (String)String.class.cast(in.readObject());
        this.start = (Comparable)Comparable.class.cast(in.readObject());
        this.end = (Comparable)Comparable.class.cast(in.readObject());
        this.max = (Comparable)Comparable.class.cast(in.readObject());
        this.level = in.readLong();
        this.height = in.readLong();
        if (this.configuration.isWritingCollectionsToFile()) {
            this.collection = this.wrapCollection((IntervalCollection)IntervalCollection.class.cast(in.readObject()));
        }
        this.readChild(in, IntervalTreeNodeChildType.LEFT);
        this.readChild(in, IntervalTreeNodeChildType.RIGHT);
    }

    protected void writeChild(ObjectOutput out, IntervalTreeNodeChildType type) throws IOException {
        if (this.hasChild(type)) {
            out.writeBoolean(true);
            this.getChild(type).writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
    }

    protected void readChild(ObjectInput in, IntervalTreeNodeChildType type) throws IOException, ClassNotFoundException {
        IntervalTreeNode node;
        boolean hasChild = in.readBoolean();
        if (hasChild) {
            node = new IntervalTreeNode();
            node.setConfiguration(this.configuration);
            node.readExternal(in);
        } else {
            node = null;
        }
        this.setChild(node, type);
    }

    public void setConfiguration(IntervalTreeConfiguration configuration) {
        this.configuration = configuration;
    }

    protected IntervalCollection getCollection() {
        IntervalCollectionFactory factory = this.configuration.getFactory();
        if (factory == null) {
            return IntervalCollectionFactory.shallow();
        }
        if (this.collection != null) {
            return this.collection;
        }
        if (factory.useWeakReferences()) {
            IntervalCollection reference;
            if (this.referenceCollection != null && (reference = (IntervalCollection)this.referenceCollection.get()) != null) {
                return reference;
            }
        } else assert (this.collection == null);
        return this.wrapCollection(factory.load(this.key));
    }

    protected IntervalCollection wrapCollection(IntervalCollection collection) {
        IntervalCollectionFactory factory = this.configuration.getFactory();
        if (factory == null) {
            return collection;
        }
        IntervalCollection wrappedCollection = IntervalCollectionObserver.class.isInstance(factory) && !ObservableIntervalCollection.class.isInstance(collection) ? new ObservableIntervalCollection((IntervalCollectionObserver)IntervalCollectionObserver.class.cast(factory), collection) : collection;
        if (factory.useWeakReferences()) {
            this.collection = null;
            this.referenceCollection = new WeakReference<IntervalCollection>(wrappedCollection);
        } else {
            this.collection = wrappedCollection;
            this.referenceCollection = null;
        }
        return wrappedCollection;
    }
}

