/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.indexes;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

@FunctionalInterface
public interface IntervalValueComparator
extends Serializable {
    public static final String ERROR_MSG = "The values '%s (%s)' and '%s (%s)' are not comparable.";
    public static final List<Class<? extends Comparable<? extends Number>>> NUMBER_HIERARCHY = Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class);

    public static int compareLongs(Object o1, Object o2) {
        if (!Long.class.isAssignableFrom(o1.getClass()) || !Long.class.isAssignableFrom(o2.getClass())) {
            throw new IllegalArgumentException(String.format(ERROR_MSG, o1, o1.getClass(), o2, o2.getClass()));
        }
        return ((Long)Long.class.cast(o1)).compareTo((Long)Long.class.cast(o2));
    }

    public static int compareInts(Object o1, Object o2) {
        if (!Integer.class.isAssignableFrom(o1.getClass()) || !Integer.class.isAssignableFrom(o2.getClass())) {
            throw new IllegalArgumentException(String.format(ERROR_MSG, o1, o1.getClass(), o2, o2.getClass()));
        }
        return ((Integer)Integer.class.cast(o1)).compareTo((Integer)Integer.class.cast(o2));
    }

    public static int compareDoubles(Object o1, Object o2) {
        if (!Double.class.isAssignableFrom(o1.getClass()) || !Double.class.isAssignableFrom(o2.getClass())) {
            throw new IllegalArgumentException(String.format(ERROR_MSG, o1, o1.getClass(), o2, o2.getClass()));
        }
        return ((Double)Double.class.cast(o1)).compareTo((Double)Double.class.cast(o2));
    }

    public static int compareNumbers(Object o1, Object o2) {
        if (!Number.class.isAssignableFrom(o1.getClass()) || !Number.class.isAssignableFrom(o2.getClass())) {
            throw new IllegalArgumentException(String.format(ERROR_MSG, o1, o1.getClass(), o2, o2.getClass()));
        }
        if (Comparable.class.isAssignableFrom(o1.getClass()) && o1.getClass().equals(o2.getClass())) {
            return ((Comparable)Comparable.class.cast(o1)).compareTo(o2);
        }
        int pos = Stream.of(o1.getClass(), o2.getClass()).map(NUMBER_HIERARCHY::indexOf).filter(idx -> idx != -1).mapToInt(idx -> idx).max().orElse(-1);
        Class<? extends Comparable<? extends Number>> mappedClazz = NUMBER_HIERARCHY.get(pos);
        Comparable<? extends Number> mappedO1 = IntervalValueComparator.mapNumberValue(o1, mappedClazz);
        Comparable<? extends Number> mappedO2 = IntervalValueComparator.mapNumberValue(o2, mappedClazz);
        return mappedO1.compareTo((Number)((Object)mappedO2));
    }

    public static <C> C mapNumberValue(Object val, Class<C> clazz) {
        if (val == null) {
            return null;
        }
        Number nrVal = (Number)Number.class.cast(val);
        if (Short.class.equals(clazz)) {
            return (C)Short.valueOf(nrVal.shortValue());
        }
        if (Byte.class.equals(clazz)) {
            return (C)Byte.valueOf(nrVal.byteValue());
        }
        if (Integer.class.equals(clazz)) {
            return (C)Integer.valueOf(nrVal.intValue());
        }
        if (Long.class.equals(clazz)) {
            return (C)Long.valueOf(nrVal.longValue());
        }
        if (Float.class.equals(clazz)) {
            return (C)Float.valueOf(nrVal.floatValue());
        }
        if (Double.class.equals(clazz)) {
            return (C)Double.valueOf(nrVal.doubleValue());
        }
        throw new IllegalArgumentException("The class '" + clazz + "' is not supported.");
    }

    public int compare(Object var1, Object var2);
}

