/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.indexes.viewer;

import com.brein.time.timeintervals.indexes.IntervalTree;
import com.brein.time.timeintervals.indexes.IntervalTreeNode;
import com.brein.time.timeintervals.indexes.PositionedNode;
import com.brein.time.timeintervals.intervals.LongInterval;
import com.brein.time.timeintervals.intervals.TimestampInterval;
import java.io.File;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.concurrent.atomic.AtomicLong;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.SingleGraph;
import org.graphstream.stream.Sink;
import org.graphstream.stream.file.FileSinkImages;
import org.graphstream.ui.view.Viewer;

public class GraphStreamIntervalTreeViewer {
    private static final double GAP_SIZE = 1000.0;
    private static final double WIDTH_HEIGHT_RATIO = 3.0;
    private final IntervalTree tree;
    private Graph graph = null;

    public GraphStreamIntervalTreeViewer(IntervalTree tree) {
        this.tree = tree;
    }

    public static void main(String[] args) {
        IntervalTree tree = new IntervalTree();
        GraphStreamIntervalTreeViewer.addFullTree(tree);
        GraphStreamIntervalTreeViewer viewer = new GraphStreamIntervalTreeViewer(tree);
        viewer.visualize();
    }

    public static void addRandomTimeStamps(IntervalTree tree) {
        GregorianCalendar gc = new GregorianCalendar();
        for (int i = 0; i < 10; ++i) {
            int year = GraphStreamIntervalTreeViewer.randBetween(2000, 2030);
            int dayOfYear = GraphStreamIntervalTreeViewer.randBetween(1, gc.getActualMaximum(6));
            gc.set(1, year);
            gc.set(6, dayOfYear);
            long unixTimestamp = Double.valueOf(Math.floor((double)gc.getTimeInMillis() / 1000.0)).longValue();
            long duration = Math.round(Math.random() * 10000.0);
            tree.add(new TimestampInterval(unixTimestamp, unixTimestamp + duration));
        }
    }

    public static void addFullTree(IntervalTree tree) {
        tree.add(new LongInterval(0L, 1L));
        tree.add(new LongInterval(-1L, 1L));
        tree.add(new LongInterval(1L, 2L));
        tree.add(new LongInterval(4L, 4L));
        tree.add(new LongInterval(3L, 3L));
        tree.add(new LongInterval(5L, 5L));
        tree.add(new LongInterval(2L, 3L));
        tree.add(new LongInterval(2L, 4L));
        tree.add(new LongInterval(2L, 2L));
        tree.remove(new LongInterval(4L, 4L));
        tree.remove(new LongInterval(5L, 5L));
    }

    public static int randBetween(int start, int end) {
        return start + (int)Math.round(Math.random() * (double)(end - start));
    }

    public void save(File file) throws IOException {
        file.getParentFile().mkdirs();
        FileSinkImages fsi = new FileSinkImages();
        fsi.setLayoutPolicy(FileSinkImages.LayoutPolicy.NO_LAYOUT);
        fsi.setQuality(FileSinkImages.Quality.HIGH);
        fsi.setResolution((FileSinkImages.Resolution)FileSinkImages.Resolutions.HD720);
        Graph graph = this.getGraph();
        graph.clearSinks();
        graph.addSink((Sink)fsi);
        fsi.writeAll(graph, file.getCanonicalPath());
    }

    public void visualize() {
        Viewer viewer = this.getGraph().display(false);
        viewer.disableAutoLayout();
    }

    protected Graph getGraph() {
        if (this.graph != null) {
            return this.graph;
        }
        SingleGraph graph = new SingleGraph("IntervalTree");
        AtomicLong maxLevel = new AtomicLong(0L);
        this.tree.positionIterator().forEachRemaining(arg_0 -> GraphStreamIntervalTreeViewer.lambda$getGraph$0((Graph)graph, maxLevel, arg_0));
        this.tree.positionIterator().forEachRemaining(arg_0 -> this.lambda$getGraph$1((Graph)graph, maxLevel, arg_0));
        this.graph = graph;
        return graph;
    }

    protected double[] calculatePos(long maxLevel, PositionedNode node) {
        return new double[]{this.calculateXPos(maxLevel, node), this.calculateYPos(maxLevel, node)};
    }

    protected double calculateXPos(long maxLevel, PositionedNode node) {
        long level = node.getY();
        double nrOfLeaves = Math.pow(2.0, maxLevel);
        double nrOfGaps = nrOfLeaves - 1.0;
        double width = nrOfGaps * 1000.0;
        double nrOfNodes = Math.pow(2.0, level);
        double levelGapSize = 1000.0 * Math.pow(2.0, maxLevel - level);
        double levelOffset = 0.5 * (width - levelGapSize * (nrOfNodes - 1.0));
        return levelOffset + (double)node.getX() * levelGapSize;
    }

    protected double calculateYPos(long maxLevel, PositionedNode node) {
        double nrOfLeaves = Math.pow(2.0, maxLevel);
        double nrOfGaps = nrOfLeaves - 1.0;
        double width = nrOfGaps * 1000.0;
        double heightFactor = maxLevel == 0L ? 1.0 : width / (double)maxLevel / 3.0;
        return (double)(-1L * node.getY()) * heightFactor;
    }

    private /* synthetic */ void lambda$getGraph$1(Graph graph, AtomicLong maxLevel, PositionedNode node) {
        String nodeId = node.getId();
        Node n = graph.getNode(nodeId);
        IntervalTreeNode parent = node.getNode().getParent();
        double[] pos = this.calculatePos(maxLevel.get(), node);
        double x = pos[0];
        double y = pos[1];
        n.setAttribute("x", new Object[]{x});
        n.setAttribute("y", new Object[]{y});
        if (parent != null) {
            String parentId = parent.getId();
            graph.addEdge(String.format("%s-%s", parentId, nodeId), parentId, nodeId);
        }
    }

    private static /* synthetic */ void lambda$getGraph$0(Graph graph, AtomicLong maxLevel, PositionedNode node) {
        String nodeId = node.getId();
        Node n = graph.addNode(nodeId);
        n.setAttribute("ui.label", new Object[]{nodeId});
        IntervalTreeNode parent = node.getNode().getParent();
        maxLevel.set(Math.max(maxLevel.get(), node.getY()));
    }
}

