/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.intervals;

import com.brein.time.timeintervals.intervals.IInterval;
import com.brein.time.timeintervals.intervals.NumberInterval;

public enum AllenIntervalRelation {
    OVERLAPS,
    IS_OVERLAPPED_BY,
    EQUALS,
    BEGINS,
    ENDS,
    BEGINS_BY,
    ENDS_BY,
    BEFORE,
    AFTER,
    INCLUDES,
    IS_DURING,
    STARTS_DIRECTLY_BEFORE,
    ENDS_DIRECTLY_BEFORE;


    public static AllenIntervalRelation determineRelation(NumberInterval i1, IInterval i2) {
        if (i1.irOverlaps(i2)) {
            return OVERLAPS;
        }
        if (i1.irIsOverlappedBy(i2)) {
            return IS_OVERLAPPED_BY;
        }
        if (i1.irEquals(i2)) {
            return EQUALS;
        }
        if (i1.irBegins(i2)) {
            return BEGINS;
        }
        if (i1.irBeginsBy(i2)) {
            return BEGINS_BY;
        }
        if (i1.irEnds(i2)) {
            return ENDS;
        }
        if (i1.irEndsBy(i2)) {
            return ENDS_BY;
        }
        if (i1.irBefore(i2)) {
            return BEFORE;
        }
        if (i1.irAfter(i2)) {
            return AFTER;
        }
        if (i1.irStartsDirectlyBefore(i2)) {
            return STARTS_DIRECTLY_BEFORE;
        }
        if (i1.irEndsDirectlyBefore(i2)) {
            return ENDS_DIRECTLY_BEFORE;
        }
        if (i1.irIncludes(i2)) {
            return INCLUDES;
        }
        if (i1.irIsDuring(i2)) {
            return IS_DURING;
        }
        return null;
    }
}

