/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeintervals.intervals;

import com.brein.time.exceptions.IllegalTimeInterval;
import com.brein.time.exceptions.IllegalTimePoint;
import com.brein.time.timeintervals.intervals.LongInterval;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class TimestampInterval
extends LongInterval {
    public static final ZoneId UTC = ZoneId.of("UTC");
    private ZoneId timezone;

    public TimestampInterval() {
    }

    public TimestampInterval(Long utcStart, Long utcEnd) throws IllegalTimeInterval, IllegalTimePoint {
        this(UTC, utcStart, utcEnd);
    }

    public TimestampInterval(ZoneId timezone, Long utcStart, Long utcEnd) throws IllegalTimeInterval, IllegalTimePoint {
        super(utcStart, utcEnd);
        this.timezone = timezone;
    }

    public ZonedDateTime getUtcStart() {
        return Instant.ofEpochSecond((Long)this.getNormStart()).atZone(this.getTimezone());
    }

    public ZonedDateTime getUtcEnd() {
        return Instant.ofEpochSecond((Long)this.getNormEnd()).atZone(UTC);
    }

    public ZonedDateTime getTimeZoneStart() {
        return Instant.ofEpochSecond((Long)this.getNormStart()).atZone(this.getTimezone());
    }

    public ZonedDateTime getTimeZoneEnd() {
        return Instant.ofEpochSecond((Long)this.getNormEnd()).atZone(this.getTimezone());
    }

    public long getDurationInSec() {
        return (Long)this.getNormStart() - (Long)this.getNormEnd();
    }

    public ZoneId getTimezone() {
        return this.timezone;
    }

    public void setTimezone(ZoneId timezone) {
        this.timezone = timezone;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.timezone);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.timezone = (ZoneId)ZoneId.class.cast(in.readObject());
    }
}

