/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timer;

import java.util.concurrent.TimeUnit;

public class CountdownTimer {
    private final long timeIntervalInNanos;
    private final TimeUnit timeUnit;
    private long intervalStartInNanos = -1L;

    public CountdownTimer(long timeInterval, TimeUnit timeUnit) {
        this.timeIntervalInNanos = timeUnit.toNanos(timeInterval);
        this.timeUnit = timeUnit;
    }

    public void startTimer() {
        this.startTimer(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public void startTimer(long now, TimeUnit timeUnit) {
        this.intervalStartInNanos = timeUnit.toNanos(now);
    }

    public boolean timerEnded(long now, TimeUnit timeUnit) {
        return this.intervalStartInNanos == -1L || timeUnit.toNanos(now) - this.intervalStartInNanos >= this.timeIntervalInNanos;
    }

    public long getRemainingTime(long now, TimeUnit timeUnit) {
        if (this.intervalStartInNanos == -1L) {
            return 0L;
        }
        long remainingNanos = Math.max(0L, this.timeIntervalInNanos - (timeUnit.toNanos(now) - this.intervalStartInNanos));
        return TimeUnit.NANOSECONDS.convert(remainingNanos, this.timeUnit);
    }
}

