/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeseries;

import com.brein.time.exceptions.IllegalBucketEndPoints;
import com.brein.time.utils.TimeUtils;
import java.io.Serializable;
import java.util.Objects;

public class BucketEndPoints
implements Serializable,
Comparable<BucketEndPoints> {
    private static final long serialVersionUID = 1L;
    private final long start;
    private final long end;

    public BucketEndPoints(long unixTimeStampStart, long unixTimeStampEnd) throws IllegalBucketEndPoints {
        if (unixTimeStampEnd <= unixTimeStampStart) {
            throw new IllegalBucketEndPoints(String.format("The defined boundaries are invalid: %d (end) <= %d (start)", unixTimeStampEnd, unixTimeStampStart));
        }
        this.start = unixTimeStampStart;
        this.end = unixTimeStampEnd;
    }

    public long getUnixTimeStampEnd() {
        return this.end;
    }

    public long getUnixTimeStampStart() {
        return this.start;
    }

    public long size() {
        return this.end - this.start;
    }

    public long diff(BucketEndPoints other) {
        long size = this.size();
        if (size != other.size() || (this.start - other.start) % size != 0L) {
            throw new IllegalBucketEndPoints(String.format("The buckets %s and %s do not belong to the same configuration and cannot be compared, or better the difference between these bucket end points cannot be determined.", this, other));
        }
        return (other.start - this.start) / size;
    }

    public BucketEndPoints move(long buckets) {
        if (buckets == 0L) {
            return this;
        }
        long forward = buckets * this.size();
        return new BucketEndPoints(this.start + forward, this.end + forward);
    }

    @Override
    public int compareTo(BucketEndPoints other) {
        int res = Long.compare(this.start, other.start);
        if (res == 0) {
            res = Long.compare(this.end, other.end);
        }
        return res;
    }

    public int hashCode() {
        return Objects.hash(Long.hashCode(this.start), Long.hashCode(this.end));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (BucketEndPoints.class.isInstance(obj)) {
            BucketEndPoints other = (BucketEndPoints)BucketEndPoints.class.cast(obj);
            return this.start == other.start && this.end == other.end;
        }
        return false;
    }

    public String toString() {
        return String.format("[%d, %d) == [%s, %s)", this.start, this.end, TimeUtils.format(this.start), TimeUtils.format(this.end));
    }
}

