/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeseries;

import com.brein.time.exceptions.IllegalConfiguration;
import com.brein.time.exceptions.IllegalTimePoint;
import com.brein.time.exceptions.IllegalTimePointIndex;
import com.brein.time.exceptions.IllegalTimePointMovement;
import com.brein.time.exceptions.IllegalValueRegardingConfiguration;
import com.brein.time.timeseries.BucketEndPoints;
import com.brein.time.timeseries.BucketTimeSeriesConfig;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class BucketTimeSeries<T extends Serializable>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 2L;
    protected final BucketTimeSeriesConfig<T> config;
    protected T[] timeSeries = null;
    protected BucketEndPoints now = null;
    protected int currentNowIdx = -1;
    protected transient BiConsumer<Integer, T> observer;

    public BucketTimeSeries(BucketTimeSeriesConfig<T> config) {
        this(config, null);
    }

    public BucketTimeSeries(BucketTimeSeriesConfig<T> config, BiConsumer<Integer, T> observer) {
        this.config = config;
        this.timeSeries = this.createEmptyArray();
        this.observer = observer;
    }

    public void setObserver(BiConsumer<Integer, T> observer) {
        this.observer = observer;
    }

    public BucketTimeSeries(BucketTimeSeriesConfig<T> config, T[] timeSeries, long now) throws IllegalValueRegardingConfiguration {
        this.config = config;
        this.timeSeries = timeSeries;
        this.now = this.normalizeUnixTimeStamp(now);
        this.currentNowIdx = 0;
        if (this.timeSeries != null && this.timeSeries.length != config.getTimeSeriesSize()) {
            throw new IllegalValueRegardingConfiguration("The defined size of the time-series does not satisfy the configured time-series size (" + this.timeSeries.length + " vs. " + config.getTimeSeriesSize() + ").");
        }
    }

    protected T[] createEmptyArray() {
        Object[] array = (Serializable[])Array.newInstance(this.config.getBucketContent(), this.config.getTimeSeriesSize());
        if (this.applyZero()) {
            Arrays.fill(array, 0, array.length, this.zero());
        }
        return array;
    }

    protected boolean applyZero() {
        return this.config.isFillNumberWithZero() && Number.class.isAssignableFrom(this.config.getBucketContent());
    }

    protected void fill(int fromIndex, int endIndex) {
        fromIndex = fromIndex == -1 ? 0 : fromIndex;
        endIndex = endIndex == -1 || endIndex > this.timeSeries.length ? this.timeSeries.length : endIndex;
        T val = this.applyZero() ? (T)this.zero() : null;
        for (int i = fromIndex; i < endIndex; ++i) {
            this.set(i, val);
        }
    }

    public T[] getTimeSeries() {
        return this.timeSeries;
    }

    public T[] order() {
        Serializable[] result;
        if (this.timeSeries != null && this.currentNowIdx != -1) {
            result = (Serializable[])Array.newInstance(this.config.getBucketContent(), this.config.getTimeSeriesSize());
            AtomicInteger i = new AtomicInteger(0);
            this.forEach(val -> {
                result[i.getAndIncrement()] = val;
            });
        } else {
            result = this.createEmptyArray();
        }
        return result;
    }

    public long[] create(Function<T, Long> supplier) {
        long[] result = new long[this.config.getTimeSeriesSize()];
        if (this.timeSeries != null && this.currentNowIdx != -1) {
            AtomicInteger i = new AtomicInteger(0);
            this.forEach(val -> {
                result[i.getAndIncrement()] = (Long)supplier.apply(val);
            });
        } else {
            boolean applyZero = this.applyZero();
            for (int i = 0; i < result.length; ++i) {
                result[i] = applyZero ? supplier.apply(this.zero()).longValue() : supplier.apply(null).longValue();
            }
        }
        return result;
    }

    public int getNowIdx() {
        return this.currentNowIdx;
    }

    public T getFromZeroBasedIdx(int idx) {
        if (this.timeSeries != null && this.currentNowIdx != -1) {
            this.validateIdx(idx);
            return this.get(this.idx(this.currentNowIdx + idx));
        }
        return null;
    }

    public BucketEndPoints getEndPoints(int bucketsFromNow) throws IllegalTimePoint {
        if (this.currentNowIdx == -1 || this.now == null) {
            throw new IllegalTimePoint("The now is not set yet, thus no end-points can be returned");
        }
        return this.now.move(bucketsFromNow);
    }

    public long getTimeStamp(int offset) {
        return this.getEndPoints(-1 * offset).getUnixTimeStampStart();
    }

    public void set(long unixTimeStamp, T value) {
        int idx = this.handleDataUnixTimeStamp(unixTimeStamp);
        if (idx == -1) {
            return;
        }
        this.set(idx, value);
    }

    public void modify(long unixTimeStamp, Function<T, T> mod) {
        this.modify(unixTimeStamp, (Integer ignore, T val) -> (Serializable)mod.apply(val));
    }

    public void modify(long unixTimeStamp, BiFunction<Integer, T, T> mod) {
        int idx = this.handleDataUnixTimeStamp(unixTimeStamp);
        if (idx == -1) {
            return;
        }
        this.set(idx, (T)((Serializable)mod.apply(idx, (Integer)this.get(idx))));
    }

    public void modify(int idx, Function<T, T> mod) {
        this.set(idx, (T)((Serializable)mod.apply(this.get(idx))));
    }

    public void set(int idx, T value) throws IllegalTimePointIndex {
        this.validateIdx(idx);
        this.timeSeries[idx] = value;
        if (this.observer != null) {
            this.observer.accept(idx, (Integer)value);
        }
    }

    public void initNow(long now, int currentNowIdx) {
        if (this.now != null || this.currentNowIdx != -1) {
            throw new IllegalTimePointMovement("Cannot modify the now and the currentIdx once values where added.");
        }
        this.now = this.normalizeUnixTimeStamp(now);
        this.currentNowIdx = currentNowIdx;
    }

    public T get(int idx) {
        this.validateIdx(idx);
        return this.timeSeries[idx];
    }

    public int getBucketSize(long diffInSeconds) {
        long secondsPerBucket = TimeUnit.SECONDS.convert(this.config.getBucketSize(), this.config.getTimeUnit());
        return (int)Math.ceil((double)diffInSeconds / (double)secondsPerBucket);
    }

    protected int handleDataUnixTimeStamp(long unixTimeStamp) {
        long diff;
        BucketEndPoints bucketEndPoints = this.normalizeUnixTimeStamp(unixTimeStamp);
        if (this.now == null) {
            this.setNow(unixTimeStamp);
            diff = 0L;
        } else {
            diff = this.now.diff(bucketEndPoints);
        }
        if (diff > 0L) {
            this.setNow(unixTimeStamp);
            return this.currentNowIdx;
        }
        if (Math.abs(diff) >= (long)this.config.getTimeSeriesSize()) {
            return -1;
        }
        return this.idx((long)this.currentNowIdx - diff);
    }

    protected void validateIdx(int idx) throws IllegalTimePointIndex {
        if (idx < 0 || idx >= this.config.getTimeSeriesSize()) {
            throw new IllegalTimePointIndex(String.format("The index %d is out of bound [%d, %d].", idx, 0, this.config.getTimeSeriesSize() - 1));
        }
    }

    protected int idx(long absIdx) {
        int idx = (int)(absIdx % (long)this.config.getTimeSeriesSize());
        return idx < 0 ? idx + this.config.getTimeSeriesSize() : idx;
    }

    public BucketEndPoints normalizeUnixTimeStamp(long unixTimeStamp) {
        TimeUnit timeUnit = this.config.getTimeUnit();
        long timeStamp = timeUnit.convert(unixTimeStamp, TimeUnit.SECONDS);
        int bucketSize = this.config.getBucketSize();
        long offset = timeStamp % (long)bucketSize;
        long start = timeStamp - offset;
        long end = start + (long)this.config.getBucketSize();
        return new BucketEndPoints(TimeUnit.SECONDS.convert(start, timeUnit), TimeUnit.SECONDS.convert(end, timeUnit));
    }

    protected T zero() {
        Class<T> contentType = this.config.getBucketContent();
        if (Number.class.isAssignableFrom(contentType)) {
            if (Byte.class.equals(contentType)) {
                return (T)Byte.valueOf((byte)0);
            }
            if (Short.class.equals(contentType)) {
                return (T)Short.valueOf((short)0);
            }
            if (Integer.class.equals(contentType)) {
                return (T)Integer.valueOf(0);
            }
            if (Long.class.equals(contentType)) {
                return (T)Long.valueOf(0L);
            }
            if (Double.class.equals(contentType)) {
                return (T)Double.valueOf(0.0);
            }
            if (Float.class.equals(contentType)) {
                return (T)Float.valueOf(0.0f);
            }
            if (BigDecimal.class.equals(contentType)) {
                return (T)BigDecimal.valueOf(0L);
            }
            if (BigInteger.class.equals(contentType)) {
                return (T)BigInteger.valueOf(0L);
            }
            if (AtomicInteger.class.equals(contentType)) {
                return (T)new AtomicInteger(0);
            }
            if (AtomicLong.class.equals(contentType)) {
                return (T)new AtomicLong(0L);
            }
            return null;
        }
        return null;
    }

    public BucketTimeSeriesConfig<T> getConfig() {
        return this.config;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            final int currentIdx;
            final int size;
            int offset;
            {
                this.currentIdx = BucketTimeSeries.this.getNowIdx();
                this.size = BucketTimeSeries.this.config.getTimeSeriesSize();
                this.offset = 0;
            }

            @Override
            public boolean hasNext() {
                return this.offset < this.size;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    int idx = BucketTimeSeries.this.idx((long)this.currentIdx + (long)this.offset);
                    ++this.offset;
                    return BucketTimeSeries.this.timeSeries[idx];
                }
                throw new NoSuchElementException("No further elements available.");
            }
        };
    }

    public long getNow() {
        if (this.now == null) {
            return -1L;
        }
        return this.now.getUnixTimeStampEnd() - 1L;
    }

    public void setNow(long unixTimeStamp) throws IllegalTimePointMovement {
        if (this.currentNowIdx == -1 || this.now == null) {
            this.currentNowIdx = 0;
            this.now = this.normalizeUnixTimeStamp(unixTimeStamp);
        } else {
            BucketEndPoints newNow = this.normalizeUnixTimeStamp(unixTimeStamp);
            long diff = this.now.diff(newNow);
            if (diff < 0L) {
                throw new IllegalTimePointMovement(String.format("Cannot move to the past (current: %s, update: %s)", this.now, newNow));
            }
            if (diff > 0L) {
                int newCurrentNowIdx = this.idx((long)this.currentNowIdx - diff);
                if (diff >= (long)this.config.getTimeSeriesSize()) {
                    this.fill(-1, -1);
                } else if (newCurrentNowIdx > this.currentNowIdx) {
                    this.fill(0, this.currentNowIdx);
                    this.fill(newCurrentNowIdx, -1);
                } else {
                    this.fill(newCurrentNowIdx, this.currentNowIdx);
                }
                this.currentNowIdx = newCurrentNowIdx;
                this.now = newNow;
            }
        }
    }

    public void setTimeSeries(T[] timeSeries, long now) {
        this.now = this.normalizeUnixTimeStamp(now);
        this.currentNowIdx = 0;
        this.timeSeries = timeSeries;
    }

    public void combine(BucketTimeSeries<T> timeSeries) throws IllegalConfiguration {
        this.combine(timeSeries, this::addition);
    }

    public void combine(BucketTimeSeries<T> timeSeries, BiFunction<T, T, T> cmb) throws IllegalConfiguration {
        BucketTimeSeries syncedTs = this.sync(timeSeries, ts -> new BucketTimeSeries(ts.getConfig(), ts.timeSeries, ts.getNow()));
        for (int i = 0; i < this.config.getTimeSeriesSize(); ++i) {
            int idx = this.idx(this.currentNowIdx + i);
            this.set(idx, (T)((Serializable)cmb.apply(this.get(idx), syncedTs.get(syncedTs.idx(syncedTs.currentNowIdx + i)))));
        }
    }

    protected <B extends BucketTimeSeries<T>> B sync(B timeSeries, Function<B, B> copy) throws IllegalConfiguration {
        Object ts;
        if (!Objects.equals(timeSeries.config, this.config)) {
            throw new IllegalConfiguration("The time-series to combine must have the same configuration.");
        }
        int cmp = Long.compare(this.getNow(), timeSeries.getNow());
        if (cmp != 0 && this.getNow() == -1L) {
            ts = timeSeries;
            this.setNow(timeSeries.getNow());
        } else if (cmp != 0 && timeSeries.getNow() == -1L) {
            ts = timeSeries;
        } else if (cmp == 0) {
            ts = timeSeries;
        } else if (cmp > 0) {
            ts = (BucketTimeSeries)copy.apply(timeSeries);
            ((BucketTimeSeries)ts).setNow(this.getNow());
        } else {
            this.setNow(timeSeries.getNow());
            ts = timeSeries;
        }
        return (B)ts;
    }

    public String toString() {
        return Arrays.toString(this.order());
    }

    public T addition(T a, T b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return this.addition(this.zero(), b);
        }
        if (b == null) {
            return this.addition(a, this.zero());
        }
        Class<?> contentType = a.getClass();
        if (Number.class.isAssignableFrom(contentType)) {
            if (Byte.class.equals(contentType)) {
                return (T)Byte.valueOf(Integer.valueOf((Byte)Byte.class.cast(a) + (Byte)Byte.class.cast(b)).byteValue());
            }
            if (Short.class.equals(contentType)) {
                return (T)Short.valueOf(Integer.valueOf((Short)Short.class.cast(a) + (Short)Short.class.cast(b)).shortValue());
            }
            if (Integer.class.equals(contentType)) {
                return (T)Integer.valueOf((Integer)Integer.class.cast(a) + (Integer)Integer.class.cast(b));
            }
            if (Long.class.equals(contentType)) {
                return (T)Long.valueOf((Long)Long.class.cast(a) + (Long)Long.class.cast(b));
            }
            if (Double.class.equals(contentType)) {
                return (T)Double.valueOf((Double)Double.class.cast(a) + (Double)Double.class.cast(b));
            }
            if (Float.class.equals(contentType)) {
                return (T)Float.valueOf(((Float)Float.class.cast(a)).floatValue() + ((Float)Float.class.cast(b)).floatValue());
            }
            if (BigDecimal.class.equals(contentType)) {
                return (T)((BigDecimal)BigDecimal.class.cast(a)).add((BigDecimal)BigDecimal.class.cast(b));
            }
            if (BigInteger.class.equals(contentType)) {
                return (T)((BigInteger)BigInteger.class.cast(a)).add((BigInteger)BigInteger.class.cast(b));
            }
            if (AtomicInteger.class.equals(contentType)) {
                int intA = ((AtomicInteger)AtomicInteger.class.cast(a)).intValue();
                int intB = ((AtomicInteger)AtomicInteger.class.cast(b)).intValue();
                return (T)new AtomicInteger(intA + intB);
            }
            if (AtomicLong.class.equals(contentType)) {
                long longA = ((AtomicLong)AtomicLong.class.cast(a)).longValue();
                long longB = ((AtomicLong)AtomicLong.class.cast(b)).longValue();
                return (T)new AtomicLong(longA + longB);
            }
            return null;
        }
        if (String.class.isAssignableFrom(contentType)) {
            return (T)((String)String.class.cast(a) + (String)String.class.cast(b));
        }
        if (List.class.isAssignableFrom(contentType)) {
            ArrayList list = new ArrayList();
            list.addAll((Collection)List.class.cast(a));
            list.addAll((Collection)List.class.cast(b));
            return (T)list;
        }
        if (Set.class.isAssignableFrom(contentType)) {
            HashSet set = new HashSet();
            set.addAll((Collection)Set.class.cast(a));
            set.addAll((Collection)Set.class.cast(b));
            return (T)set;
        }
        return null;
    }

    public long sumTimeSeries() {
        long totalSum = 0L;
        for (T i : this.timeSeries) {
            totalSum += ((Number)i).longValue();
        }
        return totalSum;
    }
}

