/*
 * Decompiled with CFR 0.152.
 */
package com.brein.time.timeseries.gson;

import com.brein.time.timeseries.BucketTimeSeries;
import com.brein.time.timeseries.BucketTimeSeriesConfig;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.log4j.Logger;

public class TypeConverterHelper {
    private static final Logger LOG = Logger.getLogger(TypeConverterHelper.class);

    public static JsonObject serialize(BucketTimeSeries<?> o, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("timeUnit", context.serialize((Object)o.getConfig().getTimeUnit()));
        jsonObject.add("bucketSize", context.serialize((Object)o.getConfig().getBucketSize()));
        jsonObject.add("bucketContent", TypeConverterHelper.serializeClass(o.getConfig().getBucketContent(), context));
        jsonObject.add("fillNumberWithZero", context.serialize((Object)o.getConfig().isFillNumberWithZero()));
        jsonObject.add("timeSeries", context.serialize((Object)o.order()));
        jsonObject.add("now", context.serialize((Object)o.getNow()));
        return jsonObject;
    }

    public static Object[] deserialize(JsonElement jsonElement, JsonDeserializationContext context) {
        return TypeConverterHelper.deserialize(jsonElement, context, (bucketContent, el) -> (Serializable[])context.deserialize(el, TypeConverterHelper.arrayClass(bucketContent)));
    }

    public static Object[] deserialize(JsonElement jsonElement, JsonDeserializationContext context, BiFunction<Class<?>, JsonElement, Serializable[]> timeSeriesDeserializer) {
        Class bucketContent;
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("Trying to deserialize the element '%s'.", jsonElement.toString()));
        }
        if ((bucketContent = TypeConverterHelper.resolveClass("bucketContent", jsonObject, context)) == null) {
            return null;
        }
        TimeUnit timeUnit = (TimeUnit)((Object)context.deserialize(jsonObject.get("timeUnit"), TimeUnit.class));
        int bucketSize = (Integer)context.deserialize(jsonObject.get("bucketSize"), Integer.TYPE);
        boolean fillNumberWithZero = (Boolean)context.deserialize(jsonObject.get("fillNumberWithZero"), Boolean.TYPE);
        Long now = (Long)context.deserialize(jsonObject.get("now"), Long.class);
        Serializable[] timeSeries = timeSeriesDeserializer.apply(bucketContent, jsonObject.get("timeSeries"));
        BucketTimeSeriesConfig config = new BucketTimeSeriesConfig(bucketContent, timeUnit, timeSeries.length, bucketSize, fillNumberWithZero);
        return new Object[]{config, timeSeries, now};
    }

    public static <T> Class<T> resolveClass(String key, JsonObject jsonObject, JsonDeserializationContext context) {
        String clazz = (String)context.deserialize(jsonObject.get(key), String.class);
        if (clazz == null) {
            return null;
        }
        try {
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new JsonParseException("Cannot resolve class.", (Throwable)e);
        }
    }

    public static JsonElement serializeClass(Class<?> clazz, JsonSerializationContext context) {
        return context.serialize((Object)(clazz == null ? Object.class : clazz).getCanonicalName());
    }

    public static Class<?> arrayClass(Class<?> clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }
}

