/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup;

import com.browserup.bup.BrowserUpProxy;
import com.browserup.bup.assertion.HarEntryAssertion;
import com.browserup.bup.assertion.ResponseTimeLessThanOrEqualAssertion;
import com.browserup.bup.assertion.error.HarEntryAssertionError;
import com.browserup.bup.assertion.field.content.ContentContainsStringAssertion;
import com.browserup.bup.assertion.field.content.ContentDoesNotContainStringAssertion;
import com.browserup.bup.assertion.field.content.ContentMatchesAssertion;
import com.browserup.bup.assertion.field.content.ContentSizeLessThanOrEqualAssertion;
import com.browserup.bup.assertion.field.header.FilteredHeadersContainStringAssertion;
import com.browserup.bup.assertion.field.header.FilteredHeadersDoNotContainStringAssertion;
import com.browserup.bup.assertion.field.header.FilteredHeadersMatchAssertion;
import com.browserup.bup.assertion.field.header.HeadersContainStringAssertion;
import com.browserup.bup.assertion.field.header.HeadersDoNotContainStringAssertion;
import com.browserup.bup.assertion.field.header.HeadersMatchAssertion;
import com.browserup.bup.assertion.field.header.HeadersPassPredicateAssertion;
import com.browserup.bup.assertion.field.status.StatusBelongsToClassAssertion;
import com.browserup.bup.assertion.field.status.StatusEqualsAssertion;
import com.browserup.bup.assertion.model.AssertionEntryResult;
import com.browserup.bup.assertion.model.AssertionResult;
import com.browserup.bup.assertion.supplier.CurrentStepHarEntriesSupplier;
import com.browserup.bup.assertion.supplier.HarEntriesSupplier;
import com.browserup.bup.assertion.supplier.MostRecentHarEntrySupplier;
import com.browserup.bup.assertion.supplier.MostRecentUrlFilteredHarEntrySupplier;
import com.browserup.bup.assertion.supplier.UrlFilteredHarEntriesSupplier;
import com.browserup.bup.client.ClientUtil;
import com.browserup.bup.filters.AddHeadersFilter;
import com.browserup.bup.filters.AutoBasicAuthFilter;
import com.browserup.bup.filters.BlacklistFilter;
import com.browserup.bup.filters.BrowserUpHttpFilterChain;
import com.browserup.bup.filters.HarCaptureFilter;
import com.browserup.bup.filters.HttpConnectHarCaptureFilter;
import com.browserup.bup.filters.HttpsHostCaptureFilter;
import com.browserup.bup.filters.HttpsOriginalHostCaptureFilter;
import com.browserup.bup.filters.LatencyFilter;
import com.browserup.bup.filters.RegisterRequestFilter;
import com.browserup.bup.filters.RequestFilter;
import com.browserup.bup.filters.RequestFilterAdapter;
import com.browserup.bup.filters.ResolvedHostnameCacheFilter;
import com.browserup.bup.filters.ResponseFilter;
import com.browserup.bup.filters.ResponseFilterAdapter;
import com.browserup.bup.filters.RewriteUrlFilter;
import com.browserup.bup.filters.UnregisterRequestFilter;
import com.browserup.bup.filters.WhitelistFilter;
import com.browserup.bup.mitm.CertificateAndKeySource;
import com.browserup.bup.mitm.KeyStoreFileCertificateSource;
import com.browserup.bup.mitm.TrustSource;
import com.browserup.bup.mitm.keys.ECKeyGenerator;
import com.browserup.bup.mitm.keys.KeyGenerator;
import com.browserup.bup.mitm.keys.RSAKeyGenerator;
import com.browserup.bup.mitm.manager.ImpersonatingMitmManager;
import com.browserup.bup.proxy.ActivityMonitor;
import com.browserup.bup.proxy.BlacklistEntry;
import com.browserup.bup.proxy.CaptureType;
import com.browserup.bup.proxy.RewriteRule;
import com.browserup.bup.proxy.Whitelist;
import com.browserup.bup.proxy.auth.AuthType;
import com.browserup.bup.proxy.dns.AdvancedHostResolver;
import com.browserup.bup.proxy.dns.DelegatingHostResolver;
import com.browserup.bup.util.BrowserUpHttpUtil;
import com.browserup.bup.util.BrowserUpProxyUtil;
import com.browserup.bup.util.HttpStatusClass;
import com.browserup.harreader.model.Har;
import com.browserup.harreader.model.HarCreatorBrowser;
import com.browserup.harreader.model.HarEntry;
import com.browserup.harreader.model.HarLog;
import com.browserup.harreader.model.HarPage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapMaker;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;
import org.apache.commons.lang3.StringUtils;
import org.littleshoot.proxy.ChainedProxy;
import org.littleshoot.proxy.ChainedProxyAdapter;
import org.littleshoot.proxy.ChainedProxyManager;
import org.littleshoot.proxy.HostResolver;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.HttpFiltersSource;
import org.littleshoot.proxy.HttpFiltersSourceAdapter;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.HttpProxyServerBootstrap;
import org.littleshoot.proxy.MitmManager;
import org.littleshoot.proxy.extras.SelfSignedSslEngineSource;
import org.littleshoot.proxy.impl.ClientDetails;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;
import org.littleshoot.proxy.impl.ProxyUtils;
import org.littleshoot.proxy.impl.ThreadPoolConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserUpProxyServer
implements BrowserUpProxy {
    private static final Logger log = LoggerFactory.getLogger(BrowserUpProxyServer.class);
    private static final Object LOCK = new Object();
    private static final Object GET_HAR_LOCK = new Object();
    public static final String DEFAULT_PAGE_REF = "Default";
    public static final String DEFAULT_PAGE_TITLE = "Default";
    private static final HarCreatorBrowser HAR_CREATOR_VERSION = new HarCreatorBrowser();
    private static final String RSA_KEYSTORE_RESOURCE = "/sslSupport/ca-keystore-rsa.p12";
    private static final String EC_KEYSTORE_RESOURCE = "/sslSupport/ca-keystore-ec.p12";
    private static final String KEYSTORE_TYPE = "PKCS12";
    private static final String KEYSTORE_PRIVATE_KEY_ALIAS = "key";
    private static final String KEYSTORE_PASSWORD = "password";
    public static final String VIA_HEADER_ALIAS = "BrowserUpProxy";
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final AtomicInteger harPageCount = new AtomicInteger(0);
    private volatile boolean mitmDisabled = false;
    private volatile MitmManager mitmManager;
    private final List<HttpFiltersSource> filterFactories = new CopyOnWriteArrayList<HttpFiltersSource>();
    private volatile Collection<BlacklistEntry> blacklistEntries = new CopyOnWriteArrayList<BlacklistEntry>();
    private volatile CopyOnWriteArrayList<RewriteRule> rewriteRules = new CopyOnWriteArrayList();
    private volatile HttpProxyServer proxyServer;
    private volatile EnumSet<CaptureType> harCaptureTypes = EnumSet.noneOf(CaptureType.class);
    private volatile Har har;
    private volatile HarPage currentHarPage;
    private volatile long readBandwidthLimitBps;
    private volatile long writeBandwidthLimitBps;
    private final AtomicReference<Whitelist> whitelist = new AtomicReference<Whitelist>(Whitelist.WHITELIST_DISABLED);
    private volatile ConcurrentMap<String, String> additionalHeaders = new MapMaker().concurrencyLevel(1).makeMap();
    private volatile int connectTimeoutMs;
    private volatile int idleConnectionTimeoutSec;
    private volatile int latencyMs;
    private final AtomicBoolean harCaptureFilterEnabled = new AtomicBoolean(false);
    private final AtomicBoolean bootstrappedWithDefaultChainedProxy = new AtomicBoolean(false);
    private volatile InetSocketAddress upstreamProxyAddress;
    private volatile boolean upstreamProxyHTTPS;
    private List<String> upstreamProxyNonProxyHosts;
    private volatile ChainedProxyManager chainedProxyManager;
    private volatile InetAddress serverBindAddress;
    private volatile TrustSource trustSource = TrustSource.defaultTrustSource();
    private volatile boolean useEcc = false;
    private final DelegatingHostResolver delegatingResolver = new DelegatingHostResolver(ClientUtil.createNativeCacheManipulatingResolver());
    private final ActivityMonitor activityMonitor = new ActivityMonitor();
    private volatile ThreadPoolConfiguration threadPoolConfiguration;
    private final ConcurrentMap<String, String> basicAuthCredentials = new MapMaker().concurrencyLevel(1).makeMap();
    private volatile String chainedProxyCredentials;

    @Override
    public void start(int port, InetAddress clientBindAddress, InetAddress serverBindAddress) {
        boolean notStarted = this.started.compareAndSet(false, true);
        if (!notStarted) {
            throw new IllegalStateException("Proxy server is already started. Not restarting.");
        }
        InetSocketAddress clientBindSocket = clientBindAddress == null ? new InetSocketAddress(port) : new InetSocketAddress(clientBindAddress, port);
        this.serverBindAddress = serverBindAddress;
        this.addBrowserUpFilters();
        HttpProxyServerBootstrap bootstrap = DefaultHttpProxyServer.bootstrap().withFiltersSource(new HttpFiltersSource(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext channelHandlerContext) {
                return new BrowserUpHttpFilterChain(BrowserUpProxyServer.this, originalRequest, channelHandlerContext);
            }

            public int getMaximumRequestBufferSizeInBytes() {
                return BrowserUpProxyServer.this.getMaximumRequestBufferSize();
            }

            public int getMaximumResponseBufferSizeInBytes() {
                return BrowserUpProxyServer.this.getMaximumResponseBufferSize();
            }
        }).withServerResolver((HostResolver)this.delegatingResolver).withAddress(clientBindSocket).withConnectTimeout(this.connectTimeoutMs).withIdleConnectionTimeout(this.idleConnectionTimeoutSec).withProxyAlias(VIA_HEADER_ALIAS);
        if (serverBindAddress != null) {
            bootstrap.withNetworkInterface(new InetSocketAddress(serverBindAddress, 0));
        }
        if (!this.mitmDisabled) {
            if (this.mitmManager == null) {
                this.mitmManager = ImpersonatingMitmManager.builder().rootCertificateSource((CertificateAndKeySource)new KeyStoreFileCertificateSource(KEYSTORE_TYPE, this.useEcc ? EC_KEYSTORE_RESOURCE : RSA_KEYSTORE_RESOURCE, KEYSTORE_PRIVATE_KEY_ALIAS, KEYSTORE_PASSWORD)).serverKeyGenerator((KeyGenerator)(this.useEcc ? new ECKeyGenerator() : new RSAKeyGenerator())).trustSource(this.trustSource).build();
            }
            bootstrap.withManInTheMiddle(this.mitmManager);
        }
        if (this.readBandwidthLimitBps > 0L || this.writeBandwidthLimitBps > 0L) {
            bootstrap.withThrottling(this.readBandwidthLimitBps, this.writeBandwidthLimitBps);
        }
        if (this.chainedProxyManager != null) {
            bootstrap.withChainProxyManager(this.chainedProxyManager);
        } else if (this.upstreamProxyAddress != null) {
            this.bootstrappedWithDefaultChainedProxy.set(true);
            bootstrap.withChainProxyManager(new ChainedProxyManager(){

                public void lookupChainedProxies(HttpRequest httpRequest, Queue<ChainedProxy> chainedProxies, ClientDetails clientDetails) {
                    final InetSocketAddress upstreamProxy = BrowserUpProxyServer.this.upstreamProxyAddress;
                    if (upstreamProxy != null) {
                        final boolean useEncryption = BrowserUpProxyServer.this.upstreamProxyHTTPS;
                        List nonProxyHosts = BrowserUpProxyServer.this.upstreamProxyNonProxyHosts;
                        URL url = null;
                        try {
                            url = new URL(httpRequest.uri());
                        }
                        catch (MalformedURLException e) {
                            log.error("The requested URL is not valid.", (Throwable)e);
                        }
                        URL finalUrl = url;
                        if (nonProxyHosts != null && finalUrl != null && nonProxyHosts.stream().anyMatch(nph -> finalUrl.getHost().matches(nph.trim().replace("*", ".*?")))) {
                            chainedProxies.add(ChainedProxyAdapter.FALLBACK_TO_DIRECT_CONNECTION);
                        } else {
                            chainedProxies.add((ChainedProxy)new ChainedProxyAdapter(){

                                public InetSocketAddress getChainedProxyAddress() {
                                    return upstreamProxy;
                                }

                                public void filterRequest(HttpObject httpObject) {
                                    String chainedProxyAuth = BrowserUpProxyServer.this.chainedProxyCredentials;
                                    if (chainedProxyAuth != null && httpObject instanceof HttpRequest && (ProxyUtils.isCONNECT((HttpObject)httpObject) || !((HttpRequest)httpObject).uri().startsWith("/"))) {
                                        HttpHeaders.addHeader((HttpMessage)((HttpRequest)httpObject), (CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Object)("Basic " + chainedProxyAuth));
                                    }
                                }

                                public boolean requiresEncryption() {
                                    return useEncryption;
                                }

                                public SSLEngine newSslEngine() {
                                    if (useEncryption) {
                                        return new SelfSignedSslEngineSource(true, false).newSslEngine();
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                }
            });
        }
        if (this.threadPoolConfiguration != null) {
            bootstrap.withThreadPoolConfiguration(this.threadPoolConfiguration);
        }
        this.proxyServer = bootstrap.start();
        this.addHarCaptureFilter();
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public void start(int port) {
        this.start(port, null, null);
    }

    @Override
    public void start(int port, InetAddress bindAddress) {
        this.start(port, bindAddress, null);
    }

    @Override
    public void start() {
        this.start(0);
    }

    @Override
    public void stop() {
        this.stop(true);
    }

    @Override
    public void abort() {
        this.stop(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void stop(boolean graceful) {
        if (!this.isStarted()) throw new IllegalStateException("Proxy server has not been started");
        if (!this.stopped.compareAndSet(false, true)) throw new IllegalStateException("Proxy server is already stopped. Cannot re-stop.");
        if (this.proxyServer != null) {
            if (graceful) {
                this.proxyServer.stop();
                return;
            } else {
                this.proxyServer.abort();
            }
            return;
        } else {
            log.warn("Attempted to stop proxy server, but proxy was never successfully started.");
        }
    }

    @Override
    public InetAddress getClientBindAddress() {
        if (this.started.get()) {
            return this.proxyServer.getListenAddress().getAddress();
        }
        return null;
    }

    @Override
    public int getPort() {
        if (this.started.get()) {
            return this.proxyServer.getListenAddress().getPort();
        }
        return 0;
    }

    @Override
    public InetAddress getServerBindAddress() {
        return this.serverBindAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Har getHar() {
        Object object = GET_HAR_LOCK;
        synchronized (object) {
            return this.har;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Har getHar(boolean cleanHar) {
        if (!cleanHar) {
            return this.har;
        }
        Object object = GET_HAR_LOCK;
        synchronized (object) {
            return this.newHar();
        }
    }

    @Override
    public Har newHar() {
        return this.newHar(null);
    }

    @Override
    public Har newHar(String initialPageRef) {
        return this.newHar(initialPageRef, null);
    }

    @Override
    public Har newHar(String initialPageRef, String initialPageTitle) {
        return this.newHar(initialPageRef, initialPageTitle, true);
    }

    private Har newHar(String initialPageRef, String initialPageTitle, boolean createPage) {
        Har oldHar = this.endHar();
        this.addHarCaptureFilter();
        this.harPageCount.set(0);
        this.har = new Har();
        HarLog harLog = new HarLog();
        this.har.setLog(harLog);
        harLog.setCreator(HAR_CREATOR_VERSION);
        if (createPage) {
            this.newPage(initialPageRef, initialPageTitle);
        }
        return oldHar;
    }

    @Override
    public void setHarCaptureTypes(Set<CaptureType> harCaptureSettings) {
        this.harCaptureTypes = harCaptureSettings == null || harCaptureSettings.isEmpty() ? EnumSet.noneOf(CaptureType.class) : EnumSet.copyOf(harCaptureSettings);
    }

    @Override
    public void setHarCaptureTypes(CaptureType ... captureTypes) {
        if (captureTypes == null) {
            this.setHarCaptureTypes(EnumSet.noneOf(CaptureType.class));
        } else {
            this.setHarCaptureTypes(EnumSet.copyOf(Arrays.asList(captureTypes)));
        }
    }

    @Override
    public EnumSet<CaptureType> getHarCaptureTypes() {
        return EnumSet.copyOf(this.harCaptureTypes);
    }

    @Override
    public void enableHarCaptureTypes(Set<CaptureType> captureTypes) {
        this.harCaptureTypes.addAll(captureTypes);
    }

    @Override
    public void enableHarCaptureTypes(CaptureType ... captureTypes) {
        if (captureTypes == null) {
            this.enableHarCaptureTypes(EnumSet.noneOf(CaptureType.class));
        } else {
            this.enableHarCaptureTypes(EnumSet.copyOf(Arrays.asList(captureTypes)));
        }
    }

    @Override
    public void disableHarCaptureTypes(Set<CaptureType> captureTypes) {
        this.harCaptureTypes.removeAll(captureTypes);
    }

    @Override
    public void disableHarCaptureTypes(CaptureType ... captureTypes) {
        if (captureTypes == null) {
            this.disableHarCaptureTypes(EnumSet.noneOf(CaptureType.class));
        } else {
            this.disableHarCaptureTypes(EnumSet.copyOf(Arrays.asList(captureTypes)));
        }
    }

    @Override
    public Har newPage() {
        return this.newPage(null);
    }

    @Override
    public Har newPage(String pageRef) {
        return this.newPage(pageRef, null);
    }

    @Override
    public Har newPage(String pageRef, String pageTitle) {
        this.har = this.getOrCreateHar(pageRef, pageTitle, false);
        Har endOfPageHar = null;
        if (this.currentHarPage != null) {
            String currentPageRef = this.currentHarPage.getId();
            this.endPage();
            endOfPageHar = BrowserUpProxyUtil.copyHarThroughPageRef(this.har, currentPageRef);
        }
        if (pageRef == null) {
            pageRef = "Page " + this.harPageCount.getAndIncrement();
        }
        if (pageTitle == null) {
            pageTitle = pageRef;
        }
        HarPage newPage = new HarPage();
        newPage.setTitle(pageTitle);
        newPage.setId(pageRef);
        newPage.setStartedDateTime(new Date());
        this.har.getLog().getPages().add(newPage);
        this.currentHarPage = newPage;
        return endOfPageHar;
    }

    @Override
    public Har endHar() {
        Har oldHar = this.getHar();
        if (oldHar == null) {
            return null;
        }
        this.endPage();
        this.har = null;
        return oldHar;
    }

    @Override
    public void setReadBandwidthLimit(long bytesPerSecond) {
        this.readBandwidthLimitBps = bytesPerSecond;
        if (this.isStarted()) {
            this.proxyServer.setThrottle(this.readBandwidthLimitBps, this.writeBandwidthLimitBps);
        }
    }

    @Override
    public long getReadBandwidthLimit() {
        return this.readBandwidthLimitBps;
    }

    @Override
    public void setWriteBandwidthLimit(long bytesPerSecond) {
        this.writeBandwidthLimitBps = bytesPerSecond;
        if (this.isStarted()) {
            this.proxyServer.setThrottle(this.readBandwidthLimitBps, this.writeBandwidthLimitBps);
        }
    }

    private void updateDefaultPageTimings() {
        this.getDefaultPage().ifPresent(page -> {
            if (page.getStartedDateTime() != null) {
                page.getPageTimings().setOnLoad(Math.toIntExact(new Date().getTime() - page.getStartedDateTime().getTime()));
            }
        });
    }

    @Override
    public long getWriteBandwidthLimit() {
        return this.writeBandwidthLimitBps;
    }

    public void endPage() {
        if (this.har == null) {
            return;
        }
        HarPage previousPage = this.currentHarPage;
        this.currentHarPage = null;
        if (previousPage == null) {
            return;
        }
        if (previousPage.getStartedDateTime() != null) {
            previousPage.getPageTimings().setOnLoad(Math.toIntExact(new Date().getTime() - previousPage.getStartedDateTime().getTime()));
        }
        this.updateDefaultPageTimings();
    }

    @Override
    public void addHeaders(Map<String, String> headers) {
        ConcurrentMap newHeaders = new MapMaker().concurrencyLevel(1).makeMap();
        newHeaders.putAll(headers);
        this.additionalHeaders = newHeaders;
    }

    @Override
    public void setLatency(long latency, TimeUnit timeUnit) {
        this.latencyMs = (int)TimeUnit.MILLISECONDS.convert(latency, timeUnit);
    }

    @Override
    public void autoAuthorization(String domain, String username, String password, AuthType authType) {
        switch (authType) {
            case BASIC: {
                String base64EncodedCredentials = BrowserUpHttpUtil.base64EncodeBasicCredentials(username, password);
                this.basicAuthCredentials.put(domain, base64EncodedCredentials);
                break;
            }
            default: {
                throw new UnsupportedOperationException("AuthType " + (Object)((Object)authType) + " is not supported for HTTP Authorization");
            }
        }
    }

    @Override
    public void stopAutoAuthorization(String domain) {
        this.basicAuthCredentials.remove(domain);
    }

    @Override
    public void chainedProxyAuthorization(String username, String password, AuthType authType) {
        switch (authType) {
            case BASIC: {
                this.chainedProxyCredentials = BrowserUpHttpUtil.base64EncodeBasicCredentials(username, password);
                break;
            }
            default: {
                throw new UnsupportedOperationException("AuthType " + (Object)((Object)authType) + " is not supported for Proxy Authorization");
            }
        }
    }

    @Override
    public void setConnectTimeout(int connectTimeout, TimeUnit timeUnit) {
        this.connectTimeoutMs = (int)TimeUnit.MILLISECONDS.convert(connectTimeout, timeUnit);
        if (this.isStarted()) {
            this.proxyServer.setConnectTimeout((int)TimeUnit.MILLISECONDS.convert(connectTimeout, timeUnit));
        }
    }

    @Override
    public void setIdleConnectionTimeout(int idleConnectionTimeout, TimeUnit timeUnit) {
        long timeout = TimeUnit.SECONDS.convert(idleConnectionTimeout, timeUnit);
        this.idleConnectionTimeoutSec = timeout == 0L && idleConnectionTimeout > 0 ? 1 : (int)timeout;
        if (this.isStarted()) {
            this.proxyServer.setIdleConnectionTimeout(this.idleConnectionTimeoutSec);
        }
    }

    @Override
    public void setRequestTimeout(int requestTimeout, TimeUnit timeUnit) {
        if (this.idleConnectionTimeoutSec == 0 || (long)this.idleConnectionTimeoutSec > TimeUnit.SECONDS.convert(requestTimeout, timeUnit)) {
            this.setIdleConnectionTimeout(requestTimeout, timeUnit);
        }
    }

    @Override
    public void rewriteUrl(String pattern, String replace) {
        this.rewriteRules.add(new RewriteRule(pattern, replace));
    }

    @Override
    public void rewriteUrls(Map<String, String> rewriteRules) {
        this.rewriteRules = rewriteRules.entrySet().stream().map(rewriteRule -> new RewriteRule((String)rewriteRule.getKey(), (String)rewriteRule.getValue())).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
    }

    @Override
    public void clearRewriteRules() {
        this.rewriteRules.clear();
    }

    @Override
    public void blacklistRequests(String pattern, int responseCode) {
        this.blacklistEntries.add(new BlacklistEntry(pattern, responseCode));
    }

    @Override
    public void blacklistRequests(String pattern, int responseCode, String method) {
        this.blacklistEntries.add(new BlacklistEntry(pattern, responseCode, method));
    }

    @Override
    public void setBlacklist(Collection<BlacklistEntry> blacklist) {
        this.blacklistEntries = new CopyOnWriteArrayList<BlacklistEntry>(blacklist);
    }

    @Override
    public Collection<BlacklistEntry> getBlacklist() {
        return Collections.unmodifiableCollection(this.blacklistEntries);
    }

    @Override
    public boolean isWhitelistEnabled() {
        return this.whitelist.get().isEnabled();
    }

    @Override
    public Collection<String> getWhitelistUrls() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.whitelist.get().getPatterns().stream().map(Pattern::pattern).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Override
    public int getWhitelistStatusCode() {
        return this.whitelist.get().getStatusCode();
    }

    @Override
    public void clearBlacklist() {
        this.blacklistEntries.clear();
    }

    @Override
    public void whitelistRequests(Collection<String> urlPatterns, int statusCode) {
        this.whitelist.set(new Whitelist(urlPatterns, statusCode));
    }

    @Override
    public void addWhitelistPattern(String urlPattern) {
        boolean whitelistUpdated = false;
        while (!whitelistUpdated) {
            Whitelist currentWhitelist = this.whitelist.get();
            if (!currentWhitelist.isEnabled()) {
                throw new IllegalStateException("Whitelist is disabled. Cannot add patterns to a disabled whitelist.");
            }
            int statusCode = currentWhitelist.getStatusCode();
            List newPatterns = currentWhitelist.getPatterns().stream().map(Pattern::pattern).collect(Collectors.toCollection(() -> new ArrayList(currentWhitelist.getPatterns().size() + 1)));
            newPatterns.add(urlPattern);
            Whitelist newWhitelist = new Whitelist(newPatterns, statusCode);
            whitelistUpdated = this.whitelist.compareAndSet(currentWhitelist, newWhitelist);
        }
    }

    public void whitelistRequests(String[] patterns, int responseCode) {
        if (patterns == null || patterns.length == 0) {
            this.enableEmptyWhitelist(responseCode);
        } else {
            this.whitelistRequests(Arrays.asList(patterns), responseCode);
        }
    }

    @Override
    public void enableEmptyWhitelist(int statusCode) {
        this.whitelist.set(new Whitelist(statusCode));
    }

    @Override
    public void disableWhitelist() {
        this.whitelist.set(Whitelist.WHITELIST_DISABLED);
    }

    @Override
    public void addHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
    }

    @Override
    public void removeHeader(String name) {
        this.additionalHeaders.remove(name);
    }

    @Override
    public void removeAllHeaders() {
        this.additionalHeaders.clear();
    }

    @Override
    public Map<String, String> getAllHeaders() {
        return ImmutableMap.copyOf(this.additionalHeaders);
    }

    @Override
    public void setHostNameResolver(AdvancedHostResolver resolver) {
        this.delegatingResolver.setResolver(resolver);
    }

    @Override
    public AdvancedHostResolver getHostNameResolver() {
        return this.delegatingResolver.getResolver();
    }

    @Override
    public boolean waitForQuiescence(long quietPeriod, long timeout, TimeUnit timeUnit) {
        return this.activityMonitor.waitForQuiescence(quietPeriod, timeout, timeUnit);
    }

    @Override
    public void setChainedProxy(InetSocketAddress chainedProxyAddress) {
        if (this.isStarted() && !this.bootstrappedWithDefaultChainedProxy.get()) {
            throw new IllegalStateException("Cannot set a chained proxy after the proxy is started if the proxy was started without a chained proxy.");
        }
        this.upstreamProxyAddress = chainedProxyAddress;
    }

    @Override
    public void setChainedProxyHTTPS(boolean chainedProxyHTTPS) {
        this.upstreamProxyHTTPS = chainedProxyHTTPS;
    }

    @Override
    public InetSocketAddress getChainedProxy() {
        return this.upstreamProxyAddress;
    }

    public void setChainedProxyManager(ChainedProxyManager chainedProxyManager) {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot configure chained proxy manager after proxy has started.");
        }
        this.chainedProxyManager = chainedProxyManager;
    }

    @Override
    public void setChainedProxyNonProxyHosts(List<String> upstreamNonProxyHosts) {
        this.upstreamProxyNonProxyHosts = upstreamNonProxyHosts;
    }

    public void setThreadPoolConfiguration(ThreadPoolConfiguration threadPoolConfiguration) {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot configure thread pool after proxy has started.");
        }
        this.threadPoolConfiguration = threadPoolConfiguration;
    }

    @Override
    public void addFirstHttpFilterFactory(HttpFiltersSource filterFactory) {
        this.filterFactories.add(0, filterFactory);
    }

    @Override
    public void addLastHttpFilterFactory(HttpFiltersSource filterFactory) {
        this.filterFactories.add(filterFactory);
    }

    @Override
    public void addResponseFilter(ResponseFilter filter) {
        this.addLastHttpFilterFactory((HttpFiltersSource)new ResponseFilterAdapter.FilterSource(filter));
    }

    @Override
    public void addRequestFilter(RequestFilter filter) {
        this.addFirstHttpFilterFactory((HttpFiltersSource)new RequestFilterAdapter.FilterSource(filter));
    }

    @Override
    public Map<String, String> getRewriteRules() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.rewriteRules.forEach(rewriteRule -> builder.put((Object)rewriteRule.getPattern().pattern(), (Object)rewriteRule.getReplace()));
        return builder.build();
    }

    @Override
    public void removeRewriteRule(String urlPattern) {
        this.rewriteRules.stream().filter(rewriteRule -> rewriteRule.getPattern().pattern().equals(urlPattern)).forEach(rewriteRule -> this.rewriteRules.remove(rewriteRule));
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public HarPage getCurrentHarPage() {
        return this.currentHarPage;
    }

    public void addHttpFilterFactory(HttpFiltersSource filterFactory) {
        this.filterFactories.add(filterFactory);
    }

    public List<HttpFiltersSource> getFilterFactories() {
        return this.filterFactories;
    }

    @Override
    public void setMitmDisabled(boolean mitmDisabled) throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot disable MITM after the proxy has been started");
        }
        this.mitmDisabled = mitmDisabled;
    }

    @Override
    public void setMitmManager(MitmManager mitmManager) {
        this.mitmManager = mitmManager;
    }

    @Override
    public void setTrustAllServers(boolean trustAllServers) {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot disable upstream server verification after the proxy has been started");
        }
        if (trustAllServers) {
            this.trustSource = null;
        } else if (this.trustSource == null) {
            this.trustSource = TrustSource.defaultTrustSource();
        }
    }

    @Override
    public void setTrustSource(TrustSource trustSource) {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot change TrustSource after proxy has been started");
        }
        this.trustSource = trustSource;
    }

    @Override
    public Optional<HarEntry> findMostRecentEntry(Pattern url) {
        Object entries = new MostRecentUrlFilteredHarEntrySupplier(this.getHar(), url).get();
        return Optional.ofNullable(entries.isEmpty() ? null : (HarEntry)entries.get(0));
    }

    @Override
    public Collection<HarEntry> findEntries(Pattern url) {
        return new UrlFilteredHarEntriesSupplier(this.getHar(), url).get();
    }

    @Override
    public AssertionResult assertMostRecentResponseTimeLessThanOrEqual(Pattern url, long time) {
        MostRecentUrlFilteredHarEntrySupplier supplier = new MostRecentUrlFilteredHarEntrySupplier(this.getHar(), url);
        ResponseTimeLessThanOrEqualAssertion assertion = new ResponseTimeLessThanOrEqualAssertion(time);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertResponseTimeLessThanOrEqual(Pattern url, long time) {
        UrlFilteredHarEntriesSupplier supplier = new UrlFilteredHarEntriesSupplier(this.getHar(), url);
        ResponseTimeLessThanOrEqualAssertion assertion = new ResponseTimeLessThanOrEqualAssertion(time);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertMostRecentResponseContentContains(Pattern url, String text) {
        MostRecentUrlFilteredHarEntrySupplier supplier = new MostRecentUrlFilteredHarEntrySupplier(this.getHar(), url);
        ContentContainsStringAssertion assertion = new ContentContainsStringAssertion(text);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertMostRecentResponseContentDoesNotContain(Pattern url, String text) {
        MostRecentUrlFilteredHarEntrySupplier supplier = new MostRecentUrlFilteredHarEntrySupplier(this.getHar(), url);
        ContentDoesNotContainStringAssertion assertion = new ContentDoesNotContainStringAssertion(text);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertMostRecentResponseContentMatches(Pattern url, Pattern contentPattern) {
        MostRecentUrlFilteredHarEntrySupplier supplier = new MostRecentUrlFilteredHarEntrySupplier(this.getHar(), url);
        ContentMatchesAssertion assertion = new ContentMatchesAssertion(contentPattern);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertAnyUrlContentLengthLessThanOrEquals(Pattern url, Long maxSize) {
        UrlFilteredHarEntriesSupplier supplier = new UrlFilteredHarEntriesSupplier(this.getHar(), url);
        ContentSizeLessThanOrEqualAssertion assertion = new ContentSizeLessThanOrEqualAssertion(maxSize);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertAnyUrlContentMatches(Pattern url, Pattern contentPattern) {
        UrlFilteredHarEntriesSupplier supplier = new UrlFilteredHarEntriesSupplier(this.getHar(), url);
        ContentMatchesAssertion assertion = new ContentMatchesAssertion(contentPattern);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertAnyUrlContentContains(Pattern url, String text) {
        UrlFilteredHarEntriesSupplier supplier = new UrlFilteredHarEntriesSupplier(this.getHar(), url);
        ContentContainsStringAssertion assertion = new ContentContainsStringAssertion(text);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertAnyUrlContentDoesNotContain(Pattern url, String text) {
        UrlFilteredHarEntriesSupplier supplier = new UrlFilteredHarEntriesSupplier(this.getHar(), url);
        ContentDoesNotContainStringAssertion assertion = new ContentDoesNotContainStringAssertion(text);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertAnyUrlResponseHeaderContains(Pattern url, String value) {
        UrlFilteredHarEntriesSupplier supplier = new UrlFilteredHarEntriesSupplier(this.getHar(), url);
        HeadersContainStringAssertion assertion = new HeadersContainStringAssertion(value);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertAnyUrlResponseHeaderContains(Pattern url, String name, String value) {
        UrlFilteredHarEntriesSupplier supplier = new UrlFilteredHarEntriesSupplier(this.getHar(), url);
        HeadersPassPredicateAssertion assertion = StringUtils.isEmpty((CharSequence)name) ? new HeadersContainStringAssertion(value) : new FilteredHeadersContainStringAssertion(name, value);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertAnyUrlResponseHeaderDoesNotContain(Pattern url, String name, String value) {
        UrlFilteredHarEntriesSupplier supplier = new UrlFilteredHarEntriesSupplier(this.getHar(), url);
        HeadersPassPredicateAssertion assertion = StringUtils.isEmpty((CharSequence)name) ? new HeadersDoNotContainStringAssertion(value) : new FilteredHeadersDoNotContainStringAssertion(name, value);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertAnyUrlResponseHeaderDoesNotContain(Pattern url, String value) {
        UrlFilteredHarEntriesSupplier supplier = new UrlFilteredHarEntriesSupplier(this.getHar(), url);
        HeadersDoNotContainStringAssertion assertion = new HeadersDoNotContainStringAssertion(value);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertAnyUrlResponseHeaderMatches(Pattern url, Pattern namePattern, Pattern valuePattern) {
        UrlFilteredHarEntriesSupplier supplier = new UrlFilteredHarEntriesSupplier(this.getHar(), url);
        HeadersPassPredicateAssertion assertion = namePattern == null ? new HeadersMatchAssertion(valuePattern) : new FilteredHeadersMatchAssertion(namePattern, valuePattern);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertResponseStatusCode(Integer status) {
        CurrentStepHarEntriesSupplier supplier = new CurrentStepHarEntriesSupplier(this.getHar());
        StatusEqualsAssertion assertion = new StatusEqualsAssertion(status);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertResponseStatusCode(HttpStatusClass clazz) {
        CurrentStepHarEntriesSupplier supplier = new CurrentStepHarEntriesSupplier(this.getHar());
        StatusBelongsToClassAssertion assertion = new StatusBelongsToClassAssertion(clazz);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertResponseStatusCode(Pattern url, Integer status) {
        UrlFilteredHarEntriesSupplier supplier = new UrlFilteredHarEntriesSupplier(this.getHar(), url);
        StatusEqualsAssertion assertion = new StatusEqualsAssertion(status);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertResponseStatusCode(Pattern url, HttpStatusClass clazz) {
        UrlFilteredHarEntriesSupplier supplier = new UrlFilteredHarEntriesSupplier(this.getHar(), url);
        StatusBelongsToClassAssertion assertion = new StatusBelongsToClassAssertion(clazz);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertMostRecentResponseStatusCode(Integer status) {
        MostRecentHarEntrySupplier supplier = new MostRecentHarEntrySupplier(this.getHar());
        StatusEqualsAssertion assertion = new StatusEqualsAssertion(status);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertMostRecentResponseStatusCode(HttpStatusClass clazz) {
        MostRecentHarEntrySupplier supplier = new MostRecentHarEntrySupplier(this.getHar());
        StatusBelongsToClassAssertion assertion = new StatusBelongsToClassAssertion(clazz);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertMostRecentResponseStatusCode(Pattern url, Integer status) {
        MostRecentUrlFilteredHarEntrySupplier supplier = new MostRecentUrlFilteredHarEntrySupplier(this.getHar(), url);
        StatusEqualsAssertion assertion = new StatusEqualsAssertion(status);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertMostRecentResponseStatusCode(Pattern url, HttpStatusClass clazz) {
        MostRecentUrlFilteredHarEntrySupplier supplier = new MostRecentUrlFilteredHarEntrySupplier(this.getHar(), url);
        StatusBelongsToClassAssertion assertion = new StatusBelongsToClassAssertion(clazz);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertMostRecentResponseContentLengthLessThanOrEqual(Pattern url, Long max) {
        MostRecentUrlFilteredHarEntrySupplier supplier = new MostRecentUrlFilteredHarEntrySupplier(this.getHar(), url);
        ContentSizeLessThanOrEqualAssertion assertion = new ContentSizeLessThanOrEqualAssertion(max);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertMostRecentResponseHeaderContains(Pattern url, String name, String value) {
        MostRecentUrlFilteredHarEntrySupplier supplier = new MostRecentUrlFilteredHarEntrySupplier(this.getHar(), url);
        HeadersPassPredicateAssertion assertion = StringUtils.isEmpty((CharSequence)name) ? new HeadersContainStringAssertion(value) : new FilteredHeadersContainStringAssertion(name, value);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertMostRecentResponseHeaderDoesNotContain(Pattern url, String name, String value) {
        MostRecentUrlFilteredHarEntrySupplier supplier = new MostRecentUrlFilteredHarEntrySupplier(this.getHar(), url);
        HeadersPassPredicateAssertion assertion = StringUtils.isEmpty((CharSequence)name) ? new HeadersDoNotContainStringAssertion(value) : new FilteredHeadersDoNotContainStringAssertion(name, value);
        return this.checkAssertion(supplier, assertion);
    }

    @Override
    public AssertionResult assertMostRecentResponseHeaderMatches(Pattern url, Pattern name, Pattern value) {
        MostRecentUrlFilteredHarEntrySupplier supplier = new MostRecentUrlFilteredHarEntrySupplier(this.getHar(), url);
        HeadersPassPredicateAssertion assertion = name == null ? new HeadersMatchAssertion(value) : new FilteredHeadersMatchAssertion(name, value);
        return this.checkAssertion(supplier, assertion);
    }

    private AssertionResult checkAssertion(HarEntriesSupplier harEntriesSupplier, HarEntryAssertion assertion) {
        AssertionResult.Builder result = new AssertionResult.Builder();
        List entries = (List)harEntriesSupplier.get();
        AtomicInteger failedCount = new AtomicInteger();
        entries.forEach(entry -> {
            AssertionEntryResult.Builder requestResult = new AssertionEntryResult.Builder();
            requestResult.setUrl(entry.getRequest().getUrl());
            Optional<HarEntryAssertionError> error = assertion.assertion((HarEntry)entry);
            requestResult.setFailed(error.isPresent());
            if (error.isPresent()) {
                requestResult.setMessage(error.get().getMessage());
                failedCount.getAndIncrement();
            }
            result.addRequest(requestResult.create());
        });
        String resultMessage = String.format("%d passed, %d total", entries.size() - failedCount.get(), entries.size());
        return result.setFilter(harEntriesSupplier.getFilterInfo()).setFailed(failedCount.get() > 0).setMessage(resultMessage).setPassed(failedCount.get() == 0).create();
    }

    public boolean isMitmDisabled() {
        return this.mitmDisabled;
    }

    public void setUseEcc(boolean useEcc) {
        this.useEcc = useEcc;
    }

    protected void addBrowserUpFilters() {
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new ResolvedHostnameCacheFilter(originalRequest, ctx);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new RegisterRequestFilter(originalRequest, ctx, BrowserUpProxyServer.this.activityMonitor);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new HttpsOriginalHostCaptureFilter(originalRequest, ctx);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new BlacklistFilter(originalRequest, ctx, BrowserUpProxyServer.this.getBlacklist());
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                Whitelist currentWhitelist = (Whitelist)BrowserUpProxyServer.this.whitelist.get();
                return new WhitelistFilter(originalRequest, ctx, BrowserUpProxyServer.this.isWhitelistEnabled(), currentWhitelist.getStatusCode(), currentWhitelist.getPatterns());
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new AutoBasicAuthFilter(originalRequest, ctx, BrowserUpProxyServer.this.basicAuthCredentials);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new RewriteUrlFilter(originalRequest, ctx, BrowserUpProxyServer.this.rewriteRules);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new HttpsHostCaptureFilter(originalRequest, ctx);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest) {
                return new AddHeadersFilter(originalRequest, BrowserUpProxyServer.this.additionalHeaders);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest) {
                return new LatencyFilter(originalRequest, BrowserUpProxyServer.this.latencyMs);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new UnregisterRequestFilter(originalRequest, ctx, BrowserUpProxyServer.this.activityMonitor);
            }
        });
    }

    private int getMaximumRequestBufferSize() {
        int maxBufferSize = 0;
        for (HttpFiltersSource source : this.filterFactories) {
            int requestBufferSize = source.getMaximumRequestBufferSizeInBytes();
            if (requestBufferSize <= maxBufferSize) continue;
            maxBufferSize = requestBufferSize;
        }
        return maxBufferSize;
    }

    private int getMaximumResponseBufferSize() {
        int maxBufferSize = 0;
        for (HttpFiltersSource source : this.filterFactories) {
            int requestBufferSize = source.getMaximumResponseBufferSizeInBytes();
            if (requestBufferSize <= maxBufferSize) continue;
            maxBufferSize = requestBufferSize;
        }
        return maxBufferSize;
    }

    protected void addHarCaptureFilter() {
        if (this.harCaptureFilterEnabled.compareAndSet(false, true)) {
            this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

                public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                    Har har = BrowserUpProxyServer.this.getOrCreateHar();
                    if (har != null && !ProxyUtils.isCONNECT((HttpObject)originalRequest)) {
                        return new HarCaptureFilter(originalRequest, ctx, har, BrowserUpProxyServer.this.getCurrentPageRef(), BrowserUpProxyServer.this.getHarCaptureTypes());
                    }
                    return null;
                }
            });
            this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

                public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                    Har har = BrowserUpProxyServer.this.getOrCreateHar();
                    if (har != null && ProxyUtils.isCONNECT((HttpObject)originalRequest)) {
                        return new HttpConnectHarCaptureFilter(originalRequest, ctx, har, BrowserUpProxyServer.this.getCurrentPageRef());
                    }
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Har getOrCreateHar(String initialPageRef, String initialPageTitle, boolean createPage) {
        if (this.har == null) {
            Object object = LOCK;
            synchronized (object) {
                if (this.har == null) {
                    this.newHar(initialPageRef, initialPageTitle, createPage);
                }
            }
        }
        return this.har;
    }

    private Har getOrCreateHar() {
        return this.getOrCreateHar("Default", "Default", true);
    }

    private String getCurrentPageRef() {
        HarPage harPage = this.getCurrentHarPage();
        harPage = harPage == null ? this.getOrCreateDefaultPage() : harPage;
        return harPage.getId();
    }

    private HarPage getOrCreateDefaultPage() {
        return this.getDefaultPage().orElseGet(this::addDefaultPage);
    }

    private HarPage addDefaultPage() {
        HarPage newPage = new HarPage();
        newPage.setTitle("Default");
        newPage.setStartedDateTime(new Date());
        newPage.setId("Default");
        this.getHar().getLog().getPages().add(newPage);
        return newPage;
    }

    private Optional<HarPage> getDefaultPage() {
        return this.getHar().getLog().getPages().stream().filter(p -> p.getTitle().equals("Default")).findFirst();
    }

    static {
        HAR_CREATOR_VERSION.setName("BrowserUp Proxy");
        HAR_CREATOR_VERSION.setVersion(BrowserUpProxyUtil.getVersionString());
    }
}

