/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitm.stats;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class CertificateGenerationStatistics {
    private AtomicLong certificateGenerationTimeMs = new AtomicLong();
    private AtomicInteger certificatesGenerated = new AtomicInteger();
    private AtomicLong firstCertificateGeneratedTimestamp = new AtomicLong();

    public void certificateCreated(long startTimeMs, long finishTimeMs) {
        this.certificatesGenerated.incrementAndGet();
        this.certificateGenerationTimeMs.addAndGet(finishTimeMs - startTimeMs);
        this.firstCertificateGeneratedTimestamp.compareAndSet(0L, System.currentTimeMillis());
    }

    public int getCertificatesGenerated() {
        return this.certificatesGenerated.get();
    }

    public long getTotalCertificateGenerationTimeMs() {
        return this.certificateGenerationTimeMs.get();
    }

    public long getAvgCertificateGenerationTimeMs() {
        if (this.certificatesGenerated.get() > 0) {
            return this.certificateGenerationTimeMs.get() / (long)this.certificatesGenerated.get();
        }
        return 0L;
    }

    public long firstCertificateGeneratedTimestamp() {
        return this.firstCertificateGeneratedTimestamp.get();
    }
}

