/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.maven.plugins.emailserver.greenmail;

import com.btmatthews.maven.plugins.emailserver.AbstractMailServer;
import com.btmatthews.maven.plugins.emailserver.mojo.Mailbox;
import com.btmatthews.utils.monitor.Logger;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;

public final class GreenmailMailServer
extends AbstractMailServer {
    private GreenMail greenMail;

    public void start(Logger logger) {
        this.logInfo(logger, "com.btmatthews.maven.plugin.emailserver.greenmail.starting");
        ServerSetup[] serverSetups = this.getServerSetups();
        this.greenMail = new GreenMail(serverSetups);
        Mailbox[] mailboxes = this.getMailboxes();
        if (mailboxes != null) {
            for (Mailbox mailbox : this.getMailboxes()) {
                if (!mailbox.isValid()) continue;
                this.greenMail.setUser(mailbox.getEmail(), mailbox.getLogin(), mailbox.getPassword());
            }
        }
        this.greenMail.start();
        this.logInfo(logger, "com.btmatthews.maven.plugin.emailserver.greenmail.started");
    }

    public void stop(Logger logger) {
        this.logInfo(logger, "com.btmatthews.maven.plugin.emailserver.greenmail.stopping");
        if (this.greenMail != null) {
            this.greenMail.stop();
            this.greenMail = null;
        }
        this.logInfo(logger, "com.btmatthews.maven.plugin.emailserver.greenmail.stopped");
    }

    private ServerSetup[] getServerSetups() {
        if (this.isUseSSL()) {
            return new ServerSetup[]{new ServerSetup(465 + this.getPortOffset(), null, "smtps"), new ServerSetup(995 + this.getPortOffset(), null, "pop3s"), new ServerSetup(993 + this.getPortOffset(), null, "imaps")};
        }
        return new ServerSetup[]{new ServerSetup(25 + this.getPortOffset(), null, "smtp"), new ServerSetup(110 + this.getPortOffset(), null, "pop3"), new ServerSetup(143 + this.getPortOffset(), null, "imap")};
    }
}

