/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.utils.monitor;

import com.btmatthews.utils.monitor.Logger;
import com.btmatthews.utils.monitor.MonitorObserver;
import com.btmatthews.utils.monitor.Server;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Monitor {
    private static final Pattern CONFIGURE_PATTERN = Pattern.compile("configure\\s+(\\w+)=(.*)");
    private static final String STOP = "stop";
    private final String monitorKey;
    private final int monitorPort;

    public Monitor(String key, int port) {
        this.monitorKey = key;
        this.monitorPort = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runMonitor(Server server, Logger logger, MonitorObserver observer) {
        try {
            ServerSocket serverSocket = new ServerSocket(this.monitorPort, 1, InetAddress.getLocalHost());
            try {
                serverSocket.setReuseAddress(true);
                server.start(logger);
                observer.started(server, logger);
                this.runMonitorInternal(server, logger, serverSocket);
                observer.stopped(server, logger);
            }
            finally {
                serverSocket.close();
            }
        }
        catch (IOException exception) {
            logger.logError("Error starting or stopping the monitor", exception);
        }
    }

    public Thread runMonitorDaemon(final Server server, final Logger logger, final MonitorObserver observer) {
        Thread monitorThread = new Thread(new Runnable(){

            public void run() {
                Monitor.this.runMonitor(server, logger, observer);
            }
        });
        monitorThread.setDaemon(true);
        monitorThread.start();
        return monitorThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMonitorInternal(Server server, Logger logger, ServerSocket serverSocket) {
        boolean running = true;
        while (running) {
            Socket clientSocket = null;
            try {
                try {
                    logger.logInfo("Waiting for command from client");
                    clientSocket = serverSocket.accept();
                    logger.logInfo("Receiving command from client");
                    clientSocket.setSoLinger(false, 0);
                    String command = this.getCommand(clientSocket, logger);
                    if (command == null) continue;
                    running = this.executeCommand(server, command, logger);
                }
                finally {
                    if (clientSocket == null) continue;
                    clientSocket.close();
                }
            }
            catch (IOException exception) {
                logger.logError("Error in the monitor", exception);
            }
        }
    }

    private String getCommand(Socket clientSocket, Logger logger) throws IOException {
        InputStream inputStream = clientSocket.getInputStream();
        InputStreamReader reader = new InputStreamReader(inputStream);
        LineNumberReader lineReader = new LineNumberReader(reader);
        String key = lineReader.readLine();
        if (this.monitorKey.equals(key)) {
            return lineReader.readLine();
        }
        logger.logError("Invalid monitor key");
        return null;
    }

    public static void sendCommand(String key, int port, String command, Logger logger) {
        new Monitor(key, port).sendCommand(command, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommand(String command, Logger logger) {
        try {
            logger.logInfo("Sending command \"" + command + "\" to monitor");
            Socket socket = new Socket(InetAddress.getLocalHost(), this.monitorPort);
            try {
                socket.setSoLinger(false, 0);
                OutputStream outputStream = socket.getOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                PrintWriter printWriter = new PrintWriter(writer);
                printWriter.println(this.monitorKey);
                printWriter.println(command);
                printWriter.flush();
                socket.close();
            }
            finally {
                socket.close();
            }
        }
        catch (IOException exception) {
            logger.logError("Error sending command to monitor", exception);
        }
    }

    private boolean executeCommand(Server server, String command, Logger logger) {
        Matcher matcher = CONFIGURE_PATTERN.matcher(command);
        if (matcher.matches()) {
            server.configure(matcher.group(1), matcher.group(2), logger);
        } else if (STOP.equals(command)) {
            server.stop(logger);
            return false;
        }
        return true;
    }
}

