/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test;

import com.c4_soft.springaddons.security.oidc.ModifiableClaimSet;
import com.c4_soft.springaddons.security.oidc.OpenidClaimSet;
import java.net.URL;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class OpenidClaimSetBuilder<T extends OpenidClaimSetBuilder<T>>
extends ModifiableClaimSet {
    private static final long serialVersionUID = 8050195176203128543L;
    private String usernameClaim = "sub";

    public OpenidClaimSetBuilder() {
    }

    public OpenidClaimSetBuilder(Map<String, Object> ptivateClaims) {
        super(ptivateClaims);
    }

    public OpenidClaimSet build() {
        return new OpenidClaimSet((Map)((Object)this), this.usernameClaim);
    }

    private T cast() {
        return (T)((Object)this);
    }

    public T usernameClaim(String usernameClaim) {
        this.usernameClaim = usernameClaim;
        return this.cast();
    }

    public T acr(String acr) {
        return this.setIfNonEmpty("acr", acr);
    }

    public T amr(List<String> amr) {
        return this.setIfNonEmpty("amr", amr);
    }

    public T audience(List<String> audience) {
        return this.setIfNonEmpty("aud", audience);
    }

    public T authTime(Instant authTime) {
        return this.setIfNonEmpty("auth_time", authTime);
    }

    public T azp(String azp) {
        return this.setIfNonEmpty("azp", azp);
    }

    public T expiresAt(Instant expiresAt) {
        return this.setIfNonEmpty("exp", expiresAt);
    }

    public T issuedAt(Instant issuedAt) {
        return this.setIfNonEmpty("iat", issuedAt);
    }

    public T jwtId(String jti) {
        return this.setIfNonEmpty("jti", jti);
    }

    public T issuer(URL issuer) {
        return this.setIfNonEmpty("iss", issuer.toString());
    }

    public T nonce(String nonce) {
        return this.setIfNonEmpty("nonce", nonce);
    }

    public T notBefore(Instant nbf) {
        return this.setIfNonEmpty("nbf", nbf);
    }

    public T accessTokenHash(String atHash) {
        return this.setIfNonEmpty("at_hash", atHash);
    }

    public T authorizationCodeHash(String cHash) {
        return this.setIfNonEmpty("c_hash", cHash);
    }

    public T sessionState(String sessionState) {
        return this.setIfNonEmpty("session_state", sessionState);
    }

    public T subject(String subject) {
        return this.setIfNonEmpty("sub", subject);
    }

    public T name(String value) {
        return this.setIfNonEmpty("name", value);
    }

    public T givenName(String value) {
        return this.setIfNonEmpty("given_name", value);
    }

    public T familyName(String value) {
        return this.setIfNonEmpty("family_name", value);
    }

    public T middleName(String value) {
        return this.setIfNonEmpty("middle_name", value);
    }

    public T nickname(String value) {
        return this.setIfNonEmpty("nickname", value);
    }

    public T preferredUsername(String value) {
        return this.setIfNonEmpty("preferred_username", value);
    }

    public T profile(String value) {
        return this.setIfNonEmpty("profile", value);
    }

    public T picture(String value) {
        return this.setIfNonEmpty("picture", value);
    }

    public T website(String value) {
        return this.setIfNonEmpty("website", value);
    }

    public T email(String value) {
        return this.setIfNonEmpty("email", value);
    }

    public T emailVerified(Boolean value) {
        return this.setIfNonEmpty("email_verified", value);
    }

    public T gender(String value) {
        return this.setIfNonEmpty("gender", value);
    }

    public T birthdate(String value) {
        return this.setIfNonEmpty("birthdate", value);
    }

    public T zoneinfo(String value) {
        return this.setIfNonEmpty("zoneinfo", value);
    }

    public T locale(String value) {
        return this.setIfNonEmpty("locale", value);
    }

    public T phoneNumber(String value) {
        return this.setIfNonEmpty("phone_number", value);
    }

    public T phoneNumberVerified(Boolean value) {
        return this.setIfNonEmpty("phone_number_verified", value);
    }

    public T address(AddressClaim value) {
        if (value == null) {
            this.remove("address");
        } else {
            this.put("address", (Object)value);
        }
        return this.cast();
    }

    public T claims(Map<String, Object> claims) {
        this.putAll(claims);
        return this.cast();
    }

    public T privateClaims(Map<String, Object> claims) {
        return this.claims(claims);
    }

    public T otherClaims(Map<String, Object> claims) {
        return this.claims(claims);
    }

    public T updatedAt(Instant value) {
        return this.setIfNonEmpty("", value);
    }

    protected T setIfNonEmpty(String claimName, String claimValue) {
        if (StringUtils.hasText((String)claimValue)) {
            this.put(claimName, claimValue);
        } else {
            this.remove(claimName);
        }
        return this.cast();
    }

    protected T setIfNonEmpty(String claimName, Collection<String> claimValue) {
        if (claimValue == null || claimValue.isEmpty()) {
            this.remove(claimName);
        } else if (claimValue.isEmpty()) {
            this.setIfNonEmpty(claimName, claimValue.iterator().next());
        } else {
            this.put(claimName, claimValue);
        }
        return this.cast();
    }

    protected T setIfNonEmpty(String claimName, Instant claimValue) {
        if (claimValue == null) {
            this.remove(claimName);
        } else {
            this.put(claimName, claimValue.getEpochSecond());
        }
        return this.cast();
    }

    protected T setIfNonEmpty(String claimName, Boolean claimValue) {
        if (claimValue == null) {
            this.remove(claimName);
        } else {
            this.put(claimName, claimValue);
        }
        return this.cast();
    }

    public static final class AddressClaim
    extends ModifiableClaimSet {
        private static final long serialVersionUID = 28800769851008900L;

        public AddressClaim formatted(String value) {
            return this.setIfNonEmpty("formatted", value);
        }

        public AddressClaim streetAddress(String value) {
            return this.setIfNonEmpty("street_address", value);
        }

        public AddressClaim locality(String value) {
            return this.setIfNonEmpty("locality", value);
        }

        public AddressClaim region(String value) {
            return this.setIfNonEmpty("region", value);
        }

        public AddressClaim postalCode(String value) {
            return this.setIfNonEmpty("postal_code", value);
        }

        public AddressClaim country(String value) {
            return this.setIfNonEmpty("country", value);
        }

        private AddressClaim setIfNonEmpty(String claimName, String claimValue) {
            if (StringUtils.hasText((String)claimValue)) {
                this.put(claimName, claimValue);
            } else {
                this.remove(claimName);
            }
            return this;
        }
    }
}

