/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import com.cloudbees.groovy.cps.Block;
import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.Next;
import com.cloudbees.groovy.cps.impl.CallSiteBlock;
import com.cloudbees.groovy.cps.impl.Caller;
import com.cloudbees.groovy.cps.impl.ContinuationPtr;
import com.cloudbees.groovy.cps.impl.CpsBooleanClosureWrapper;
import com.cloudbees.groovy.cps.impl.CpsCallableInvocation;
import com.cloudbees.groovy.cps.impl.CpsClosure;
import com.cloudbees.groovy.cps.impl.ReferenceStackTrace;
import com.cloudbees.groovy.cps.impl.SourceLocation;
import com.cloudbees.groovy.cps.impl.Super;
import com.cloudbees.groovy.cps.sandbox.Invoker;
import groovy.lang.GroovyShell;
import groovy.lang.ListWithDefault;
import groovy.lang.MapWithDefault;
import groovy.lang.Script;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;

abstract class ContinuationGroup
implements Serializable {
    private static final long serialVersionUID = 1L;

    ContinuationGroup() {
    }

    public Next then(Block exp, Env e, ContinuationPtr ptr) {
        return new Next(exp, e, ptr.bind(this));
    }

    public Next then(Block exp, Env e, Continuation k) {
        return new Next(exp, e, k);
    }

    protected Next methodCall(Env e, SourceLocation loc, ContinuationPtr k, CallSiteBlock callSite, Object receiver, String methodName, Object ... args) {
        return this.methodCall(e, loc, k.bind(this), callSite, receiver, methodName, args);
    }

    protected Next methodCall(Env e, SourceLocation loc, Continuation k, CallSiteBlock callSite, Object receiver, String methodName, Object ... args) {
        ArrayList<String> expectedMethodNames = new ArrayList<String>(2);
        expectedMethodNames.add(methodName);
        boolean laxCall = false;
        Object effectiveReceiver = ContinuationGroup.findEffectiveReceiver(receiver, null);
        try {
            Object v;
            Caller.record(receiver, methodName, args);
            Invoker inv = e.getInvoker().contextualize(callSite);
            if (receiver instanceof Super) {
                Super s = (Super)receiver;
                v = inv.superCall(s.senderType, s.receiver, methodName, args);
            } else {
                if (effectiveReceiver instanceof Script) {
                    if (methodName.equals("evaluate")) {
                        expectedMethodNames.add("run");
                    }
                    expectedMethodNames.add("call");
                    laxCall = !((Script)effectiveReceiver).getBinding().getVariables().containsKey(methodName);
                } else if (effectiveReceiver instanceof GroovyShell && methodName.equals("evaluate")) {
                    expectedMethodNames.add("run");
                } else if (effectiveReceiver instanceof CpsBooleanClosureWrapper && methodName.equals("callForMap")) {
                    expectedMethodNames.add("call");
                } else if ((effectiveReceiver instanceof ListWithDefault || effectiveReceiver instanceof MapWithDefault) && methodName.equals("get")) {
                    expectedMethodNames.add("call");
                }
                v = inv.methodCall(receiver, methodName, args);
            }
            return k.receive(v);
        }
        catch (CpsCallableInvocation inv) {
            if (!methodName.startsWith("$")) {
                if (laxCall && inv.receiver instanceof CpsClosure) {
                    expectedMethodNames.remove("call");
                }
                inv.checkMismatch(effectiveReceiver, expectedMethodNames);
            }
            return inv.invoke(e, loc, k);
        }
        catch (Throwable t) {
            return this.throwException(e, t, loc, new ReferenceStackTrace());
        }
    }

    private static Object findEffectiveReceiver(Object receiver, Map<Object, Boolean> encountered) {
        if (!(receiver instanceof CpsClosure)) {
            return receiver;
        }
        if (encountered == null) {
            encountered = new IdentityHashMap<Object, Boolean>();
        }
        if (encountered.put(receiver, true) == null) {
            return ContinuationGroup.findEffectiveReceiver(((CpsClosure)((Object)receiver)).getOwner(), encountered);
        }
        return receiver;
    }

    private void fixupStackTrace(Env e, Throwable t, SourceLocation loc, ReferenceStackTrace ref) {
        StackTraceElement[] ts;
        StackTraceElement[] rs = ref.getStackTrace();
        if (!this.hasSameRoots(rs, ts = t.getStackTrace())) {
            return;
        }
        List<StackTraceElement> orig = Arrays.asList(ts);
        int pos = ts.length - rs.length;
        ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>(orig.subList(0, pos));
        stack.add((loc != null ? loc : SourceLocation.UNKNOWN).toStackTrace());
        e.buildStackTraceElements(stack, Integer.MAX_VALUE);
        stack.add(Continuable.SEPARATOR_STACK_ELEMENT);
        stack.addAll(orig.subList(pos, orig.size()));
        t.setStackTrace(stack.toArray(new StackTraceElement[stack.size()]));
    }

    private boolean hasSameRoots(StackTraceElement[] rs, StackTraceElement[] ts) {
        int b = ts.length - rs.length;
        if (b < 0) {
            return false;
        }
        StackTraceElement lhs = ts[b];
        StackTraceElement rhs = rs[0];
        if (!(this.eq(lhs.getClassName(), rhs.getClassName()) && this.eq(lhs.getMethodName(), rhs.getMethodName()) && this.eq(lhs.getFileName(), rhs.getFileName()))) {
            return false;
        }
        for (int i = 1; i < rs.length; ++i) {
            if (ts[b + i].equals(rs[i])) continue;
            return false;
        }
        return true;
    }

    private boolean eq(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    @CheckReturnValue
    protected Next throwException(Env e, Throwable t, SourceLocation loc, ReferenceStackTrace ref) {
        this.fixupStackTrace(e, t, loc, ref);
        return e.getExceptionHandler(t.getClass()).receive(t);
    }
}

