/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.ex.UIAssertionError;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Set;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

public class SelenideTargetLocator
implements WebDriver.TargetLocator {
    private final WebDriver.TargetLocator delegate;

    SelenideTargetLocator(WebDriver.TargetLocator delegate) {
        this.delegate = delegate;
    }

    public WebDriver frame(int index) {
        return (WebDriver)Selenide.Wait().until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((int)index));
    }

    public WebDriver frame(String nameOrId) {
        return (WebDriver)Selenide.Wait().until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((String)nameOrId));
    }

    public WebDriver frame(WebElement frameElement) {
        return (WebDriver)Selenide.Wait().until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((WebElement)frameElement));
    }

    public WebDriver parentFrame() {
        return this.delegate.parentFrame();
    }

    public WebDriver defaultContent() {
        return this.delegate.defaultContent();
    }

    public WebElement activeElement() {
        return this.delegate.activeElement();
    }

    public Alert alert() {
        return (Alert)Selenide.Wait().until((Function)ExpectedConditions.alertIsPresent());
    }

    public WebDriver innerFrame(String ... frames) {
        WebDriver driver = WebDriverRunner.getWebDriver();
        this.delegate.defaultContent();
        for (String frame : frames) {
            try {
                String selector = String.format("frame#%1$s,frame[name=%1$s],iframe#%1$s,iframe[name=%1$s]", frame);
                Selenide.Wait().until(SelenideTargetLocator.frameToBeAvailableAndSwitchToIt_fixed(By.cssSelector((String)selector)));
            }
            catch (NoSuchElementException | TimeoutException e) {
                throw new NoSuchFrameException("No frame found with id/name = " + frame, e);
            }
        }
        return driver;
    }

    private static ExpectedCondition<WebDriver> frameToBeAvailableAndSwitchToIt_fixed(final By locator) {
        return new ExpectedCondition<WebDriver>(){

            public WebDriver apply(WebDriver driver) {
                try {
                    return driver.switchTo().frame(driver.findElement(locator));
                }
                catch (NoSuchFrameException e) {
                    return null;
                }
                catch (WebDriverException e) {
                    return null;
                }
            }

            public String toString() {
                return "frame to be available: " + locator;
            }
        };
    }

    private static ExpectedCondition<WebDriver> windowToBeAvailableAndSwitchToIt(final String nameOrHandleOrTitle) {
        return new ExpectedCondition<WebDriver>(){

            public WebDriver apply(WebDriver driver) {
                try {
                    return driver.switchTo().window(nameOrHandleOrTitle);
                }
                catch (NoSuchWindowException windowWithNameOrHandleNotFound) {
                    try {
                        return SelenideTargetLocator.windowByTitle(nameOrHandleOrTitle);
                    }
                    catch (NoSuchWindowException e) {
                        return null;
                    }
                }
            }

            public String toString() {
                return "window to be available by name or handle or title: " + nameOrHandleOrTitle;
            }
        };
    }

    private static ExpectedCondition<WebDriver> windowToBeAvailableAndSwitchToIt(final int index) {
        return new ExpectedCondition<WebDriver>(){

            public WebDriver apply(WebDriver driver) {
                try {
                    ArrayList windowHandles = new ArrayList(driver.getWindowHandles());
                    return driver.switchTo().window((String)windowHandles.get(index));
                }
                catch (IndexOutOfBoundsException windowWithIndexNotFound) {
                    return null;
                }
            }

            public String toString() {
                return "window to be available by index: " + index;
            }
        };
    }

    public WebDriver window(int index) {
        try {
            return (WebDriver)Selenide.Wait().until(SelenideTargetLocator.windowToBeAvailableAndSwitchToIt(index));
        }
        catch (TimeoutException e) {
            throw UIAssertionError.wrapThrowable(e, Configuration.timeout);
        }
    }

    public WebDriver window(String nameOrHandleOrTitle) {
        try {
            return (WebDriver)Selenide.Wait().until(SelenideTargetLocator.windowToBeAvailableAndSwitchToIt(nameOrHandleOrTitle));
        }
        catch (NoSuchWindowException windowWithNameOrHandleNotFound) {
            return SelenideTargetLocator.windowByTitle(nameOrHandleOrTitle);
        }
        catch (TimeoutException e) {
            throw UIAssertionError.wrapThrowable(e, Configuration.timeout);
        }
    }

    protected static WebDriver windowByTitle(String title) {
        WebDriver driver = WebDriverRunner.getWebDriver();
        Set windowHandles = driver.getWindowHandles();
        for (String windowHandle : windowHandles) {
            driver.switchTo().window(windowHandle);
            if (!title.equals(driver.getTitle())) continue;
            return driver;
        }
        throw new NoSuchWindowException("Window with title not found: " + title);
    }
}

