/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.SelectOptionByValue;
import com.codeborne.selenide.commands.SelectRadio;
import com.codeborne.selenide.ex.InvalidStateException;
import com.codeborne.selenide.impl.Events;
import com.codeborne.selenide.impl.WebElementSource;
import org.openqa.selenium.WebElement;

public class SetValue
implements Command<WebElement> {
    SelectOptionByValue selectOptionByValue = new SelectOptionByValue();
    SelectRadio selectRadio = new SelectRadio();

    @Override
    public WebElement execute(SelenideElement proxy, WebElementSource locator, Object[] args) {
        String text = (String)args[0];
        WebElement element = locator.findAndAssertElementIsVisible();
        if ("select".equalsIgnoreCase(element.getTagName())) {
            this.selectOptionByValue.execute(proxy, locator, args);
        } else if ("input".equalsIgnoreCase(element.getTagName()) && "radio".equals(element.getAttribute("type"))) {
            this.selectRadio.execute(proxy, locator, args);
        } else if (text == null || text.isEmpty()) {
            element.clear();
        } else if (Configuration.fastSetValue) {
            String error = (String)Selenide.executeJavaScript("if (arguments[0].getAttribute('readonly') != undefined)   return 'Cannot change value of readonly element';arguments[0].value = arguments[1];return null;", element, text = this.truncateMaxLength(element, text));
            if (error != null) {
                throw new InvalidStateException(error);
            }
            Events.events.fireEvent(element, "focus", "keydown", "keypress", "input", "keyup", "change");
        } else {
            element.clear();
            element.sendKeys(new CharSequence[]{text});
            Events.events.fireChangeEvent(element);
        }
        return proxy;
    }

    private String truncateMaxLength(WebElement element, String text) {
        try {
            String maxlength = element.getAttribute("maxlength");
            int elementMaxLength = Integer.parseInt(maxlength);
            return text.length() > elementMaxLength ? text.substring(0, elementMaxLength) : text;
        }
        catch (NumberFormatException invalidMaxLength) {
            return text;
        }
    }
}

