/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

public class CssValue
extends Condition {
    private final String propertyName;
    private final String expectedValue;

    public CssValue(String propertyName, String expectedValue) {
        super("css value");
        this.propertyName = propertyName;
        this.expectedValue = expectedValue;
    }

    @Override
    public boolean apply(Driver driver, WebElement element) {
        String actualCssValue = element.getCssValue(this.propertyName);
        return StringUtils.defaultString((String)this.expectedValue).equalsIgnoreCase(StringUtils.defaultString((String)actualCssValue));
    }

    @Override
    public String actualValue(Driver driver, WebElement element) {
        return element.getCssValue(this.propertyName);
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.propertyName + '=' + this.expectedValue;
    }
}

