/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

class EdgeDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = Logger.getLogger(EdgeDriverFactory.class.getName());

    EdgeDriverFactory() {
    }

    @Override
    WebDriver create(Config config, Proxy proxy) {
        return this.createEdgeDriver(config, proxy);
    }

    @Override
    boolean supports(Config config, Browser browser) {
        return browser.isEdge();
    }

    private WebDriver createEdgeDriver(Config config, Proxy proxy) {
        DesiredCapabilities capabilities = this.createCommonCapabilities(config, proxy);
        EdgeOptions options = new EdgeOptions();
        options.merge((Capabilities)capabilities);
        if (!config.browserBinary().isEmpty()) {
            log.info("Using browser binary: " + config.browserBinary());
            log.warning("Changing browser binary not supported in Edge, setting will be ignored.");
        }
        return new EdgeDriver(options);
    }
}

