/*
 * Decompiled with CFR 0.152.
 */
package com.codepine.api.testrail.internal;

import com.codepine.api.testrail.model.Case;
import com.codepine.api.testrail.model.CaseField;
import com.codepine.api.testrail.model.Field;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CaseModule
extends SimpleModule {
    public void setupModule(Module.SetupContext setupContext) {
        setupContext.addBeanDeserializerModifier((BeanDeserializerModifier)new CaseDeserializerModifier());
        super.setupModule(setupContext);
    }

    private static class CaseDeserializerModifier
    extends BeanDeserializerModifier {
        private CaseDeserializerModifier() {
        }

        public JsonDeserializer<?> modifyDeserializer(DeserializationConfig deserializationConfig, BeanDescription beanDescription, JsonDeserializer<?> jsonDeserializer) {
            if (Case.class.isAssignableFrom(beanDescription.getBeanClass())) {
                return new CaseDeserializer(jsonDeserializer);
            }
            return jsonDeserializer;
        }
    }

    private static class CaseDeserializer
    extends StdDeserializer<Case>
    implements ResolvableDeserializer {
        private final JsonDeserializer<?> defaultDeserializer;

        CaseDeserializer(JsonDeserializer<?> defaultDeserializer) {
            super(Case.class);
            this.defaultDeserializer = defaultDeserializer;
        }

        public Case deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Case testCase = (Case)this.defaultDeserializer.deserialize(jsonParser, deserializationContext);
            ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
            List caseFieldList = (List)deserializationContext.findInjectableValue((Object)Case.class.toString(), null, null);
            ImmutableMap caseFields = Maps.uniqueIndex((Iterable)caseFieldList, (Function)new Function<CaseField, String>(){

                public String apply(CaseField caseField) {
                    return caseField.getName();
                }
            });
            HashMap<String, Object> customFields = new HashMap<String, Object>(testCase.getCustomFields().size());
            for (Map.Entry<String, Object> customField : testCase.getCustomFields().entrySet()) {
                Preconditions.checkArgument((boolean)caseFields.containsKey(customField.getKey()), (Object)("Case field list configuration is possibly outdated since it does not contain custom field: " + customField.getKey()));
                customFields.put(customField.getKey(), mapper.convertValue(customField.getValue(), Field.Type.getType(((CaseField)caseFields.get(customField.getKey())).getTypeId()).getTypeReference()));
            }
            testCase.setCustomFields(customFields);
            return testCase;
        }

        public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
            ((ResolvableDeserializer)this.defaultDeserializer).resolve(deserializationContext);
        }
    }
}

