/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.viper.hlsparserj;

import com.comcast.viper.hlsparserj.IPlaylist;
import com.comcast.viper.hlsparserj.PlaylistVersion;
import com.comcast.viper.hlsparserj.tags.Tag;
import com.comcast.viper.hlsparserj.tags.TagFactory;
import com.comcast.viper.hlsparserj.tags.UnparsedTag;
import com.comcast.viper.hlsparserj.tags.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractPlaylist
implements IPlaylist {
    protected List<UnparsedTag> tags;
    protected ConcurrentHashMap<String, List<Tag>> parsedTagListCache;
    protected ConcurrentHashMap<String, Tag> parsedTagCache;
    protected PlaylistVersion version;

    public AbstractPlaylist(PlaylistVersion version, List<UnparsedTag> tags) {
        this.version = version;
        this.tags = tags;
        this.parsedTagListCache = new ConcurrentHashMap();
        this.parsedTagCache = new ConcurrentHashMap();
    }

    protected List<? extends Tag> getTagList(String tagName) {
        List<Tag> tagList = this.parsedTagListCache.get(tagName);
        if (tagList == null) {
            tagList = new ArrayList<Tag>();
            for (UnparsedTag unparsedTag : this.tags) {
                if (!unparsedTag.getTagName().equals(tagName)) continue;
                Tag tag = TagFactory.createTag(tagName);
                tag.setTag(unparsedTag);
                tagList.add(tag);
            }
            this.parsedTagListCache.put(tagName, tagList);
        }
        return tagList;
    }

    protected Tag getTag(String tagName) {
        Tag tag = this.parsedTagCache.get(tagName);
        if (tag == null) {
            for (UnparsedTag unparsedTag : this.tags) {
                if (!unparsedTag.getTagName().equals(tagName)) continue;
                tag = TagFactory.createTag(tagName);
                tag.setTag(unparsedTag);
            }
            if (tag != null) {
                this.parsedTagCache.put(tagName, tag);
            }
        }
        return tag;
    }

    @Override
    public Version getVersion() {
        return (Version)this.getTag("EXT-X-VERSION");
    }

    @Override
    public abstract boolean isMasterPlaylist();

    @Override
    public List<UnparsedTag> getTags() {
        return this.tags;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (UnparsedTag tag : this.tags) {
            builder.append(tag.getRawTag());
            if (tag.getURI() != null) {
                builder.append("\n");
                builder.append(tag.getURI());
            }
            builder.append("\n");
        }
        return builder.toString();
    }
}

