/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.viper.hlsparserj;

import com.comcast.viper.hlsparserj.AbstractPlaylist;
import com.comcast.viper.hlsparserj.PlaylistVersion;
import com.comcast.viper.hlsparserj.tags.Tag;
import com.comcast.viper.hlsparserj.tags.TagFactory;
import com.comcast.viper.hlsparserj.tags.UnparsedTag;
import com.comcast.viper.hlsparserj.tags.media.AllowCache;
import com.comcast.viper.hlsparserj.tags.media.ByteRange;
import com.comcast.viper.hlsparserj.tags.media.ExtInf;
import com.comcast.viper.hlsparserj.tags.media.Key;
import com.comcast.viper.hlsparserj.tags.media.MediaSequence;
import com.comcast.viper.hlsparserj.tags.media.PlaylistType;
import com.comcast.viper.hlsparserj.tags.media.Segment;
import com.comcast.viper.hlsparserj.tags.media.TargetDuration;
import java.util.ArrayList;
import java.util.List;

public abstract class MediaPlaylist
extends AbstractPlaylist {
    public MediaPlaylist(PlaylistVersion version, List<UnparsedTag> tags) {
        super(version, tags);
    }

    public List<ExtInf> getSegments() {
        return this.getGenericSegments("EXTINF");
    }

    public List<ByteRange> getByteRanges() {
        return this.getGenericSegments("EXT-X-BYTERANGE");
    }

    public TargetDuration getTargetDuration() {
        return (TargetDuration)this.getTag("EXT-X-TARGETDURATION");
    }

    public MediaSequence getMediaSequence() {
        return (MediaSequence)this.getTag("EXT-X-MEDIA-SEQUENCE");
    }

    public AllowCache getAllowCache() {
        return (AllowCache)this.getTag("EXT-X-ALLOW-CACHE");
    }

    public PlaylistType getPlaylistType() {
        return (PlaylistType)this.getTag("EXT-X-PLAYLIST-TYPE");
    }

    @Override
    public boolean isMasterPlaylist() {
        return false;
    }

    private List<? extends Tag> getGenericSegments(String segmentTagName) {
        ArrayList<Segment> tagList = (ArrayList<Segment>)this.parsedTagListCache.get(segmentTagName);
        if (tagList == null) {
            tagList = new ArrayList<Segment>();
            boolean discontinuity = false;
            String programDateTime = null;
            Key key = null;
            for (UnparsedTag unparsedTag : this.tags) {
                String tagName = unparsedTag.getTagName();
                if (tagName.equals("EXT-X-DISCONTINUITY")) {
                    discontinuity = true;
                    continue;
                }
                if (tagName.equals("EXT-X-PROGRAM-DATE-TIME")) {
                    programDateTime = unparsedTag.getAttributes().get("NONAME0");
                    continue;
                }
                if (tagName.equals("EXT-X-KEY")) {
                    key = new Key();
                    key.setTag(unparsedTag);
                    continue;
                }
                if (!unparsedTag.getTagName().equals(segmentTagName)) continue;
                Segment segment = (Segment)TagFactory.createTag(segmentTagName);
                segment.setTag(unparsedTag);
                segment.setDiscontinuity(discontinuity);
                segment.setKey(key);
                segment.setDateTime(programDateTime);
                tagList.add(segment);
                discontinuity = false;
                programDateTime = null;
            }
            this.parsedTagListCache.put(segmentTagName, tagList);
        }
        return tagList;
    }

    public boolean getIFramesOnly() {
        Tag ifo = this.getTag("EXT-X-I-FRAMES-ONLY");
        return ifo != null;
    }
}

