/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.ip4s;

import com.comcast.ip4s.Ipv4Address;
import com.comcast.ip4s.Ipv4AddressCompanionPlatform;
import java.io.Serializable;
import java.net.Inet4Address;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.runtime.LongRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Ipv4Address$
implements Ipv4AddressCompanionPlatform,
Serializable {
    public static final Ipv4Address$ MODULE$ = new Ipv4Address$();
    private static final Ipv4Address Wildcard;
    private static final Ipv4Address MulticastRangeStart;
    private static final Ipv4Address MulticastRangeEnd;
    private static final Ipv4Address SourceSpecificMulticastRangeStart;
    private static final Ipv4Address SourceSpecificMulticastRangeEnd;

    static {
        Ipv4AddressCompanionPlatform.$init$(MODULE$);
        Wildcard = MODULE$.fromBytes(0, 0, 0, 0);
        MulticastRangeStart = MODULE$.fromBytes(224, 0, 0, 0);
        MulticastRangeEnd = MODULE$.fromBytes(239, 255, 255, 255);
        SourceSpecificMulticastRangeStart = MODULE$.fromBytes(232, 0, 0, 0);
        SourceSpecificMulticastRangeEnd = MODULE$.fromBytes(232, 255, 255, 255);
    }

    @Override
    public Ipv4Address fromInet4Address(Inet4Address address) {
        return Ipv4AddressCompanionPlatform.fromInet4Address$(this, address);
    }

    public Ipv4Address Wildcard() {
        return Wildcard;
    }

    public Ipv4Address MulticastRangeStart() {
        return MulticastRangeStart;
    }

    public Ipv4Address MulticastRangeEnd() {
        return MulticastRangeEnd;
    }

    public Ipv4Address SourceSpecificMulticastRangeStart() {
        return SourceSpecificMulticastRangeStart;
    }

    public Ipv4Address SourceSpecificMulticastRangeEnd() {
        return SourceSpecificMulticastRangeEnd;
    }

    public Option<Ipv4Address> fromString(String value) {
        String trimmed = value.trim();
        String[] fields = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(trimmed), '.');
        if (fields.length == 4) {
            byte[] bytes = new byte[4];
            int idx = 0;
            None$ result = null;
            while (idx < bytes.length && result == null) {
                try {
                    int value2 = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(fields[idx]));
                    if (value2 >= 0 && value2 < 256) {
                        bytes[idx] = (byte)value2;
                    } else {
                        result = None$.MODULE$;
                    }
                    ++idx;
                }
                catch (NumberFormatException numberFormatException) {
                    result = None$.MODULE$;
                }
            }
            if (result == null) {
                return new Some((Object)this.unsafeFromBytes(bytes));
            }
            return result;
        }
        return None$.MODULE$;
    }

    public Option<Ipv4Address> fromBytes(byte[] bytes) {
        if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(bytes)) == 4) {
            return new Some((Object)this.unsafeFromBytes((byte[])bytes.clone()));
        }
        return None$.MODULE$;
    }

    private Ipv4Address unsafeFromBytes(byte[] bytes) {
        return new Ipv4Address(bytes);
    }

    public Ipv4Address fromBytes(int a, int b, int c, int d) {
        byte[] bytes = new byte[]{(byte)a, (byte)b, (byte)c, (byte)d};
        return this.unsafeFromBytes(bytes);
    }

    public Ipv4Address fromLong(long value) {
        byte[] bytes = new byte[4];
        LongRef rem = LongRef.create((long)value);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 0).by(-1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            bytes$2[i] = (byte)(rem$1.elem & 0xFFL);
            rem$1.elem >>= 8;
        });
        return this.unsafeFromBytes(bytes);
    }

    public Ipv4Address mask(int bits) {
        int b = bits < 0 ? 0 : (bits > 32 ? 32 : bits);
        return this.fromLong(b == 32 ? -1L : (long)(-1 >>> b) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Ipv4Address$.class);
    }

    private Ipv4Address$() {
    }
}

