/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.manager.bucket;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Stability.Internal
public class CoreStorageBackend {
    private static final ConcurrentMap<String, CoreStorageBackend> interned = new ConcurrentHashMap<String, CoreStorageBackend>();
    public static final CoreStorageBackend COUCHSTORE = CoreStorageBackend.of("couchstore");
    public static final CoreStorageBackend MAGMA = CoreStorageBackend.of("magma");
    private final String alias;

    private CoreStorageBackend(String alias) {
        this.alias = Objects.requireNonNull(alias);
    }

    @JsonCreator
    @Stability.Internal
    public static CoreStorageBackend of(String alias) {
        return interned.computeIfAbsent(alias, k -> new CoreStorageBackend(alias));
    }

    @JsonValue
    @Stability.Internal
    public String alias() {
        return this.alias;
    }

    public String toString() {
        return this.alias();
    }
}

