/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.GetAndLockResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;

public class GetAndLockRequest
extends BaseKeyValueRequest<GetAndLockResponse> {
    private final Duration lockFor;

    public GetAndLockRequest(String key, Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, Duration lockFor, RequestSpan span) {
        super(timeout, ctx, retryStrategy, key, collectionIdentifier, span);
        this.lockFor = lockFor;
        if (span != null) {
            span.lowCardinalityAttribute("db.operation", "get_and_lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf key = null;
        ByteBuf extras = null;
        try {
            key = this.encodedKeyWithCollection(alloc, ctx);
            extras = alloc.buffer(4).writeInt((int)this.lockFor.getSeconds());
            byteBuf = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.GET_AND_LOCK, MemcacheProtocol.noDatatype(), this.partition(), opaque, MemcacheProtocol.noCas(), extras, key, MemcacheProtocol.noBody());
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(key);
            ReferenceCountUtil.release(extras);
            throw throwable;
        }
        ReferenceCountUtil.release(key);
        ReferenceCountUtil.release(extras);
        return byteBuf;
    }

    @Override
    public GetAndLockResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        ResponseStatus status = MemcacheProtocol.decodeStatus(response);
        long cas = MemcacheProtocol.cas(response);
        if (status.success()) {
            byte[] content = MemcacheProtocol.bodyAsBytes(response);
            int flags = MemcacheProtocol.extrasAsInt(response, 0, 0);
            return new GetAndLockResponse(status, content, cas, flags);
        }
        return new GetAndLockResponse(status, null, cas, 0);
    }

    @Override
    public String name() {
        return "get_and_lock";
    }
}

