/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.manager;

import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.api.manager.CoreBucketAndScope;
import com.couchbase.client.core.api.manager.search.CoreSearchIndex;
import com.couchbase.client.core.api.manager.search.CoreSearchIndexManager;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.deps.com.google.common.util.concurrent.ListenableFuture;
import com.couchbase.client.core.deps.com.google.protobuf.ByteString;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.protostellar.CoreProtostellarAccessors;
import com.couchbase.client.core.protostellar.CoreProtostellarErrorHandlingUtil;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.protostellar.admin.search.v1.AllowIndexQueryingRequest;
import com.couchbase.client.protostellar.admin.search.v1.AnalyzeDocumentRequest;
import com.couchbase.client.protostellar.admin.search.v1.CreateIndexRequest;
import com.couchbase.client.protostellar.admin.search.v1.DeleteIndexRequest;
import com.couchbase.client.protostellar.admin.search.v1.DisallowIndexQueryingRequest;
import com.couchbase.client.protostellar.admin.search.v1.FreezeIndexPlanRequest;
import com.couchbase.client.protostellar.admin.search.v1.GetIndexRequest;
import com.couchbase.client.protostellar.admin.search.v1.GetIndexedDocumentsCountRequest;
import com.couchbase.client.protostellar.admin.search.v1.GetIndexedDocumentsCountResponse;
import com.couchbase.client.protostellar.admin.search.v1.Index;
import com.couchbase.client.protostellar.admin.search.v1.ListIndexesRequest;
import com.couchbase.client.protostellar.admin.search.v1.PauseIndexIngestRequest;
import com.couchbase.client.protostellar.admin.search.v1.ResumeIndexIngestRequest;
import com.couchbase.client.protostellar.admin.search.v1.SearchAdminServiceGrpc;
import com.couchbase.client.protostellar.admin.search.v1.UnfreezeIndexPlanRequest;
import com.couchbase.client.protostellar.admin.search.v1.UpdateIndexRequest;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.util.annotation.Nullable;

public class ProtostellarCoreSearchIndexManager
implements CoreSearchIndexManager {
    private final CoreProtostellar core;
    @Nullable
    private final CoreBucketAndScope bucketAndScope;

    public ProtostellarCoreSearchIndexManager(CoreProtostellar protostellar, @Nullable CoreBucketAndScope bucketAndScope) {
        this.core = Objects.requireNonNull(protostellar);
        this.bucketAndScope = bucketAndScope;
    }

    private RequestSpan span(CoreCommonOptions opts, String tracingIdentifier) {
        return CoreProtostellarUtil.createSpan(this.core, tracingIdentifier, CoreDurability.NONE, opts.parentSpan().orElse(null));
    }

    private Duration timeout(CoreCommonOptions opts) {
        return CoreProtostellarUtil.managementTimeout(opts.timeout(), this.core);
    }

    private RetryStrategy retryStrategy(CoreCommonOptions opts) {
        return opts.retryStrategy().orElse(this.core.context().environment().retryStrategy());
    }

    private <T> ProtostellarRequest<T> protostellarRequest(T grpcRequest, CoreCommonOptions opts, String tracingIdentifier, ReadOnly readOnly) {
        return new ProtostellarRequest<T>(grpcRequest, this.core, ServiceType.MANAGER, tracingIdentifier, this.span(opts, tracingIdentifier), this.timeout(opts), readOnly == ReadOnly.YES, this.retryStrategy(opts), opts.clientContext(), 0L, null);
    }

    private <TSdkResult, TGrpcRequest, TGrpcResponse> CoreAsyncResponse<TSdkResult> exec(ProtostellarRequest<TGrpcRequest> request, BiFunction<SearchAdminServiceGrpc.SearchAdminServiceFutureStub, TGrpcRequest, ListenableFuture<TGrpcResponse>> invocation, Function<TGrpcResponse, TSdkResult> convertResponse) {
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> (ListenableFuture)invocation.apply((SearchAdminServiceGrpc.SearchAdminServiceFutureStub)endpoint.searchAdminStub().withDeadline(request.deadline()), request.request()), convertResponse, err -> CoreProtostellarErrorHandlingUtil.convertException(this.core, request, err));
    }

    @Override
    public CompletableFuture<CoreSearchIndex> getIndex(String name, CoreCommonOptions options) {
        GetIndexRequest.Builder builder = GetIndexRequest.newBuilder().setName(name);
        if (this.bucketAndScope != null) {
            builder.setBucketName(this.bucketAndScope.bucketName());
            builder.setScopeName(this.bucketAndScope.scopeName());
        }
        return this.exec(this.protostellarRequest(builder.build(), options, "manager_search_get_index", ReadOnly.YES), SearchAdminServiceGrpc.SearchAdminServiceFutureStub::getIndex, response -> ProtostellarCoreSearchIndexManager.decodeIndex(response.getIndex())).toFuture();
    }

    private static CoreSearchIndex decodeIndex(Index grpc) {
        return new CoreSearchIndex(grpc.getUuid(), grpc.getName(), grpc.getType(), ProtostellarCoreSearchIndexManager.decodeMap(grpc.getParamsMap()), grpc.getSourceUuid(), grpc.getSourceName(), ProtostellarCoreSearchIndexManager.decodeMap(grpc.getSourceParamsMap()), grpc.getSourceType(), ProtostellarCoreSearchIndexManager.decodeMap(grpc.getPlanParamsMap()));
    }

    private static Index.Builder encodeIndex(CoreSearchIndex index) {
        return Index.newBuilder().setUuid(index.uuid()).setName(index.name()).setType(index.type()).putAllParams(ProtostellarCoreSearchIndexManager.encodeMap(index.params())).setSourceUuid(index.sourceUuid()).setSourceName(index.sourceName()).putAllSourceParams(ProtostellarCoreSearchIndexManager.encodeMap(index.sourceParams())).setSourceType(index.sourceType()).putAllPlanParams(ProtostellarCoreSearchIndexManager.encodeMap(index.planParams()));
    }

    private void encodeIndex(CreateIndexRequest.Builder builder, CoreSearchIndex index) {
        builder.setName(index.name()).setType(index.type()).putAllParams(ProtostellarCoreSearchIndexManager.encodeMap(index.params())).setSourceUuid(index.sourceUuid()).setSourceName(index.sourceName()).putAllSourceParams(ProtostellarCoreSearchIndexManager.encodeMap(index.sourceParams())).setSourceType(index.sourceType()).putAllPlanParams(ProtostellarCoreSearchIndexManager.encodeMap(index.planParams()));
    }

    private static Map<String, Object> decodeMap(Map<String, ByteString> grpc) {
        return CbCollections.transformValues(grpc, value -> Mapper.decodeInto(value.toByteArray(), Object.class));
    }

    private static Map<String, ByteString> encodeMap(Map<String, Object> sdk) {
        return CbCollections.transformValues(sdk, value -> ByteString.copyFrom(Mapper.encodeAsBytes(value)));
    }

    @Override
    public CompletableFuture<List<CoreSearchIndex>> getAllIndexes(CoreCommonOptions options) {
        ListIndexesRequest.Builder builder = ListIndexesRequest.newBuilder();
        if (this.bucketAndScope != null) {
            builder.setBucketName(this.bucketAndScope.bucketName());
            builder.setScopeName(this.bucketAndScope.scopeName());
        }
        return this.exec(this.protostellarRequest(builder.build(), options, "manager_search_get_all_indexes", ReadOnly.YES), SearchAdminServiceGrpc.SearchAdminServiceFutureStub::listIndexes, response -> CbCollections.transform(response.getIndexesList(), ProtostellarCoreSearchIndexManager::decodeIndex)).toFuture();
    }

    @Override
    public CompletableFuture<Long> getIndexedDocumentsCount(String name, CoreCommonOptions options) {
        GetIndexedDocumentsCountRequest.Builder builder = GetIndexedDocumentsCountRequest.newBuilder().setName(name);
        if (this.bucketAndScope != null) {
            builder.setBucketName(this.bucketAndScope.bucketName());
            builder.setScopeName(this.bucketAndScope.scopeName());
        }
        return this.exec(this.protostellarRequest(builder.build(), options, "manager_search_get_indexed_documents_count", ReadOnly.YES), SearchAdminServiceGrpc.SearchAdminServiceFutureStub::getIndexedDocumentsCount, GetIndexedDocumentsCountResponse::getCount).toFuture();
    }

    @Override
    public CompletableFuture<Void> upsertIndex(CoreSearchIndex index, CoreCommonOptions options) {
        return CbStrings.isNullOrEmpty(index.uuid()) ? this.createIndex(index, options) : this.updateIndex(index, options);
    }

    private CompletableFuture<Void> createIndex(CoreSearchIndex index, CoreCommonOptions options) {
        CreateIndexRequest.Builder builder = CreateIndexRequest.newBuilder();
        this.encodeIndex(builder, index);
        if (this.bucketAndScope != null) {
            builder.setBucketName(this.bucketAndScope.bucketName());
            builder.setScopeName(this.bucketAndScope.scopeName());
        }
        return this.exec(this.protostellarRequest(builder.build(), options, "manager_search_upsert_index", ReadOnly.NO), SearchAdminServiceGrpc.SearchAdminServiceFutureStub::createIndex, response -> null).toFutureVoid();
    }

    private CompletableFuture<Void> updateIndex(CoreSearchIndex index, CoreCommonOptions options) {
        UpdateIndexRequest.Builder builder = UpdateIndexRequest.newBuilder().setIndex(ProtostellarCoreSearchIndexManager.encodeIndex(index));
        if (this.bucketAndScope != null) {
            builder.setBucketName(this.bucketAndScope.bucketName());
            builder.setScopeName(this.bucketAndScope.scopeName());
        }
        return this.exec(this.protostellarRequest(builder.build(), options, "manager_search_upsert_index", ReadOnly.NO), SearchAdminServiceGrpc.SearchAdminServiceFutureStub::updateIndex, response -> null).toFutureVoid();
    }

    @Override
    public CompletableFuture<Void> dropIndex(String name, CoreCommonOptions options) {
        DeleteIndexRequest.Builder builder = DeleteIndexRequest.newBuilder().setName(name);
        if (this.bucketAndScope != null) {
            builder.setBucketName(this.bucketAndScope.bucketName());
            builder.setScopeName(this.bucketAndScope.scopeName());
        }
        return this.exec(this.protostellarRequest(builder.build(), options, "manager_search_drop_index", ReadOnly.NO), SearchAdminServiceGrpc.SearchAdminServiceFutureStub::deleteIndex, response -> null).toFutureVoid();
    }

    @Override
    public CompletableFuture<List<ObjectNode>> analyzeDocument(String name, ObjectNode document, CoreCommonOptions options) {
        AnalyzeDocumentRequest.Builder builder = AnalyzeDocumentRequest.newBuilder().setName(name).setDoc(ByteString.copyFrom(Mapper.encodeAsBytes(document)));
        if (this.bucketAndScope != null) {
            builder.setBucketName(this.bucketAndScope.bucketName());
            builder.setScopeName(this.bucketAndScope.scopeName());
        }
        return this.exec(this.protostellarRequest(builder.build(), options, "manager_search_analyze_document", ReadOnly.YES), SearchAdminServiceGrpc.SearchAdminServiceFutureStub::analyzeDocument, response -> Mapper.decodeInto(response.getAnalyzed().toByteArray(), new TypeReference<List<ObjectNode>>(){})).toFuture();
    }

    @Override
    public CompletableFuture<Void> pauseIngest(String name, CoreCommonOptions options) {
        PauseIndexIngestRequest.Builder builder = PauseIndexIngestRequest.newBuilder().setName(name);
        if (this.bucketAndScope != null) {
            builder.setBucketName(this.bucketAndScope.bucketName());
            builder.setScopeName(this.bucketAndScope.scopeName());
        }
        return this.exec(this.protostellarRequest(builder.build(), options, "manager_search_pause_ingest", ReadOnly.NO), SearchAdminServiceGrpc.SearchAdminServiceFutureStub::pauseIndexIngest, response -> null).toFutureVoid();
    }

    @Override
    public CompletableFuture<Void> resumeIngest(String name, CoreCommonOptions options) {
        ResumeIndexIngestRequest.Builder builder = ResumeIndexIngestRequest.newBuilder().setName(name);
        if (this.bucketAndScope != null) {
            builder.setBucketName(this.bucketAndScope.bucketName());
            builder.setScopeName(this.bucketAndScope.scopeName());
        }
        return this.exec(this.protostellarRequest(builder.build(), options, "manager_search_resume_ingest", ReadOnly.NO), SearchAdminServiceGrpc.SearchAdminServiceFutureStub::resumeIndexIngest, response -> null).toFutureVoid();
    }

    @Override
    public CompletableFuture<Void> allowQuerying(String name, CoreCommonOptions options) {
        AllowIndexQueryingRequest.Builder builder = AllowIndexQueryingRequest.newBuilder().setName(name);
        if (this.bucketAndScope != null) {
            builder.setBucketName(this.bucketAndScope.bucketName());
            builder.setScopeName(this.bucketAndScope.scopeName());
        }
        return this.exec(this.protostellarRequest(builder.build(), options, "manager_search_allow_querying", ReadOnly.NO), SearchAdminServiceGrpc.SearchAdminServiceFutureStub::allowIndexQuerying, response -> null).toFutureVoid();
    }

    @Override
    public CompletableFuture<Void> disallowQuerying(String name, CoreCommonOptions options) {
        DisallowIndexQueryingRequest.Builder builder = DisallowIndexQueryingRequest.newBuilder().setName(name);
        if (this.bucketAndScope != null) {
            builder.setBucketName(this.bucketAndScope.bucketName());
            builder.setScopeName(this.bucketAndScope.scopeName());
        }
        return this.exec(this.protostellarRequest(builder.build(), options, "manager_search_disallow_querying", ReadOnly.NO), SearchAdminServiceGrpc.SearchAdminServiceFutureStub::disallowIndexQuerying, response -> null).toFutureVoid();
    }

    @Override
    public CompletableFuture<Void> freezePlan(String name, CoreCommonOptions options) {
        FreezeIndexPlanRequest.Builder builder = FreezeIndexPlanRequest.newBuilder().setName(name);
        if (this.bucketAndScope != null) {
            builder.setBucketName(this.bucketAndScope.bucketName());
            builder.setScopeName(this.bucketAndScope.scopeName());
        }
        return this.exec(this.protostellarRequest(builder.build(), options, "manager_search_freeze_plan", ReadOnly.NO), SearchAdminServiceGrpc.SearchAdminServiceFutureStub::freezeIndexPlan, response -> null).toFutureVoid();
    }

    @Override
    public CompletableFuture<Void> unfreezePlan(String name, CoreCommonOptions options) {
        UnfreezeIndexPlanRequest.Builder builder = UnfreezeIndexPlanRequest.newBuilder().setName(name);
        if (this.bucketAndScope != null) {
            builder.setBucketName(this.bucketAndScope.bucketName());
            builder.setScopeName(this.bucketAndScope.scopeName());
        }
        return this.exec(this.protostellarRequest(builder.build(), options, "manager_search_unfreeze_plan", ReadOnly.NO), SearchAdminServiceGrpc.SearchAdminServiceFutureStub::unfreezeIndexPlan, response -> null).toFutureVoid();
    }

    private static enum ReadOnly {
        YES,
        NO;

    }
}

