/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.support;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class SpanWrapper {
    private final long startTime = System.nanoTime();
    private final RequestSpan span;
    private boolean finished = false;
    private final boolean isInternal;

    public long elapsedMicros() {
        return (System.nanoTime() - this.startTime) * 1000L;
    }

    public long finish(@Nullable Throwable err) {
        if (err != null) {
            this.span.recordException(err);
            this.span.status(RequestSpan.StatusCode.ERROR);
        }
        return this.finish();
    }

    public long finish() {
        if (!this.finished) {
            this.finished = true;
            long elapsed = System.nanoTime() - this.startTime;
            this.span.end();
            return TimeUnit.NANOSECONDS.toMicros(elapsed);
        }
        return 0L;
    }

    public SpanWrapper(RequestSpan span) {
        this.span = Objects.requireNonNull(span);
        this.isInternal = CbTracing.isInternalSpan(span);
    }

    public static SpanWrapper create(RequestTracer tracer, String op, @Nullable SpanWrapper parent) {
        RequestSpan span = tracer.requestSpan(op, parent == null ? null : parent.span);
        return new SpanWrapper(span);
    }

    public <T> SpanWrapper attribute(String key, T value) {
        if (!this.isInternal) {
            this.span.attribute(key, String.valueOf(value));
        }
        return this;
    }

    public <T> SpanWrapper lowCardinalityAttribute(String key, T value) {
        if (!this.isInternal) {
            this.span.lowCardinalityAttribute(key, String.valueOf(value));
        }
        return this;
    }

    public RequestSpan span() {
        return this.span;
    }

    public long finishWithErrorStatus() {
        if (!this.isInternal) {
            this.span.status(RequestSpan.StatusCode.ERROR);
        }
        return this.finish();
    }

    public void setErrorStatus() {
        if (!this.isInternal) {
            this.span.status(RequestSpan.StatusCode.ERROR);
        }
    }

    public void recordExceptionAndSetErrorStatus(Throwable err) {
        if (!this.isInternal) {
            this.span.recordException(err);
            this.span.status(RequestSpan.StatusCode.ERROR);
        }
    }

    public void recordException(Throwable err) {
        if (!this.isInternal) {
            this.span.recordException(err);
        }
    }

    public boolean isInternal() {
        return this.isInternal;
    }
}

