/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.CbCollections;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Stability.Volatile
public enum StorageSizeUnit {
    BYTES("B", 1L),
    KIBIBYTES("KiB", 1024L),
    MEBIBYTES("MiB", 0x100000L),
    GIBIBYTES("GiB", 0x40000000L),
    TEBIBYTES("TiB", 0x10000000000L),
    PEBIBYTES("PiB", 0x4000000000000L);

    final String abbreviation;
    final long bytesPerUnit;
    static final List<StorageSizeUnit> valueList;
    private static final List<String> abbreviations;
    private static final Map<String, StorageSizeUnit> abbreviationToUnit;

    private StorageSizeUnit(String abbreviation, long bytesPerUnit) {
        this.abbreviation = Objects.requireNonNull(abbreviation);
        this.bytesPerUnit = bytesPerUnit;
    }

    static StorageSizeUnit parse(String abbreviation) {
        StorageSizeUnit result = abbreviationToUnit.get(abbreviation);
        if (result == null) {
            throw new IllegalArgumentException("Unrecognized storage unit '" + abbreviation + "' ;  expected one of " + abbreviations);
        }
        return result;
    }

    static StorageSizeUnit largestExactUnit(long bytes) {
        if (bytes == 0L) {
            return BYTES;
        }
        for (int i = valueList.size() - 1; i > 0; --i) {
            StorageSizeUnit unit = valueList.get(i);
            if (bytes % unit.bytesPerUnit != 0L) continue;
            return unit;
        }
        return BYTES;
    }

    static {
        valueList = CbCollections.listOf(StorageSizeUnit.values());
        abbreviations = CbCollections.transform(valueList, it -> it.abbreviation);
        abbreviationToUnit = Collections.unmodifiableMap(valueList.stream().collect(Collectors.toMap(it -> it.abbreviation, it -> it)));
    }
}

