/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;

public enum DurabilityLevel {
    NONE(0),
    MAJORITY(1),
    MAJORITY_AND_PERSIST_TO_ACTIVE(2),
    PERSIST_TO_MAJORITY(3);

    private final byte code;

    private DurabilityLevel(byte code) {
        this.code = code;
    }

    @Stability.Internal
    public byte code() {
        return this.code;
    }

    @Stability.Internal
    public static DurabilityLevel decodeFromManagementApi(String input) {
        if (input == null) {
            return NONE;
        }
        switch (input) {
            case "majority": {
                return MAJORITY;
            }
            case "majorityAndPersistActive": {
                return MAJORITY_AND_PERSIST_TO_ACTIVE;
            }
            case "persistToMajority": {
                return PERSIST_TO_MAJORITY;
            }
        }
        return NONE;
    }

    @Stability.Internal
    public String encodeForManagementApi() {
        switch (this.ordinal()) {
            case 0: {
                return "none";
            }
            case 1: {
                return "majority";
            }
            case 2: {
                return "majorityAndPersistActive";
            }
            case 3: {
                return "persistToMajority";
            }
        }
        throw InvalidArgumentException.fromMessage("The provided durability level is not supported: " + (Object)((Object)this));
    }
}

