/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.core;

import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;

public class ServiceReconfigurationFailedEvent
extends AbstractEvent {
    private final String hostname;
    private final ServiceType serviceType;
    private final Throwable reason;

    public ServiceReconfigurationFailedEvent(Context context, String hostname, ServiceType serviceType, Throwable reason) {
        super(Event.Severity.WARN, Event.Category.CORE, Duration.ZERO, context);
        this.reason = reason;
        this.hostname = hostname;
        this.serviceType = serviceType;
    }

    @Override
    public Throwable cause() {
        return this.reason;
    }

    public String hostname() {
        return this.hostname;
    }

    public ServiceType serviceType() {
        return this.serviceType;
    }

    @Override
    public String description() {
        return "Service " + (Object)((Object)this.serviceType) + " on " + RedactableArgument.redactSystem(this.hostname) + " failed to reconfigure: " + this.reason.getMessage();
    }
}

