/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.metrics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.ValueRecorder;
import com.couchbase.client.core.deps.org.HdrHistogram.Histogram;
import com.couchbase.client.core.deps.org.LatencyUtils.LatencyStats;
import java.util.Map;
import java.util.Objects;

@Stability.Volatile
public class AggregatingValueRecorder
implements ValueRecorder {
    private final String name;
    private final Map<String, String> tags;
    private final LatencyStats recorderStats = new LatencyStats();

    public AggregatingValueRecorder(String name, Map<String, String> tags) {
        this.name = name;
        this.tags = tags;
    }

    @Override
    public void recordValue(long value) {
        this.recorderStats.recordLatency(value);
    }

    Histogram clearStats() {
        return this.recorderStats.getIntervalHistogram();
    }

    Map<String, String> tags() {
        return this.tags;
    }

    public String toString() {
        return "AggregatingValueRecorder{name='" + this.name + '\'' + ", tags=" + this.tags + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregatingValueRecorder that = (AggregatingValueRecorder)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.tags);
    }
}

