/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.xbill.DNS;

import com.couchbase.client.core.deps.org.xbill.DNS.Compression;
import com.couchbase.client.core.deps.org.xbill.DNS.DNSInput;
import com.couchbase.client.core.deps.org.xbill.DNS.DNSOutput;
import com.couchbase.client.core.deps.org.xbill.DNS.Name;
import com.couchbase.client.core.deps.org.xbill.DNS.Record;
import com.couchbase.client.core.deps.org.xbill.DNS.Tokenizer;
import java.io.IOException;

public class SRVRecord
extends Record {
    private int priority;
    private int weight;
    private int port;
    private Name target;

    SRVRecord() {
    }

    public SRVRecord(Name name, int dclass, long ttl, int priority, int weight, int port, Name target) {
        super(name, 33, dclass, ttl);
        this.priority = SRVRecord.checkU16("priority", priority);
        this.weight = SRVRecord.checkU16("weight", weight);
        this.port = SRVRecord.checkU16("port", port);
        this.target = SRVRecord.checkName("target", target);
    }

    @Override
    protected void rrFromWire(DNSInput in) throws IOException {
        this.priority = in.readU16();
        this.weight = in.readU16();
        this.port = in.readU16();
        this.target = new Name(in);
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.priority = st.getUInt16();
        this.weight = st.getUInt16();
        this.port = st.getUInt16();
        this.target = st.getName(origin);
    }

    @Override
    protected String rrToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.priority).append(" ");
        sb.append(this.weight).append(" ");
        sb.append(this.port).append(" ");
        sb.append(this.target);
        return sb.toString();
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getPort() {
        return this.port;
    }

    public Name getTarget() {
        return this.target;
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU16(this.priority);
        out.writeU16(this.weight);
        out.writeU16(this.port);
        this.target.toWire(out, null, canonical);
    }

    @Override
    public Name getAdditionalName() {
        return this.target;
    }
}

