/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

public enum SaslMechanism {
    PLAIN("PLAIN", 1),
    SCRAM_SHA1("SCRAM-SHA1", 2),
    SCRAM_SHA256("SCRAM-SHA256", 2),
    SCRAM_SHA512("SCRAM-SHA512", 2);

    private final String mech;
    private final int roundtrips;

    private SaslMechanism(String mech, int roundtrips) {
        this.mech = mech;
        this.roundtrips = roundtrips;
    }

    public String mech() {
        return this.mech;
    }

    public int roundtrips() {
        return this.roundtrips;
    }

    public static SaslMechanism from(String mech) {
        if (mech.equalsIgnoreCase("PLAIN")) {
            return PLAIN;
        }
        if (mech.equalsIgnoreCase("SCRAM-SHA1")) {
            return SCRAM_SHA1;
        }
        if (mech.equalsIgnoreCase("SCRAM-SHA256")) {
            return SCRAM_SHA256;
        }
        if (mech.equalsIgnoreCase("SCRAM-SHA512")) {
            return SCRAM_SHA512;
        }
        return null;
    }
}

