/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;

@Stability.Volatile
public class TimerConfig {
    public static final int DEFAULT_NUM_TIMERS = 1;
    public static final Duration DEFAULT_TICK_DURATION = Duration.ofMillis(10L);
    public static final int DEFAULT_NUM_BUCKETS = 512;
    private final int numTimers;
    private final Duration tickDuration;
    private final int numBuckets;

    private TimerConfig(Builder builder) {
        this.numTimers = builder.numTimers;
        this.tickDuration = builder.tickDuration;
        this.numBuckets = builder.numBuckets;
    }

    @Deprecated
    public static TimerConfig create() {
        return TimerConfig.builder().build();
    }

    @Deprecated
    public static Builder builder() {
        return new Builder();
    }

    public int numTimers() {
        return this.numTimers;
    }

    public Duration tickDuration() {
        return this.tickDuration;
    }

    public int numBuckets() {
        return this.numBuckets;
    }

    @Stability.Internal
    public Map<String, Object> exportAsMap() {
        LinkedHashMap<String, Object> export = new LinkedHashMap<String, Object>();
        export.put("numTimers", this.numTimers);
        export.put("tickDurationMs", this.tickDuration.toMillis());
        export.put("numBuckets", this.numBuckets);
        return export;
    }

    public static class Builder {
        private int numTimers = 1;
        private Duration tickDuration = DEFAULT_TICK_DURATION;
        private int numBuckets = 512;

        @Stability.Volatile
        public Builder numTimers(int numTimers) {
            this.numTimers = numTimers;
            return this;
        }

        @Stability.Volatile
        public Builder tickDuration(Duration tickDuration) {
            this.tickDuration = tickDuration;
            return this;
        }

        @Stability.Volatile
        public Builder numBuckets(int numBuckets) {
            this.numBuckets = numBuckets;
            return this;
        }

        public TimerConfig build() {
            return new TimerConfig(this);
        }
    }
}

