/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.GetCollectionIdResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Optional;

public class GetCollectionIdRequest
extends BaseKeyValueRequest<GetCollectionIdResponse> {
    public GetCollectionIdRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, CollectionIdentifier collectionIdentifier) {
        super(timeout, ctx, retryStrategy, null, collectionIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf body = null;
        try {
            CollectionIdentifier ci = this.collectionIdentifier();
            if (!ci.collection().isPresent()) {
                throw InvalidArgumentException.fromMessage("A collection name needs to be present");
            }
            body = Unpooled.copiedBuffer(ci.scope().orElse("") + "." + ci.collection().get(), StandardCharsets.UTF_8);
            byteBuf = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.COLLECTIONS_GET_CID, MemcacheProtocol.noDatatype(), MemcacheProtocol.noPartition(), opaque, MemcacheProtocol.noCas(), MemcacheProtocol.noExtras(), MemcacheProtocol.noKey(), body);
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(body);
            throw throwable;
        }
        ReferenceCountUtil.release(body);
        return byteBuf;
    }

    @Override
    public GetCollectionIdResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        ResponseStatus status = MemcacheProtocol.decodeStatus(response);
        Optional<Long> cid = Optional.empty();
        if (status.success()) {
            cid = Optional.of(MemcacheProtocol.extras(response).get().getUnsignedInt(8));
        }
        return new GetCollectionIdResponse(status, cid);
    }

    @Override
    public boolean idempotent() {
        return true;
    }

    @Override
    public String name() {
        return "get_collection_id";
    }
}

