/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/type/datetime.proto

// Protobuf Java Version: 3.25.5
package com.couchbase.client.core.deps.com.google.type;

/**
 *
 *
 * <pre>
 * Represents civil time (or occasionally physical time).
 *
 * This type can represent a civil time in one of a few possible ways:
 *
 *  * When utc_offset is set and time_zone is unset: a civil time on a calendar
 *    day with a particular offset from UTC.
 *  * When time_zone is set and utc_offset is unset: a civil time on a calendar
 *    day in a particular time zone.
 *  * When neither time_zone nor utc_offset is set: a civil time on a calendar
 *    day in local time.
 *
 * The date is relative to the Proleptic Gregorian Calendar.
 *
 * If year is 0, the DateTime is considered not to have a specific year. month
 * and day must have valid, non-zero values.
 *
 * This type may also be used to represent a physical time if all the date and
 * time fields are set and either case of the `time_offset` oneof is set.
 * Consider using `Timestamp` message for physical time instead. If your use
 * case also would like to store the user's timezone, that can be done in
 * another field.
 *
 * This type is more flexible than some applications may want. Make sure to
 * document and validate your application's limitations.
 * </pre>
 *
 * Protobuf type {@code google.type.DateTime}
 */
public final class DateTime extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.type.DateTime)
    DateTimeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DateTime.newBuilder() to construct.
  private DateTime(com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DateTime() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DateTime();
  }

  public static final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.type.DateTimeProto.internal_static_google_type_DateTime_descriptor;
  }

  @java.lang.Override
  protected com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.type.DateTimeProto.internal_static_google_type_DateTime_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.type.DateTime.class, com.google.type.DateTime.Builder.class);
  }

  private int timeOffsetCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object timeOffset_;

  public enum TimeOffsetCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    UTC_OFFSET(8),
    TIME_ZONE(9),
    TIMEOFFSET_NOT_SET(0);
    private final int value;

    private TimeOffsetCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TimeOffsetCase valueOf(int value) {
      return forNumber(value);
    }

    public static TimeOffsetCase forNumber(int value) {
      switch (value) {
        case 8:
          return UTC_OFFSET;
        case 9:
          return TIME_ZONE;
        case 0:
          return TIMEOFFSET_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TimeOffsetCase getTimeOffsetCase() {
    return TimeOffsetCase.forNumber(timeOffsetCase_);
  }

  public static final int YEAR_FIELD_NUMBER = 1;
  private int year_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a
   * datetime without a year.
   * </pre>
   *
   * <code>int32 year = 1;</code>
   *
   * @return The year.
   */
  @java.lang.Override
  public int getYear() {
    return year_;
  }

  public static final int MONTH_FIELD_NUMBER = 2;
  private int month_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Month of year. Must be from 1 to 12.
   * </pre>
   *
   * <code>int32 month = 2;</code>
   *
   * @return The month.
   */
  @java.lang.Override
  public int getMonth() {
    return month_;
  }

  public static final int DAY_FIELD_NUMBER = 3;
  private int day_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Day of month. Must be from 1 to 31 and valid for the year and
   * month.
   * </pre>
   *
   * <code>int32 day = 3;</code>
   *
   * @return The day.
   */
  @java.lang.Override
  public int getDay() {
    return day_;
  }

  public static final int HOURS_FIELD_NUMBER = 4;
  private int hours_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Hours of day in 24 hour format. Should be from 0 to 23. An API
   * may choose to allow the value "24:00:00" for scenarios like business
   * closing time.
   * </pre>
   *
   * <code>int32 hours = 4;</code>
   *
   * @return The hours.
   */
  @java.lang.Override
  public int getHours() {
    return hours_;
  }

  public static final int MINUTES_FIELD_NUMBER = 5;
  private int minutes_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Minutes of hour of day. Must be from 0 to 59.
   * </pre>
   *
   * <code>int32 minutes = 5;</code>
   *
   * @return The minutes.
   */
  @java.lang.Override
  public int getMinutes() {
    return minutes_;
  }

  public static final int SECONDS_FIELD_NUMBER = 6;
  private int seconds_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Seconds of minutes of the time. Must normally be from 0 to 59. An
   * API may allow the value 60 if it allows leap-seconds.
   * </pre>
   *
   * <code>int32 seconds = 6;</code>
   *
   * @return The seconds.
   */
  @java.lang.Override
  public int getSeconds() {
    return seconds_;
  }

  public static final int NANOS_FIELD_NUMBER = 7;
  private int nanos_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Fractions of seconds in nanoseconds. Must be from 0 to
   * 999,999,999.
   * </pre>
   *
   * <code>int32 nanos = 7;</code>
   *
   * @return The nanos.
   */
  @java.lang.Override
  public int getNanos() {
    return nanos_;
  }

  public static final int UTC_OFFSET_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * UTC offset. Must be whole seconds, between -18 hours and +18 hours.
   * For example, a UTC offset of -4:00 would be represented as
   * { seconds: -14400 }.
   * </pre>
   *
   * <code>.google.protobuf.Duration utc_offset = 8;</code>
   *
   * @return Whether the utcOffset field is set.
   */
  @java.lang.Override
  public boolean hasUtcOffset() {
    return timeOffsetCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * UTC offset. Must be whole seconds, between -18 hours and +18 hours.
   * For example, a UTC offset of -4:00 would be represented as
   * { seconds: -14400 }.
   * </pre>
   *
   * <code>.google.protobuf.Duration utc_offset = 8;</code>
   *
   * @return The utcOffset.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.Duration getUtcOffset() {
    if (timeOffsetCase_ == 8) {
      return (com.couchbase.client.core.deps.com.google.protobuf.Duration) timeOffset_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * UTC offset. Must be whole seconds, between -18 hours and +18 hours.
   * For example, a UTC offset of -4:00 would be represented as
   * { seconds: -14400 }.
   * </pre>
   *
   * <code>.google.protobuf.Duration utc_offset = 8;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.DurationOrBuilder getUtcOffsetOrBuilder() {
    if (timeOffsetCase_ == 8) {
      return (com.couchbase.client.core.deps.com.google.protobuf.Duration) timeOffset_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Time zone.
   * </pre>
   *
   * <code>.google.type.TimeZone time_zone = 9;</code>
   *
   * @return Whether the timeZone field is set.
   */
  @java.lang.Override
  public boolean hasTimeZone() {
    return timeOffsetCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Time zone.
   * </pre>
   *
   * <code>.google.type.TimeZone time_zone = 9;</code>
   *
   * @return The timeZone.
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.type.TimeZone getTimeZone() {
    if (timeOffsetCase_ == 9) {
      return (com.couchbase.client.core.deps.com.google.type.TimeZone) timeOffset_;
    }
    return com.google.type.TimeZone.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Time zone.
   * </pre>
   *
   * <code>.google.type.TimeZone time_zone = 9;</code>
   */
  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.type.TimeZoneOrBuilder getTimeZoneOrBuilder() {
    if (timeOffsetCase_ == 9) {
      return (com.couchbase.client.core.deps.com.google.type.TimeZone) timeOffset_;
    }
    return com.google.type.TimeZone.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.couchbase.client.core.deps.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (year_ != 0) {
      output.writeInt32(1, year_);
    }
    if (month_ != 0) {
      output.writeInt32(2, month_);
    }
    if (day_ != 0) {
      output.writeInt32(3, day_);
    }
    if (hours_ != 0) {
      output.writeInt32(4, hours_);
    }
    if (minutes_ != 0) {
      output.writeInt32(5, minutes_);
    }
    if (seconds_ != 0) {
      output.writeInt32(6, seconds_);
    }
    if (nanos_ != 0) {
      output.writeInt32(7, nanos_);
    }
    if (timeOffsetCase_ == 8) {
      output.writeMessage(8, (com.couchbase.client.core.deps.com.google.protobuf.Duration) timeOffset_);
    }
    if (timeOffsetCase_ == 9) {
      output.writeMessage(9, (com.couchbase.client.core.deps.com.google.type.TimeZone) timeOffset_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (year_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, year_);
    }
    if (month_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, month_);
    }
    if (day_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, day_);
    }
    if (hours_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, hours_);
    }
    if (minutes_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, minutes_);
    }
    if (seconds_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, seconds_);
    }
    if (nanos_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, nanos_);
    }
    if (timeOffsetCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.couchbase.client.core.deps.com.google.protobuf.Duration) timeOffset_);
    }
    if (timeOffsetCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.couchbase.client.core.deps.com.google.type.TimeZone) timeOffset_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.type.DateTime)) {
      return super.equals(obj);
    }
    com.google.type.DateTime other = (com.couchbase.client.core.deps.com.google.type.DateTime) obj;

    if (getYear() != other.getYear()) return false;
    if (getMonth() != other.getMonth()) return false;
    if (getDay() != other.getDay()) return false;
    if (getHours() != other.getHours()) return false;
    if (getMinutes() != other.getMinutes()) return false;
    if (getSeconds() != other.getSeconds()) return false;
    if (getNanos() != other.getNanos()) return false;
    if (!getTimeOffsetCase().equals(other.getTimeOffsetCase())) return false;
    switch (timeOffsetCase_) {
      case 8:
        if (!getUtcOffset().equals(other.getUtcOffset())) return false;
        break;
      case 9:
        if (!getTimeZone().equals(other.getTimeZone())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + YEAR_FIELD_NUMBER;
    hash = (53 * hash) + getYear();
    hash = (37 * hash) + MONTH_FIELD_NUMBER;
    hash = (53 * hash) + getMonth();
    hash = (37 * hash) + DAY_FIELD_NUMBER;
    hash = (53 * hash) + getDay();
    hash = (37 * hash) + HOURS_FIELD_NUMBER;
    hash = (53 * hash) + getHours();
    hash = (37 * hash) + MINUTES_FIELD_NUMBER;
    hash = (53 * hash) + getMinutes();
    hash = (37 * hash) + SECONDS_FIELD_NUMBER;
    hash = (53 * hash) + getSeconds();
    hash = (37 * hash) + NANOS_FIELD_NUMBER;
    hash = (53 * hash) + getNanos();
    switch (timeOffsetCase_) {
      case 8:
        hash = (37 * hash) + UTC_OFFSET_FIELD_NUMBER;
        hash = (53 * hash) + getUtcOffset().hashCode();
        break;
      case 9:
        hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
        hash = (53 * hash) + getTimeZone().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.couchbase.client.core.deps.com.google.type.DateTime parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.couchbase.client.core.deps.com.google.type.DateTime parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.type.DateTime parseFrom(com.couchbase.client.core.deps.com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.couchbase.client.core.deps.com.google.type.DateTime parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.type.DateTime parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.couchbase.client.core.deps.com.google.type.DateTime parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.type.DateTime parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.couchbase.client.core.deps.com.google.type.DateTime parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.type.DateTime parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.couchbase.client.core.deps.com.google.type.DateTime parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.couchbase.client.core.deps.com.google.type.DateTime parseFrom(com.couchbase.client.core.deps.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.couchbase.client.core.deps.com.google.type.DateTime parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.couchbase.client.core.deps.com.google.type.DateTime prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents civil time (or occasionally physical time).
   *
   * This type can represent a civil time in one of a few possible ways:
   *
   *  * When utc_offset is set and time_zone is unset: a civil time on a calendar
   *    day with a particular offset from UTC.
   *  * When time_zone is set and utc_offset is unset: a civil time on a calendar
   *    day in a particular time zone.
   *  * When neither time_zone nor utc_offset is set: a civil time on a calendar
   *    day in local time.
   *
   * The date is relative to the Proleptic Gregorian Calendar.
   *
   * If year is 0, the DateTime is considered not to have a specific year. month
   * and day must have valid, non-zero values.
   *
   * This type may also be used to represent a physical time if all the date and
   * time fields are set and either case of the `time_offset` oneof is set.
   * Consider using `Timestamp` message for physical time instead. If your use
   * case also would like to store the user's timezone, that can be done in
   * another field.
   *
   * This type is more flexible than some applications may want. Make sure to
   * document and validate your application's limitations.
   * </pre>
   *
   * Protobuf type {@code google.type.DateTime}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.type.DateTime)
      com.google.type.DateTimeOrBuilder {
    public static final com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.type.DateTimeProto.internal_static_google_type_DateTime_descriptor;
    }

    @java.lang.Override
    protected com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.type.DateTimeProto.internal_static_google_type_DateTime_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.type.DateTime.class, com.google.type.DateTime.Builder.class);
    }

    // Construct using com.google.type.DateTime.newBuilder()
    private Builder() {}

    private Builder(com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      year_ = 0;
      month_ = 0;
      day_ = 0;
      hours_ = 0;
      minutes_ = 0;
      seconds_ = 0;
      nanos_ = 0;
      if (utcOffsetBuilder_ != null) {
        utcOffsetBuilder_.clear();
      }
      if (timeZoneBuilder_ != null) {
        timeZoneBuilder_.clear();
      }
      timeOffsetCase_ = 0;
      timeOffset_ = null;
      return this;
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.type.DateTimeProto.internal_static_google_type_DateTime_descriptor;
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.type.DateTime getDefaultInstanceForType() {
      return com.google.type.DateTime.getDefaultInstance();
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.type.DateTime build() {
      com.google.type.DateTime result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.type.DateTime buildPartial() {
      com.google.type.DateTime result = new com.google.type.DateTime(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.couchbase.client.core.deps.com.google.type.DateTime result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.year_ = year_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.month_ = month_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.day_ = day_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.hours_ = hours_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.minutes_ = minutes_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.seconds_ = seconds_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.nanos_ = nanos_;
      }
    }

    private void buildPartialOneofs(com.couchbase.client.core.deps.com.google.type.DateTime result) {
      result.timeOffsetCase_ = timeOffsetCase_;
      result.timeOffset_ = this.timeOffset_;
      if (timeOffsetCase_ == 8 && utcOffsetBuilder_ != null) {
        result.timeOffset_ = utcOffsetBuilder_.build();
      }
      if (timeOffsetCase_ == 9 && timeZoneBuilder_ != null) {
        result.timeOffset_ = timeZoneBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.couchbase.client.core.deps.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.couchbase.client.core.deps.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.couchbase.client.core.deps.com.google.protobuf.Message other) {
      if (other instanceof com.google.type.DateTime) {
        return mergeFrom((com.couchbase.client.core.deps.com.google.type.DateTime) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.couchbase.client.core.deps.com.google.type.DateTime other) {
      if (other == com.google.type.DateTime.getDefaultInstance()) return this;
      if (other.getYear() != 0) {
        setYear(other.getYear());
      }
      if (other.getMonth() != 0) {
        setMonth(other.getMonth());
      }
      if (other.getDay() != 0) {
        setDay(other.getDay());
      }
      if (other.getHours() != 0) {
        setHours(other.getHours());
      }
      if (other.getMinutes() != 0) {
        setMinutes(other.getMinutes());
      }
      if (other.getSeconds() != 0) {
        setSeconds(other.getSeconds());
      }
      if (other.getNanos() != 0) {
        setNanos(other.getNanos());
      }
      switch (other.getTimeOffsetCase()) {
        case UTC_OFFSET:
          {
            mergeUtcOffset(other.getUtcOffset());
            break;
          }
        case TIME_ZONE:
          {
            mergeTimeZone(other.getTimeZone());
            break;
          }
        case TIMEOFFSET_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                year_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                month_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                day_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                hours_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                minutes_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                seconds_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                nanos_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                input.readMessage(getUtcOffsetFieldBuilder().getBuilder(), extensionRegistry);
                timeOffsetCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getTimeZoneFieldBuilder().getBuilder(), extensionRegistry);
                timeOffsetCase_ = 9;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.couchbase.client.core.deps.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int timeOffsetCase_ = 0;
    private java.lang.Object timeOffset_;

    public TimeOffsetCase getTimeOffsetCase() {
      return TimeOffsetCase.forNumber(timeOffsetCase_);
    }

    public Builder clearTimeOffset() {
      timeOffsetCase_ = 0;
      timeOffset_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private int year_;
    /**
     *
     *
     * <pre>
     * Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a
     * datetime without a year.
     * </pre>
     *
     * <code>int32 year = 1;</code>
     *
     * @return The year.
     */
    @java.lang.Override
    public int getYear() {
      return year_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a
     * datetime without a year.
     * </pre>
     *
     * <code>int32 year = 1;</code>
     *
     * @param value The year to set.
     * @return This builder for chaining.
     */
    public Builder setYear(int value) {

      year_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a
     * datetime without a year.
     * </pre>
     *
     * <code>int32 year = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearYear() {
      bitField0_ = (bitField0_ & ~0x00000001);
      year_ = 0;
      onChanged();
      return this;
    }

    private int month_;
    /**
     *
     *
     * <pre>
     * Required. Month of year. Must be from 1 to 12.
     * </pre>
     *
     * <code>int32 month = 2;</code>
     *
     * @return The month.
     */
    @java.lang.Override
    public int getMonth() {
      return month_;
    }
    /**
     *
     *
     * <pre>
     * Required. Month of year. Must be from 1 to 12.
     * </pre>
     *
     * <code>int32 month = 2;</code>
     *
     * @param value The month to set.
     * @return This builder for chaining.
     */
    public Builder setMonth(int value) {

      month_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Month of year. Must be from 1 to 12.
     * </pre>
     *
     * <code>int32 month = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMonth() {
      bitField0_ = (bitField0_ & ~0x00000002);
      month_ = 0;
      onChanged();
      return this;
    }

    private int day_;
    /**
     *
     *
     * <pre>
     * Required. Day of month. Must be from 1 to 31 and valid for the year and
     * month.
     * </pre>
     *
     * <code>int32 day = 3;</code>
     *
     * @return The day.
     */
    @java.lang.Override
    public int getDay() {
      return day_;
    }
    /**
     *
     *
     * <pre>
     * Required. Day of month. Must be from 1 to 31 and valid for the year and
     * month.
     * </pre>
     *
     * <code>int32 day = 3;</code>
     *
     * @param value The day to set.
     * @return This builder for chaining.
     */
    public Builder setDay(int value) {

      day_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Day of month. Must be from 1 to 31 and valid for the year and
     * month.
     * </pre>
     *
     * <code>int32 day = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDay() {
      bitField0_ = (bitField0_ & ~0x00000004);
      day_ = 0;
      onChanged();
      return this;
    }

    private int hours_;
    /**
     *
     *
     * <pre>
     * Required. Hours of day in 24 hour format. Should be from 0 to 23. An API
     * may choose to allow the value "24:00:00" for scenarios like business
     * closing time.
     * </pre>
     *
     * <code>int32 hours = 4;</code>
     *
     * @return The hours.
     */
    @java.lang.Override
    public int getHours() {
      return hours_;
    }
    /**
     *
     *
     * <pre>
     * Required. Hours of day in 24 hour format. Should be from 0 to 23. An API
     * may choose to allow the value "24:00:00" for scenarios like business
     * closing time.
     * </pre>
     *
     * <code>int32 hours = 4;</code>
     *
     * @param value The hours to set.
     * @return This builder for chaining.
     */
    public Builder setHours(int value) {

      hours_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Hours of day in 24 hour format. Should be from 0 to 23. An API
     * may choose to allow the value "24:00:00" for scenarios like business
     * closing time.
     * </pre>
     *
     * <code>int32 hours = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHours() {
      bitField0_ = (bitField0_ & ~0x00000008);
      hours_ = 0;
      onChanged();
      return this;
    }

    private int minutes_;
    /**
     *
     *
     * <pre>
     * Required. Minutes of hour of day. Must be from 0 to 59.
     * </pre>
     *
     * <code>int32 minutes = 5;</code>
     *
     * @return The minutes.
     */
    @java.lang.Override
    public int getMinutes() {
      return minutes_;
    }
    /**
     *
     *
     * <pre>
     * Required. Minutes of hour of day. Must be from 0 to 59.
     * </pre>
     *
     * <code>int32 minutes = 5;</code>
     *
     * @param value The minutes to set.
     * @return This builder for chaining.
     */
    public Builder setMinutes(int value) {

      minutes_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Minutes of hour of day. Must be from 0 to 59.
     * </pre>
     *
     * <code>int32 minutes = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinutes() {
      bitField0_ = (bitField0_ & ~0x00000010);
      minutes_ = 0;
      onChanged();
      return this;
    }

    private int seconds_;
    /**
     *
     *
     * <pre>
     * Required. Seconds of minutes of the time. Must normally be from 0 to 59. An
     * API may allow the value 60 if it allows leap-seconds.
     * </pre>
     *
     * <code>int32 seconds = 6;</code>
     *
     * @return The seconds.
     */
    @java.lang.Override
    public int getSeconds() {
      return seconds_;
    }
    /**
     *
     *
     * <pre>
     * Required. Seconds of minutes of the time. Must normally be from 0 to 59. An
     * API may allow the value 60 if it allows leap-seconds.
     * </pre>
     *
     * <code>int32 seconds = 6;</code>
     *
     * @param value The seconds to set.
     * @return This builder for chaining.
     */
    public Builder setSeconds(int value) {

      seconds_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Seconds of minutes of the time. Must normally be from 0 to 59. An
     * API may allow the value 60 if it allows leap-seconds.
     * </pre>
     *
     * <code>int32 seconds = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSeconds() {
      bitField0_ = (bitField0_ & ~0x00000020);
      seconds_ = 0;
      onChanged();
      return this;
    }

    private int nanos_;
    /**
     *
     *
     * <pre>
     * Required. Fractions of seconds in nanoseconds. Must be from 0 to
     * 999,999,999.
     * </pre>
     *
     * <code>int32 nanos = 7;</code>
     *
     * @return The nanos.
     */
    @java.lang.Override
    public int getNanos() {
      return nanos_;
    }
    /**
     *
     *
     * <pre>
     * Required. Fractions of seconds in nanoseconds. Must be from 0 to
     * 999,999,999.
     * </pre>
     *
     * <code>int32 nanos = 7;</code>
     *
     * @param value The nanos to set.
     * @return This builder for chaining.
     */
    public Builder setNanos(int value) {

      nanos_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Fractions of seconds in nanoseconds. Must be from 0 to
     * 999,999,999.
     * </pre>
     *
     * <code>int32 nanos = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNanos() {
      bitField0_ = (bitField0_ & ~0x00000040);
      nanos_ = 0;
      onChanged();
      return this;
    }

    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        utcOffsetBuilder_;
    /**
     *
     *
     * <pre>
     * UTC offset. Must be whole seconds, between -18 hours and +18 hours.
     * For example, a UTC offset of -4:00 would be represented as
     * { seconds: -14400 }.
     * </pre>
     *
     * <code>.google.protobuf.Duration utc_offset = 8;</code>
     *
     * @return Whether the utcOffset field is set.
     */
    @java.lang.Override
    public boolean hasUtcOffset() {
      return timeOffsetCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * UTC offset. Must be whole seconds, between -18 hours and +18 hours.
     * For example, a UTC offset of -4:00 would be represented as
     * { seconds: -14400 }.
     * </pre>
     *
     * <code>.google.protobuf.Duration utc_offset = 8;</code>
     *
     * @return The utcOffset.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.protobuf.Duration getUtcOffset() {
      if (utcOffsetBuilder_ == null) {
        if (timeOffsetCase_ == 8) {
          return (com.couchbase.client.core.deps.com.google.protobuf.Duration) timeOffset_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      } else {
        if (timeOffsetCase_ == 8) {
          return utcOffsetBuilder_.getMessage();
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * UTC offset. Must be whole seconds, between -18 hours and +18 hours.
     * For example, a UTC offset of -4:00 would be represented as
     * { seconds: -14400 }.
     * </pre>
     *
     * <code>.google.protobuf.Duration utc_offset = 8;</code>
     */
    public Builder setUtcOffset(com.couchbase.client.core.deps.com.google.protobuf.Duration value) {
      if (utcOffsetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeOffset_ = value;
        onChanged();
      } else {
        utcOffsetBuilder_.setMessage(value);
      }
      timeOffsetCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * UTC offset. Must be whole seconds, between -18 hours and +18 hours.
     * For example, a UTC offset of -4:00 would be represented as
     * { seconds: -14400 }.
     * </pre>
     *
     * <code>.google.protobuf.Duration utc_offset = 8;</code>
     */
    public Builder setUtcOffset(com.couchbase.client.core.deps.com.google.protobuf.Duration.Builder builderForValue) {
      if (utcOffsetBuilder_ == null) {
        timeOffset_ = builderForValue.build();
        onChanged();
      } else {
        utcOffsetBuilder_.setMessage(builderForValue.build());
      }
      timeOffsetCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * UTC offset. Must be whole seconds, between -18 hours and +18 hours.
     * For example, a UTC offset of -4:00 would be represented as
     * { seconds: -14400 }.
     * </pre>
     *
     * <code>.google.protobuf.Duration utc_offset = 8;</code>
     */
    public Builder mergeUtcOffset(com.couchbase.client.core.deps.com.google.protobuf.Duration value) {
      if (utcOffsetBuilder_ == null) {
        if (timeOffsetCase_ == 8
            && timeOffset_ != com.google.protobuf.Duration.getDefaultInstance()) {
          timeOffset_ =
              com.google.protobuf.Duration.newBuilder((com.couchbase.client.core.deps.com.google.protobuf.Duration) timeOffset_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          timeOffset_ = value;
        }
        onChanged();
      } else {
        if (timeOffsetCase_ == 8) {
          utcOffsetBuilder_.mergeFrom(value);
        } else {
          utcOffsetBuilder_.setMessage(value);
        }
      }
      timeOffsetCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * UTC offset. Must be whole seconds, between -18 hours and +18 hours.
     * For example, a UTC offset of -4:00 would be represented as
     * { seconds: -14400 }.
     * </pre>
     *
     * <code>.google.protobuf.Duration utc_offset = 8;</code>
     */
    public Builder clearUtcOffset() {
      if (utcOffsetBuilder_ == null) {
        if (timeOffsetCase_ == 8) {
          timeOffsetCase_ = 0;
          timeOffset_ = null;
          onChanged();
        }
      } else {
        if (timeOffsetCase_ == 8) {
          timeOffsetCase_ = 0;
          timeOffset_ = null;
        }
        utcOffsetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * UTC offset. Must be whole seconds, between -18 hours and +18 hours.
     * For example, a UTC offset of -4:00 would be represented as
     * { seconds: -14400 }.
     * </pre>
     *
     * <code>.google.protobuf.Duration utc_offset = 8;</code>
     */
    public com.couchbase.client.core.deps.com.google.protobuf.Duration.Builder getUtcOffsetBuilder() {
      return getUtcOffsetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * UTC offset. Must be whole seconds, between -18 hours and +18 hours.
     * For example, a UTC offset of -4:00 would be represented as
     * { seconds: -14400 }.
     * </pre>
     *
     * <code>.google.protobuf.Duration utc_offset = 8;</code>
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.protobuf.DurationOrBuilder getUtcOffsetOrBuilder() {
      if ((timeOffsetCase_ == 8) && (utcOffsetBuilder_ != null)) {
        return utcOffsetBuilder_.getMessageOrBuilder();
      } else {
        if (timeOffsetCase_ == 8) {
          return (com.couchbase.client.core.deps.com.google.protobuf.Duration) timeOffset_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * UTC offset. Must be whole seconds, between -18 hours and +18 hours.
     * For example, a UTC offset of -4:00 would be represented as
     * { seconds: -14400 }.
     * </pre>
     *
     * <code>.google.protobuf.Duration utc_offset = 8;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getUtcOffsetFieldBuilder() {
      if (utcOffsetBuilder_ == null) {
        if (!(timeOffsetCase_ == 8)) {
          timeOffset_ = com.google.protobuf.Duration.getDefaultInstance();
        }
        utcOffsetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                (com.couchbase.client.core.deps.com.google.protobuf.Duration) timeOffset_, getParentForChildren(), isClean());
        timeOffset_ = null;
      }
      timeOffsetCase_ = 8;
      onChanged();
      return utcOffsetBuilder_;
    }

    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.TimeZone,
            com.google.type.TimeZone.Builder,
            com.google.type.TimeZoneOrBuilder>
        timeZoneBuilder_;
    /**
     *
     *
     * <pre>
     * Time zone.
     * </pre>
     *
     * <code>.google.type.TimeZone time_zone = 9;</code>
     *
     * @return Whether the timeZone field is set.
     */
    @java.lang.Override
    public boolean hasTimeZone() {
      return timeOffsetCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Time zone.
     * </pre>
     *
     * <code>.google.type.TimeZone time_zone = 9;</code>
     *
     * @return The timeZone.
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.type.TimeZone getTimeZone() {
      if (timeZoneBuilder_ == null) {
        if (timeOffsetCase_ == 9) {
          return (com.couchbase.client.core.deps.com.google.type.TimeZone) timeOffset_;
        }
        return com.google.type.TimeZone.getDefaultInstance();
      } else {
        if (timeOffsetCase_ == 9) {
          return timeZoneBuilder_.getMessage();
        }
        return com.google.type.TimeZone.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Time zone.
     * </pre>
     *
     * <code>.google.type.TimeZone time_zone = 9;</code>
     */
    public Builder setTimeZone(com.couchbase.client.core.deps.com.google.type.TimeZone value) {
      if (timeZoneBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeOffset_ = value;
        onChanged();
      } else {
        timeZoneBuilder_.setMessage(value);
      }
      timeOffsetCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time zone.
     * </pre>
     *
     * <code>.google.type.TimeZone time_zone = 9;</code>
     */
    public Builder setTimeZone(com.couchbase.client.core.deps.com.google.type.TimeZone.Builder builderForValue) {
      if (timeZoneBuilder_ == null) {
        timeOffset_ = builderForValue.build();
        onChanged();
      } else {
        timeZoneBuilder_.setMessage(builderForValue.build());
      }
      timeOffsetCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time zone.
     * </pre>
     *
     * <code>.google.type.TimeZone time_zone = 9;</code>
     */
    public Builder mergeTimeZone(com.couchbase.client.core.deps.com.google.type.TimeZone value) {
      if (timeZoneBuilder_ == null) {
        if (timeOffsetCase_ == 9 && timeOffset_ != com.google.type.TimeZone.getDefaultInstance()) {
          timeOffset_ =
              com.google.type.TimeZone.newBuilder((com.couchbase.client.core.deps.com.google.type.TimeZone) timeOffset_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          timeOffset_ = value;
        }
        onChanged();
      } else {
        if (timeOffsetCase_ == 9) {
          timeZoneBuilder_.mergeFrom(value);
        } else {
          timeZoneBuilder_.setMessage(value);
        }
      }
      timeOffsetCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time zone.
     * </pre>
     *
     * <code>.google.type.TimeZone time_zone = 9;</code>
     */
    public Builder clearTimeZone() {
      if (timeZoneBuilder_ == null) {
        if (timeOffsetCase_ == 9) {
          timeOffsetCase_ = 0;
          timeOffset_ = null;
          onChanged();
        }
      } else {
        if (timeOffsetCase_ == 9) {
          timeOffsetCase_ = 0;
          timeOffset_ = null;
        }
        timeZoneBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time zone.
     * </pre>
     *
     * <code>.google.type.TimeZone time_zone = 9;</code>
     */
    public com.couchbase.client.core.deps.com.google.type.TimeZone.Builder getTimeZoneBuilder() {
      return getTimeZoneFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time zone.
     * </pre>
     *
     * <code>.google.type.TimeZone time_zone = 9;</code>
     */
    @java.lang.Override
    public com.couchbase.client.core.deps.com.google.type.TimeZoneOrBuilder getTimeZoneOrBuilder() {
      if ((timeOffsetCase_ == 9) && (timeZoneBuilder_ != null)) {
        return timeZoneBuilder_.getMessageOrBuilder();
      } else {
        if (timeOffsetCase_ == 9) {
          return (com.couchbase.client.core.deps.com.google.type.TimeZone) timeOffset_;
        }
        return com.google.type.TimeZone.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Time zone.
     * </pre>
     *
     * <code>.google.type.TimeZone time_zone = 9;</code>
     */
    private com.couchbase.client.core.deps.com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.TimeZone,
            com.google.type.TimeZone.Builder,
            com.google.type.TimeZoneOrBuilder>
        getTimeZoneFieldBuilder() {
      if (timeZoneBuilder_ == null) {
        if (!(timeOffsetCase_ == 9)) {
          timeOffset_ = com.google.type.TimeZone.getDefaultInstance();
        }
        timeZoneBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.TimeZone,
                com.google.type.TimeZone.Builder,
                com.google.type.TimeZoneOrBuilder>(
                (com.couchbase.client.core.deps.com.google.type.TimeZone) timeOffset_, getParentForChildren(), isClean());
        timeOffset_ = null;
      }
      timeOffsetCase_ = 9;
      onChanged();
      return timeZoneBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.couchbase.client.core.deps.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.couchbase.client.core.deps.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.type.DateTime)
  }

  // @@protoc_insertion_point(class_scope:google.type.DateTime)
  private static final com.couchbase.client.core.deps.com.google.type.DateTime DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.type.DateTime();
  }

  public static com.couchbase.client.core.deps.com.google.type.DateTime getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.couchbase.client.core.deps.com.google.protobuf.Parser<DateTime> PARSER =
      new com.google.protobuf.AbstractParser<DateTime>() {
        @java.lang.Override
        public DateTime parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.couchbase.client.core.deps.com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.couchbase.client.core.deps.com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.couchbase.client.core.deps.com.google.protobuf.Parser<DateTime> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.protobuf.Parser<DateTime> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.couchbase.client.core.deps.com.google.type.DateTime getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
