/*
 * Copyright 2022 Couchbase, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.couchbase.client.core.error.transaction;

import com.couchbase.client.core.error.CouchbaseException;

/**
 * The transaction is not allowed to rollback in the current state.
 *
 * Possible reasons include that it has already been rolled back.
 */
public class RollbackNotPermittedException extends CouchbaseException {
    public RollbackNotPermittedException() {
        super("Rollback is not allowed in the current transaction state");
    }
}
