/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.error.context.ReducedQueryErrorContext;
import com.couchbase.client.core.msg.query.CoreQueryAccessor;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.msg.query.QueryChunkTrailer;
import com.couchbase.client.core.msg.query.QueryRequest;
import com.couchbase.client.core.msg.query.QueryResponse;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import com.couchbase.client.java.query.ReactiveQueryResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class QueryAccessor {
    private final CoreQueryAccessor coreQueryAccessor;

    public QueryAccessor(Core core) {
        this.coreQueryAccessor = new CoreQueryAccessor(core);
    }

    public CompletableFuture<QueryResult> queryAsync(QueryRequest request, QueryOptions.Built options, JsonSerializer serializer) {
        return this.coreQueryAccessor.query(request, options.adhoc()).flatMap(response -> response.rows().collectList().flatMap(rows -> response.trailer().map(trailer -> new QueryResult(response.header(), (List<QueryChunkRow>)rows, (QueryChunkTrailer)trailer, serializer)))).toFuture();
    }

    public Mono<ReactiveQueryResult> queryReactive(QueryRequest request, QueryOptions.Built options, JsonSerializer serializer) {
        return this.coreQueryAccessor.query(request, options.adhoc()).map(r -> new ReactiveQueryResult((QueryResponse)r, serializer));
    }

    @Stability.Internal
    public static QueryRequest targetedQueryRequest(String statement, byte[] queryBytes, String clientContextId, @Nullable NodeIdentifier target, boolean readonly, RetryStrategy retryStrategy, Duration timeout, RequestSpan parentSpan, Core core) {
        Validators.notNullOrEmpty((String)statement, (String)"Statement", () -> new ReducedQueryErrorContext(statement));
        return new QueryRequest(timeout, core.context(), retryStrategy, core.context().authenticator(), statement, queryBytes, readonly, clientContextId, parentSpan, null, null, target);
    }
}

