/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.api.WebApi;
import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.DeobsMetadata;
import com.crashlytics.tools.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class DeobsUploader {
    private static final String REQUEST_DEOBS_FORMAT = "%s/api/v1/%s/deobs";
    private static final String DEOBS_STORAGE_DIR = "deobs_uploaded";
    private final WebApi _webApi;

    public DeobsUploader(WebApi api) {
        this._webApi = api;
    }

    public boolean uploadDeobfuscationFiles(AndroidProject project, String apiKey) throws IOException {
        List<File> deobsFiles = project.getDeobfuscationFiles();
        int sentFiles = 0;
        File deobsStoreDir = new File(project.getDataDirectory(), DEOBS_STORAGE_DIR);
        for (File deobsFile : project.getDeobfuscationFiles()) {
            boolean success = this.uploadDeobsFile(deobsFile, apiKey, deobsStoreDir);
            if (!success) continue;
            ++sentFiles;
        }
        return sentFiles == deobsFiles.size();
    }

    private boolean uploadDeobsFile(File deobsFile, String apiKey, File deobsStoreDir) throws IOException {
        String buildId = this.buildIdFromFilename(deobsFile);
        File deobsData = new File(deobsFile.getParent(), buildId + ".meta");
        DeobsMetadata meta = new DeobsMetadata();
        meta.load(deobsData);
        Map<String, String> params = meta.toMap();
        URL url = new URL(String.format(REQUEST_DEOBS_FORMAT, this._webApi.getBaseApiUrl(), apiKey));
        boolean success = this._webApi.sendFile(url, deobsFile, "application/zip", "resource[file]", params);
        if (success) {
            FileUtils.verifyDirectory(deobsStoreDir);
            if (!deobsData.renameTo(new File(deobsStoreDir, deobsData.getName()))) {
                deobsData.delete();
            }
            if (!deobsFile.renameTo(new File(deobsStoreDir, deobsFile.getName()))) {
                deobsFile.delete();
            }
        }
        return success;
    }

    private String buildIdFromFilename(File f) {
        String name = f.getName();
        int extensionIndex = name.lastIndexOf(".zip");
        return name.substring(0, extensionIndex);
    }
}

