/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils;

import com.crashlytics.api.AppRelease;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.utils.abx.AbxConstants;
import com.crashlytics.tools.utils.abx.AbxNode;
import com.crashlytics.tools.utils.abx.AbxParser;
import com.crashlytics.tools.utils.abx.AbxUtils;
import com.crashlytics.tools.utils.abx.StringResourcesMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.http.util.TextUtils;

public class ApkUtils {
    private static final int BUFFER_SIZE = 2048;
    private static final String TAG = "[ApkUtils] ";
    public static final boolean VERBOSE_LOGGING = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AppRelease extractAppDataFromApk(File apk) {
        StringResourcesMap strings;
        AbxNode manifest;
        String appName = null;
        String packageName = null;
        String instanceIdentifier = null;
        String buildVersion = null;
        String displayVersion = null;
        FileInputStream fin = null;
        ZipInputStream zin = null;
        ZipEntry ze = null;
        byte[] manifestBinaryXml = null;
        byte[] stringsBinaryXml = null;
        try {
            fin = new FileInputStream(apk);
            try {
                zin = new ZipInputStream(fin);
                try {
                    while ((ze = zin.getNextEntry()) != null) {
                        int count;
                        AbxConstants.FileType<?> type = ApkUtils.getFileType(ze);
                        if (type == null) continue;
                        byte[] buffer = new byte[2048];
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        while ((count = zin.read(buffer)) != -1) {
                            baos.write(buffer, 0, count);
                        }
                        baos.flush();
                        baos.close();
                        byte[] binaryXml = baos.toByteArray();
                        if (type == AbxConstants.FileType.MANIFEST) {
                            manifestBinaryXml = binaryXml;
                            continue;
                        }
                        if (type != AbxConstants.FileType.STRINGS) continue;
                        stringsBinaryXml = binaryXml;
                    }
                }
                finally {
                    zin.close();
                }
            }
            finally {
                fin.close();
            }
        }
        catch (IOException e) {
            DeveloperTools.logW("[ApkUtils] Error opening APK file.", e);
            return null;
        }
        if (manifestBinaryXml == null) {
            DeveloperTools.logW("[ApkUtils] Could not find AndroidManifest.xml in APK.", null);
            return null;
        }
        if (stringsBinaryXml == null) {
            DeveloperTools.logW("[ApkUtils] Could not find resources file in APK.", null);
            return null;
        }
        try {
            manifest = AbxParser.createAndParse(AbxConstants.FileType.MANIFEST, manifestBinaryXml);
        }
        catch (IOException e) {
            DeveloperTools.logW("[ApkUtils] Could not parse AndroidManifest.xml file.", e);
            return null;
        }
        try {
            strings = AbxParser.createAndParse(AbxConstants.FileType.STRINGS, stringsBinaryXml);
            ApkUtils.log("Extracted these strings: " + strings);
        }
        catch (IOException e) {
            DeveloperTools.logW("[ApkUtils] Could not parse resources file.", e);
            return null;
        }
        if (manifest == null) {
            DeveloperTools.logW("[ApkUtils] AndroidManifest.xml is blank.", null);
            return null;
        }
        packageName = manifest.getAttribute("package");
        if (TextUtils.isEmpty(packageName)) {
            DeveloperTools.logW("[ApkUtils] Could not extract package name from APK.", null);
            return null;
        }
        buildVersion = manifest.getAttribute("versionCode");
        if (TextUtils.isEmpty(buildVersion)) {
            DeveloperTools.logW("[ApkUtils] Could not extract build version from APK.", null);
            return null;
        }
        displayVersion = manifest.getAttribute("versionName");
        if (TextUtils.isEmpty(displayVersion)) {
            DeveloperTools.logW("[ApkUtils] Could not extract display version from APK.", null);
            return null;
        }
        AbxNode application = null;
        for (AbxNode node : manifest.getChildren()) {
            if (!"application".equals(node.getName())) continue;
            application = node;
        }
        if (application == null) {
            DeveloperTools.logW("[ApkUtils] Could not find <application> tag in APK manifest file.", null);
            return null;
        }
        String appNameOrId = application.getAttribute("label");
        if (TextUtils.isEmpty(appNameOrId)) {
            DeveloperTools.logW("[ApkUtils] Could not extract application name from APK manifest file.", null);
            return null;
        }
        try {
            int appId = Integer.valueOf(appNameOrId);
            if (!AbxUtils.verifyPackageIdFromResIdIsDefault(appId)) {
                DeveloperTools.logW("[ApkUtils] Extracting app name from other than the application's own package is currently not supported.", null);
                return null;
            }
            int entryIndex = AbxUtils.entryIndexFromResId(appId);
            appNameOrId = strings.findStringValueByResId(appId);
            ApkUtils.log("appNameOrId: " + appId + "; " + appNameOrId + "; " + entryIndex);
            if (TextUtils.isEmpty(appNameOrId)) {
                DeveloperTools.logW("[ApkUtils] Could not find application name in resources file.", null);
                return null;
            }
            appName = appNameOrId;
        }
        catch (NumberFormatException nfe) {
            ApkUtils.log("[ApkUtils] Encountered hard-coded app name in AndroidManifest.xml: " + appNameOrId);
        }
        instanceIdentifier = strings.getStringValue("com.crashlytics.android.build_id");
        if (TextUtils.isEmpty(instanceIdentifier)) {
            DeveloperTools.logW("[ApkUtils] Could not find Crashlytics Build ID in resources file.", null);
            return null;
        }
        return new AppRelease(appName, packageName, instanceIdentifier, displayVersion, buildVersion);
    }

    private static AbxConstants.FileType<?> getFileType(ZipEntry ze) {
        if (!ze.isDirectory()) {
            String name = ze.getName();
            if (name.equals("AndroidManifest.xml")) {
                return AbxConstants.FileType.MANIFEST;
            }
            if (name.endsWith(".arsc")) {
                return AbxConstants.FileType.STRINGS;
            }
        }
        return null;
    }

    public static void log(String s) {
    }

    public static void logW(String s, Throwable t) {
        DeveloperTools.logW(s, t);
    }
}

