/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api;

import com.crashlytics.api.App;
import com.crashlytics.api.AppRelease;
import com.crashlytics.api.AuthenticationException;
import com.crashlytics.api.DistributionData;
import com.crashlytics.api.Issue;
import com.crashlytics.api.Organization;
import com.crashlytics.api.ReleaseNotes;
import com.crashlytics.api.Software;
import com.crashlytics.api.User;
import com.crashlytics.api.WebApi;
import com.crashlytics.api.ota.AppVersion;
import com.crashlytics.api.ota.AppVersionJsonTransform;
import com.crashlytics.api.ota.Release;
import com.crashlytics.api.ota.ReleaseJsonTransform;
import com.crashlytics.api.ota.ReleaseSummariesJsonTransform;
import com.crashlytics.api.ota.ReleaseSummary;
import com.crashlytics.api.ota.Tester;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class RestfulWebApi
implements WebApi {
    private static final String FATAL_TYPE = "fatal";
    private static final String NONFATAL_TYPE = "nonfatal";
    private static final String HTTP_PROXY_PORT_PROP = "http.proxyPort";
    private static final String HTTP_PROXY_HOST_PROP = "http.proxyHost";
    private static final String HTTP_PROXY_USER_PROP = "http.proxyUser";
    private static final String HTTP_PROXY_PASSWORD_PROP = "http.proxyPassword";
    private static final String HTTPS_PROXY_PORT_PROP = "https.proxyPort";
    private static final String HTTPS_PROXY_HOST_PROP = "https.proxyHost";
    private static final String HTTPS_PROXY_USER_PROP = "https.proxyUser";
    private static final String HTTPS_PROXY_PASSWORD_PROP = "https.proxyPassword";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final String DEV_TOKEN_HEADER = "X-CRASHLYTICS-DEVELOPER-TOKEN";
    private static final String ACCESS_TOKEN_HEADER = "X-CRASHLYTICS-ACCESS-TOKEN";
    private static final String REQUEST_ID_HEADER = "X-Request-Id";
    private static final String API_KEY_HEADER = "X-CRASHLYTICS-API-KEY";
    private static final String API_CLIENT_ID = "X-CRASHLYTICS-API-CLIENT-ID";
    private static final String API_CLIENT_BUILD_VERSION = "X-CRASHLYTICS-API-CLIENT-BUILD-VERSION";
    private static final String API_CLIENT_DISPLAY_VERSION = "X-CRASHLYTICS-API-CLIENT-DISPLAY-VERSION";
    private static final String BUILD_SECRET_HEADER = "X-CRASHLYTICS-BUILD-SECRET";
    private static final String API_CLIENT_TYPE_HEADER = "X-CRASHLYTICS-API-CLIENT-TYPE";
    private static final String API_CLIENT_VERSION_HEADER = "X-CRASHLYTICS-API-CLIENT-VERSION";
    private static final String DEV_TOKEN = "ed8fc3dc68a7475cc970eb1e9c0cb6603b0a3ea2";
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String USER_TAG = "User";
    private static final String ORGS_TAG = "Orgs";
    private static final String JSON_FILE_EXTENSION = ".json";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String DISTRIBUTION_ANDROID_APP_TYPE = "android_app";
    private static final String DISTRIBUTION_SLICE_JAVA_ARCH = "java";
    private User _user = null;
    private List<App> _appsCache = null;
    private List<Organization> _orgsCache = null;
    private Map<App, List<Issue>> _issuesCache;
    private Map<App, List<Tester>> _testersCache;
    private String _userAgent;
    private String _clientVersion;
    private String _clientType;
    private String _toolId;
    private String _toolVersion;
    private String _toolDetail;
    private String _baseApiUrl;

    public RestfulWebApi() {
        this("https://api.crashlytics.com");
    }

    public RestfulWebApi(String baseApiUrl) {
        this._baseApiUrl = baseApiUrl;
        this._issuesCache = new HashMap<App, List<Issue>>();
        this._testersCache = new HashMap<App, List<Tester>>();
        this.loadUserFromCache();
    }

    @Override
    public final synchronized void logout() {
        this.setUser(null);
        this.deleteFileInCache(USER_TAG);
        this.deleteFileInCache(ORGS_TAG);
        this._appsCache = null;
        this._orgsCache = null;
    }

    @Override
    public synchronized void setUserAgent(String userAgent) {
        this._userAgent = userAgent;
    }

    @Override
    public synchronized void setClientType(String clientType) {
        this._clientType = clientType;
    }

    @Override
    public synchronized void setClientVersion(String clientVersion) {
        this._clientVersion = clientVersion;
    }

    @Override
    public final synchronized User authenticateUser(String email, String password) throws IOException {
        JSONObject response;
        this.logout();
        JSONObject request = new JSONObject();
        request.put("email", email);
        request.put("password", password);
        String urlStr = this.getBaseApiUrl() + "/api/v2/session";
        try {
            response = (JSONObject)this.postJSON(urlStr, request);
        }
        catch (AuthenticationException e) {
            response = null;
        }
        if (response != null) {
            this.setUser(new User(response));
            this.writeJSONToFile(USER_TAG, response);
            JSONArray jsonOrgs = (JSONArray)response.get("organizations");
            if (jsonOrgs != null) {
                this.writeJSONToFile(ORGS_TAG, jsonOrgs);
                this._orgsCache = new LinkedList<Organization>();
                for (int i = 0; i < jsonOrgs.size(); ++i) {
                    this._orgsCache.add(new Organization((JSONObject)jsonOrgs.get(i)));
                }
            }
        }
        return this._user;
    }

    @Override
    public void asyncAuthenticate(final String email, final String password, final WebApi.ApiCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                User user = null;
                try {
                    user = RestfulWebApi.this.authenticateUser(email, password);
                }
                catch (Exception e) {
                    if (callback != null) {
                        callback.onAuthenticateException(RestfulWebApi.this, e);
                    }
                    return;
                }
                if (callback != null) {
                    callback.onAuthenticated(RestfulWebApi.this, user);
                }
            }
        }, "Crashlytics User Authenticator").start();
    }

    @Override
    public final synchronized User authenticateWithToken(String token) throws IOException {
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put(ACCESS_TOKEN_HEADER, token);
        String uriStr = this.getBaseApiUrl() + "/api/v2/session";
        URI uri = null;
        try {
            uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            DeveloperTools.logE("bad URI: " + uri, e);
            return null;
        }
        try {
            JSONObject response = (JSONObject)this.getJSON(uri, headerParams);
            if (response != null) {
                this.setUser(new User(response));
            }
        }
        catch (AuthenticationException e) {
            DeveloperTools.logE("Unable to authenticate user.", e);
            return null;
        }
        return this._user;
    }

    @Override
    public void asyncAuthenticateWithToken(final String token, final WebApi.ApiCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                User user = null;
                try {
                    user = RestfulWebApi.this.authenticateWithToken(token);
                }
                catch (Exception e) {
                    if (callback != null) {
                        callback.onAuthenticateException(RestfulWebApi.this, e);
                    }
                    return;
                }
                if (callback != null) {
                    callback.onAuthenticated(RestfulWebApi.this, user);
                }
            }
        }, "Crashlytics Tokenized Authenticator").start();
    }

    @Override
    public synchronized List<Organization> getOrgs(boolean clearCache) throws IOException, AuthenticationException {
        if (!clearCache && this._orgsCache != null) {
            return Collections.unmodifiableList(this._orgsCache);
        }
        this._orgsCache = new LinkedList<Organization>();
        String uriStr = this.getBaseApiUrl() + "/api/v2/organizations";
        URI uri = null;
        try {
            uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            DeveloperTools.logE("bad URI: " + uri, e);
            return null;
        }
        JSONArray response = (JSONArray)this.getJSON(uri, Collections.<String, String>emptyMap());
        if (response != null) {
            for (int i = 0; i < response.size(); ++i) {
                this._orgsCache.add(new Organization((JSONObject)response.get(i)));
            }
            this.writeJSONToFile(ORGS_TAG, response);
        }
        return Collections.unmodifiableList(this._orgsCache);
    }

    @Override
    public void fetchApps(final WebApi.ApiCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                List<App> apps = null;
                try {
                    apps = RestfulWebApi.this.getApps(true);
                }
                catch (Exception e) {
                    if (callback != null) {
                        callback.onAppException(RestfulWebApi.this, e);
                    }
                    return;
                }
                if (callback != null) {
                    callback.onRetrievedApps(RestfulWebApi.this, apps);
                }
            }
        }, "Crashlytics App Fetcher").start();
    }

    @Override
    public List<App> getApps(Organization org, boolean clearCache) throws IOException, AuthenticationException {
        List<App> allApps = this.getApps(clearCache);
        LinkedList<App> orgApps = new LinkedList<App>();
        for (App app : allApps) {
            if (!app.getOrganization().equals(org)) continue;
            orgApps.add(app);
        }
        return orgApps;
    }

    @Override
    public synchronized List<App> getApps(boolean clearCache) throws IOException, AuthenticationException {
        if (!clearCache && this._appsCache != null) {
            return Collections.unmodifiableList(this._appsCache);
        }
        this._appsCache = new LinkedList<App>();
        List<Organization> orgs = this.getOrgs(true);
        for (Organization org : orgs) {
            String uriStr = this.getBaseApiUrl() + "/api/v2/organizations/" + org.getId() + "/platforms/android/apps";
            URI uri = null;
            try {
                uri = new URI(uriStr);
            }
            catch (URISyntaxException e) {
                DeveloperTools.logE("bad URI: " + uri, e);
                return null;
            }
            JSONArray response = (JSONArray)this.getJSON(uri, Collections.<String, String>emptyMap());
            if (response == null) continue;
            for (int i = 0; i < response.size(); ++i) {
                App app = new App((JSONObject)response.get(i), org);
                if (!app.getPlatform().equalsIgnoreCase("android")) continue;
                this._appsCache.add(app);
            }
        }
        return Collections.unmodifiableList(this._appsCache);
    }

    @Override
    public synchronized List<Issue> getIssues(App app, boolean clearCache) throws IOException, AuthenticationException {
        LinkedList<Issue> allIssues = new LinkedList<Issue>();
        allIssues.addAll(this.getIssues(app, clearCache, FATAL_TYPE));
        allIssues.addAll(this.getIssues(app, clearCache, NONFATAL_TYPE));
        return allIssues;
    }

    private synchronized List<Issue> getIssues(App app, boolean clearCache, String issueType) throws IOException, AuthenticationException {
        if (clearCache) {
            this._issuesCache = new HashMap<App, List<Issue>>();
        }
        if (!this._issuesCache.containsKey(app)) {
            String uriStr = this.getBaseApiUrl() + "/api/v2/organizations/" + app.getOrganization().getId() + "/apps/" + app.getId() + "/issues?event_type_equals=" + issueType;
            URI uri = null;
            try {
                uri = new URI(uriStr);
            }
            catch (URISyntaxException e) {
                DeveloperTools.logE("bad URI: " + uri, e);
                return null;
            }
            JSONArray response = (JSONArray)this.getJSON(uri, Collections.<String, String>emptyMap());
            DeveloperTools.logD("Issue RESPONSE:" + response.toJSONString());
            LinkedList<Issue> issues = new LinkedList<Issue>();
            if (response != null) {
                for (int i = 0; i < response.size(); ++i) {
                    try {
                        issues.add(new Issue((JSONObject)response.get(i), app));
                        continue;
                    }
                    catch (Exception e) {
                        DeveloperTools.logE("Couldn't parse issue", e);
                    }
                }
            }
            DeveloperTools.logD("Issues:" + issues.size());
            this._issuesCache.put(app, issues);
        }
        return this._issuesCache.containsKey(app) ? Collections.unmodifiableList(this._issuesCache.get(app)) : Collections.emptyList();
    }

    @Override
    public boolean sendFile(URL url, File file, String mimeType, String fileParamName, Map<String, String> bodyParams) throws IOException {
        DeveloperTools.logD("POST file: " + file + " to URL: " + url);
        HttpPost httpPost = null;
        try {
            httpPost = new HttpPost(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        ContentType mimeContentType = ContentType.create(mimeType);
        this.applyCommonHeadersTo(httpPost);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        for (Map.Entry<String, String> param : bodyParams.entrySet()) {
            builder.addPart(param.getKey(), new StringBody(param.getValue(), mimeContentType));
        }
        builder.addPart(fileParamName, new FileBody(file, mimeContentType));
        httpPost.setEntity(builder.build());
        ProxySettings settings = ProxySettings.create(ProtocolScheme.getType(url));
        HttpClient client = this.getClient(settings);
        httpPost.setConfig(settings.getConfig());
        HttpResponse response = client.execute(httpPost);
        int result = response.getStatusLine().getStatusCode();
        DeveloperTools.logD("POST response: [reqId=" + RestfulWebApi.getRequestId(response) + "] " + result);
        return this.isSuccess(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean downloadFile(URL url, File destination) throws IOException {
        HttpGet get;
        try {
            get = new HttpGet(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.applyCommonHeadersTo(get);
        get.addHeader(ACCEPT_HEADER, APPLICATION_OCTET_STREAM);
        ProxySettings settings = ProxySettings.create(ProtocolScheme.getType(url));
        HttpClient client = this.getClient(settings);
        get.setConfig(settings.getConfig());
        this.logRequest(get);
        HttpResponse response = client.execute(get);
        int statusCode = response.getStatusLine().getStatusCode();
        this.logResponse(response, statusCode);
        if (statusCode == 200) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(destination);
                response.getEntity().writeTo(out);
                out.flush();
                boolean bl = true;
                return bl;
            }
            finally {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
        }
        return false;
    }

    private void applyCommonHeadersTo(HttpRequestBase request) {
        request.addHeader(DEV_TOKEN_HEADER, DEV_TOKEN);
        if (this._userAgent != null) {
            request.setHeader(USER_AGENT_HEADER, this._userAgent);
        }
        if (this._clientType != null) {
            request.setHeader(API_CLIENT_TYPE_HEADER, this._clientType);
        }
        if (this._clientVersion != null) {
            request.setHeader(API_CLIENT_VERSION_HEADER, this._clientVersion);
        }
        if (this._user != null) {
            request.addHeader(ACCESS_TOKEN_HEADER, this._user.getToken());
        }
    }

    private Object postJSON(String url, JSONObject requestJSON) throws IOException, AuthenticationException {
        return this.postJSON(url, requestJSON, Collections.<String, String>emptyMap());
    }

    private Object postJSON(String url, JSONObject requestJSON, Map<String, String> headers) throws IOException, AuthenticationException {
        HttpPost post = new HttpPost(url);
        if (requestJSON != null) {
            ByteArrayEntity entity = new ByteArrayEntity(requestJSON.toString().getBytes());
            entity.setContentType(APPLICATION_JSON);
            post.setEntity(entity);
        }
        return this.requestJSON(post, requestJSON, headers);
    }

    private Object getJSON(URI uri, Map<String, String> headerParams) throws IOException, AuthenticationException {
        HttpGet get = new HttpGet(uri);
        return this.requestJSON(get, null, headerParams);
    }

    private Object requestJSON(HttpRequestBase request, JSONObject requestJSON, Map<String, String> headerParams) throws IOException, AuthenticationException {
        this.applyCommonHeadersTo(request);
        request.setHeader(ACCEPT_HEADER, APPLICATION_JSON);
        for (Map.Entry<String, String> header : headerParams.entrySet()) {
            request.addHeader(header.getKey(), header.getValue().trim());
        }
        ProxySettings settings = ProxySettings.create(ProtocolScheme.getType(request));
        HttpClient client = this.getClient(settings);
        request.setConfig(settings.getConfig());
        this.logRequest(request);
        HttpResponse response = client.execute(request);
        int result = response.getStatusLine().getStatusCode();
        Object responseJSON = null;
        if (this.isSuccess(result)) {
            responseJSON = JSONValue.parse(new InputStreamReader(response.getEntity().getContent(), Charset.forName("UTF8")));
        } else if (result == 401 || result == 403) {
            throw new AuthenticationException("Crashlytics Authentication failed [reqId=" + RestfulWebApi.getRequestId(response) + "] " + result);
        }
        this.logResponse(response, result, responseJSON);
        return responseJSON;
    }

    private void logRequest(HttpRequestBase request) {
        DeveloperTools.logD("REQUEST: " + request.getURI());
    }

    private void logResponse(HttpResponse response, int statusCodeResult, Object responseJSON) {
        DeveloperTools.logD("RESPONSE: " + statusCodeResult + " [reqId=" + RestfulWebApi.getRequestId(response) + "]; " + responseJSON);
    }

    private void logResponse(HttpResponse response, int statusCodeResult) {
        try {
            DeveloperTools.logD("RESPONSE: " + statusCodeResult + " [reqId=" + RestfulWebApi.getRequestId(response) + "]");
        }
        catch (Exception e) {
            DeveloperTools.logE("Crashlytics experienced an error while logging a response.", e);
        }
    }

    @Override
    public Software getSoftwareIntegration(Organization org, String platform, String bundleId, String version) throws IOException {
        return this.getSoftwareIntegration(org.getApiKey(), platform, bundleId, version);
    }

    @Override
    public Software getSoftwareIntegration(String apiKey, String platform, String bundleId, String version) throws IOException {
        URI uri;
        try {
            uri = new URI(this._baseApiUrl + "/api/v2/keys/" + apiKey + "/platforms/" + platform + "/integrations/" + bundleId + "?current_version=" + version);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        JSONObject result = null;
        try {
            result = (JSONObject)this.getJSON(uri, Collections.<String, String>emptyMap());
        }
        catch (AuthenticationException e) {
            DeveloperTools.logW("Unexpected failed authentication", e);
        }
        return result == null ? null : Software.createFromJSON(result);
    }

    @Override
    public Software getAndroidSDK(Organization org, String currentVersion) throws IOException {
        return this.getAndroidSDK(org.getApiKey(), currentVersion);
    }

    @Override
    public Software getAndroidSDK(String apiKey, String currentVersion) throws IOException {
        URI uri;
        try {
            uri = new URI(this._baseApiUrl + "/api/v2/keys/" + apiKey + "/platforms/" + "android" + "/sdks/com.crashlytics.android?current_version=" + currentVersion);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        JSONObject result = null;
        try {
            result = (JSONObject)this.getJSON(uri, Collections.<String, String>emptyMap());
        }
        catch (AuthenticationException e) {
            DeveloperTools.logW("Unexpected failed authentication", e);
        }
        return result == null ? null : Software.createFromJSON(result);
    }

    @Override
    public String getBaseApiUrl() {
        return this._baseApiUrl;
    }

    @Override
    public User getCurrentUser() {
        return this._user;
    }

    private void setUser(User newUser) {
        this._user = newUser;
    }

    private void writeJSONToFile(String tag, JSONObject json) {
        this.writeJSONToFile(tag, json.toJSONString().getBytes(UTF_8));
    }

    private void writeJSONToFile(String tag, JSONArray json) {
        this.writeJSONToFile(tag, json.toJSONString().getBytes(UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJSONToFile(String tag, byte[] bytes) {
        File file = new File(DeveloperTools.CRASHLYTICS_DATA_ROOT.getPath(), tag + JSON_FILE_EXTENSION);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(bytes);
            fos.flush();
        }
        catch (IOException e) {
            DeveloperTools.logE("Could not write " + file, e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    DeveloperTools.logE("Could not close " + file, e);
                }
            }
        }
    }

    private void loadUserFromCache() {
        User newUser;
        JSONObject userObject = (JSONObject)this.loadFromCache(USER_TAG);
        if (userObject != null && (newUser = new User(userObject)) != null) {
            JSONArray orgsArray = (JSONArray)this.loadFromCache(ORGS_TAG);
            if (orgsArray != null) {
                if (this._orgsCache == null) {
                    this._orgsCache = new LinkedList<Organization>();
                }
                for (int i = 0; i < orgsArray.size(); ++i) {
                    this._orgsCache.add(new Organization((JSONObject)orgsArray.get(i)));
                }
            }
            this.setUser(newUser);
        }
    }

    private Object loadFromCache(String tag) {
        File file = new File(DeveloperTools.CRASHLYTICS_DATA_ROOT.getPath(), tag + JSON_FILE_EXTENSION);
        if (file.exists()) {
            try {
                String jsonString = FileUtils.fileToString(file);
                return JSONValue.parse(jsonString);
            }
            catch (IOException e) {
                DeveloperTools.logE("Could not read cache file " + file, e);
            }
        }
        return null;
    }

    private void deleteFileInCache(String tag) {
        new File(DeveloperTools.CRASHLYTICS_DATA_ROOT.getPath(), tag + JSON_FILE_EXTENSION).delete();
    }

    private static String getRequestId(HttpResponse response) {
        Header requestIdHeader = response.getFirstHeader(REQUEST_ID_HEADER);
        return requestIdHeader == null ? "null" : requestIdHeader.getValue();
    }

    public HttpClient getClient(ProxySettings settings) throws IOException {
        return settings.getClient();
    }

    @Override
    public boolean createDistribution(String apiKey, String buildSecret, AppRelease appRelease, DistributionData distributionData) throws AuthenticationException, IOException {
        HttpEntity multipartEntity = MultipartEntityBuilder.create().addPart("distribution[file]", new FileBody(distributionData.distributionFile, ContentType.DEFAULT_BINARY, distributionData.distributionFile.getName())).addPart("distribution[built_at]", new StringBody(Long.toString(distributionData.builtAtSeconds), ContentType.DEFAULT_TEXT)).addPart("app[instance_identifier]", new StringBody(appRelease.instanceIdentifier, ContentType.DEFAULT_TEXT)).addPart("app[display_version]", new StringBody(appRelease.displayVersion, ContentType.DEFAULT_TEXT)).addPart("app[build_version]", new StringBody(appRelease.buildVersion, ContentType.DEFAULT_TEXT)).addPart("app[type]", new StringBody(DISTRIBUTION_ANDROID_APP_TYPE, ContentType.DEFAULT_TEXT)).addPart("app[slices][][arch]", new StringBody(DISTRIBUTION_SLICE_JAVA_ARCH, ContentType.DEFAULT_TEXT)).addPart("app[slices][][uuid]", new StringBody(appRelease.instanceIdentifier, ContentType.DEFAULT_TEXT)).build();
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appRelease.packageName + "/distributions";
        HttpPost post = new HttpPost(url);
        post.setHeader(ACCEPT_HEADER, APPLICATION_JSON);
        post.setHeader(API_KEY_HEADER, apiKey);
        post.setHeader(BUILD_SECRET_HEADER, buildSecret);
        post.setEntity(multipartEntity);
        ProxySettings proxySettings = ProxySettings.create(ProtocolScheme.getType(post));
        post.setConfig(proxySettings.getConfig());
        this.applyCommonHeadersTo(post);
        this.logRequest(post);
        HttpClient client = proxySettings.getClient();
        HttpResponse response = client.execute(post);
        int result = response.getStatusLine().getStatusCode();
        this.logResponse(response, result);
        return this.isSuccess(result);
    }

    @Override
    public JSONObject inviteTester(String apiKey, String appPackageName, String email, String name) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("email", email));
        nameValuePairs.add(new BasicNameValuePair("name", name));
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/invitations";
        HttpPost post = new HttpPost(url);
        post.setHeader(ACCEPT_HEADER, APPLICATION_JSON);
        post.setHeader(API_KEY_HEADER, apiKey);
        post.setEntity(new UrlEncodedFormEntity(nameValuePairs, UTF_8));
        ProxySettings proxySettings = ProxySettings.create(ProtocolScheme.getType(post));
        post.setConfig(proxySettings.getConfig());
        this.applyCommonHeadersTo(post);
        this.logRequest(post);
        HttpClient client = proxySettings.getClient();
        HttpResponse response = client.execute(post);
        int statusCode = response.getStatusLine().getStatusCode();
        if (this.isSuccess(statusCode)) {
            JSONObject jsonObject = (JSONObject)JSONValue.parse(new InputStreamReader(response.getEntity().getContent(), UTF_8));
            this.logResponse(response, statusCode, jsonObject);
            return jsonObject;
        }
        this.logResponse(response, statusCode);
        return null;
    }

    @Override
    public List<Tester> getTesters(String apiKey, App app) throws IOException {
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + app.getBundleIdForDisplay() + "/testers";
        HttpGet get = new HttpGet(url);
        get.setHeader(ACCEPT_HEADER, APPLICATION_JSON);
        get.setHeader(API_KEY_HEADER, apiKey);
        ProxySettings proxySettings = ProxySettings.create(ProtocolScheme.getType(get));
        get.setConfig(proxySettings.getConfig());
        this.applyCommonHeadersTo(get);
        this.logRequest(get);
        HttpClient client = proxySettings.getClient();
        HttpResponse response = client.execute(get);
        int statusCode = response.getStatusLine().getStatusCode();
        ArrayList<Tester> testers = new ArrayList<Tester>();
        if (this.isSuccess(statusCode)) {
            JSONObject jsonObject = (JSONObject)JSONValue.parse(new InputStreamReader(response.getEntity().getContent(), UTF_8));
            this.logResponse(response, statusCode, jsonObject);
            JSONArray jsonArray = (JSONArray)jsonObject.get("testers");
            if (response != null) {
                for (int i = 0; i < jsonArray.size(); ++i) {
                    testers.add(new Tester((JSONObject)jsonArray.get(i)));
                }
            }
            this._testersCache.put(app, testers);
        } else {
            this.logResponse(response, statusCode);
        }
        return Collections.unmodifiableList(testers);
    }

    @Override
    public boolean updateRelease(String apiKey, String appPackageName, String instanceId, String displayVersion, String buildVersion, ArrayList<String> testerIds, ArrayList<String> invitationIds) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("app[display_version]", displayVersion));
        nameValuePairs.add(new BasicNameValuePair("app[build_version]", buildVersion));
        for (String tester : testerIds) {
            nameValuePairs.add(new BasicNameValuePair("tester_ids[]", tester));
        }
        for (String invitation : invitationIds) {
            nameValuePairs.add(new BasicNameValuePair("invitation_ids[]", invitation));
        }
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases/" + instanceId + "/testers";
        HttpPut put = new HttpPut(url);
        put.setHeader(ACCEPT_HEADER, APPLICATION_JSON);
        put.setHeader(API_KEY_HEADER, apiKey);
        put.setEntity(new UrlEncodedFormEntity(nameValuePairs, UTF_8));
        ProxySettings proxySettings = ProxySettings.create(ProtocolScheme.getType(put));
        put.setConfig(proxySettings.getConfig());
        this.applyCommonHeadersTo(put);
        this.logRequest(put);
        HttpClient client = proxySettings.getClient();
        HttpResponse response = client.execute(put);
        int result = response.getStatusLine().getStatusCode();
        this.logResponse(response, result);
        return this.isSuccess(result);
    }

    @Override
    public List<AppVersion> getAppVersions(String apiKey, String appPackageName) throws AuthenticationException, IOException {
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/versions";
        HttpGet get = new HttpGet(url);
        get.setHeader(ACCEPT_HEADER, APPLICATION_JSON);
        get.setHeader(API_KEY_HEADER, apiKey);
        this.applyCommonHeadersTo(get);
        ProxySettings proxySettings = ProxySettings.create(ProtocolScheme.getType(get));
        get.setConfig(proxySettings.getConfig());
        this.logRequest(get);
        HttpClient client = proxySettings.getClient();
        HttpResponse response = client.execute(get);
        int result = response.getStatusLine().getStatusCode();
        this.logResponse(response, result);
        JSONArray jsonAppVersions = (JSONArray)JSONValue.parse(new InputStreamReader(response.getEntity().getContent(), UTF_8));
        ArrayList<AppVersion> appVersions = new ArrayList<AppVersion>(jsonAppVersions.size());
        AppVersionJsonTransform appVersionTransform = new AppVersionJsonTransform();
        if (jsonAppVersions != null) {
            for (Object jsonAppVersion : jsonAppVersions) {
                appVersions.add(appVersionTransform.transform((JSONObject)jsonAppVersion));
            }
        }
        return appVersions;
    }

    @Override
    public ReleaseNotes getReleaseNotes(String apiKey, String appPackageName, String instanceId, String displayVersion, String buildVersion) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("app[display_version]", displayVersion));
        nameValuePairs.add(new BasicNameValuePair("app[build_version]", buildVersion));
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases/" + instanceId + "/notes?" + URLEncodedUtils.format(nameValuePairs, UTF_8);
        HttpGet get = new HttpGet(url);
        get.setHeader(ACCEPT_HEADER, APPLICATION_JSON);
        get.setHeader(API_KEY_HEADER, apiKey);
        ProxySettings proxySettings = ProxySettings.create(ProtocolScheme.getType(get));
        get.setConfig(proxySettings.getConfig());
        this.applyCommonHeadersTo(get);
        this.logRequest(get);
        HttpClient client = proxySettings.getClient();
        HttpResponse response = client.execute(get);
        int result = response.getStatusLine().getStatusCode();
        this.logResponse(response, result);
        JSONObject releaseNotesRaw = (JSONObject)JSONValue.parse(new InputStreamReader(response.getEntity().getContent(), UTF_8));
        ReleaseNotes releaseNotes = new ReleaseNotes(releaseNotesRaw);
        return releaseNotes;
    }

    @Override
    public boolean setReleaseNotes(String apiKey, String appPackageName, String instanceId, String displayVersion, String buildVersion, ReleaseNotes releaseNotes) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("app[display_version]", displayVersion));
        nameValuePairs.add(new BasicNameValuePair("app[build_version]", buildVersion));
        nameValuePairs.add(new BasicNameValuePair("release_notes[format]", releaseNotes.getFormat().name().toLowerCase()));
        nameValuePairs.add(new BasicNameValuePair("release_notes[body]", releaseNotes.getBody()));
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases/" + instanceId + "/notes";
        HttpPut put = new HttpPut(url);
        put.setHeader(ACCEPT_HEADER, APPLICATION_JSON);
        put.setHeader(API_KEY_HEADER, apiKey);
        put.setEntity(new UrlEncodedFormEntity(nameValuePairs, UTF_8));
        ProxySettings proxySettings = ProxySettings.create(ProtocolScheme.getType(put));
        put.setConfig(proxySettings.getConfig());
        this.applyCommonHeadersTo(put);
        this.logRequest(put);
        HttpClient client = proxySettings.getClient();
        HttpResponse response = client.execute(put);
        int result = response.getStatusLine().getStatusCode();
        this.logResponse(response, result);
        return this.isSuccess(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Release getRelease(String apiKey, String appPackageName, String instanceId, String displayVersion, String buildVersion) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("app[display_version]", displayVersion));
        nameValuePairs.add(new BasicNameValuePair("app[build_version]", buildVersion));
        nameValuePairs.add(new BasicNameValuePair("include_disabled", "true"));
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases/" + instanceId + "/summary?" + URLEncodedUtils.format(nameValuePairs, UTF_8);
        HttpGet get = new HttpGet(url);
        get.setHeader(ACCEPT_HEADER, APPLICATION_JSON);
        get.setHeader(API_KEY_HEADER, apiKey);
        ProxySettings proxySettings = ProxySettings.create(ProtocolScheme.getType(get));
        get.setConfig(proxySettings.getConfig());
        this.applyCommonHeadersTo(get);
        this.logRequest(get);
        HttpClient client = proxySettings.getClient();
        HttpResponse response = client.execute(get);
        int result = response.getStatusLine().getStatusCode();
        this.logResponse(response, result);
        if (this.isSuccess(result)) {
            InputStreamReader entityContentReader;
            block4: {
                Release release;
                entityContentReader = null;
                try {
                    entityContentReader = new InputStreamReader(response.getEntity().getContent(), UTF_8);
                    JSONObject releaseSummaryJson = (JSONObject)JSONValue.parse(entityContentReader);
                    if (releaseSummaryJson == null) break block4;
                    release = new ReleaseJsonTransform().createReleaseFrom(releaseSummaryJson);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(entityContentReader);
                    throw throwable;
                }
                IOUtils.closeQuietly(entityContentReader);
                return release;
            }
            DeveloperTools.logW("Release summary JSON failed to parse.", null);
            IOUtils.closeQuietly(entityContentReader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ReleaseSummary> getReleaseSummaries(String apiKey, String appPackageName) throws AuthenticationException, IOException {
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases_by_display_versions";
        HttpGet get = new HttpGet(url);
        get.setHeader(ACCEPT_HEADER, APPLICATION_JSON);
        get.setHeader(API_KEY_HEADER, apiKey);
        ProxySettings proxySettings = ProxySettings.create(ProtocolScheme.getType(get));
        get.setConfig(proxySettings.getConfig());
        this.applyCommonHeadersTo(get);
        this.logRequest(get);
        HttpClient client = proxySettings.getClient();
        HttpResponse response = client.execute(get);
        int result = response.getStatusLine().getStatusCode();
        this.logResponse(response, result);
        if (this.isSuccess(result)) {
            InputStreamReader entityContentReader;
            block4: {
                List<ReleaseSummary> list;
                entityContentReader = null;
                try {
                    entityContentReader = new InputStreamReader(response.getEntity().getContent(), UTF_8);
                    JSONObject releaseSummariesJson = (JSONObject)JSONValue.parse(entityContentReader);
                    if (releaseSummariesJson == null) break block4;
                    list = new ReleaseSummariesJsonTransform().createReleaseSummariesFrom(releaseSummariesJson);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(entityContentReader);
                    throw throwable;
                }
                IOUtils.closeQuietly(entityContentReader);
                return list;
            }
            DeveloperTools.logW("Release summary JSON failed to parse.", null);
            IOUtils.closeQuietly(entityContentReader);
        }
        return null;
    }

    @Override
    public boolean updateAccess(String apiKey, String appPackageName, String instanceId, String displayVersion, String buildVersion, long invitationId, boolean desiredAccess) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("app[display_version]", displayVersion));
        nameValuePairs.add(new BasicNameValuePair("app[build_version]", buildVersion));
        nameValuePairs.add(new BasicNameValuePair("invitation_ids[]", Long.toString(invitationId)));
        String url = this._baseApiUrl + "/spi/v1/platforms/android/apps/" + appPackageName + "/releases/" + instanceId + "/access/" + (desiredAccess ? "enable" : "disable");
        HttpPut put = new HttpPut(url);
        put.setHeader(ACCEPT_HEADER, APPLICATION_JSON);
        put.setHeader(API_KEY_HEADER, apiKey);
        put.setEntity(new UrlEncodedFormEntity(nameValuePairs, UTF_8));
        ProxySettings proxySettings = ProxySettings.create(ProtocolScheme.getType(put));
        put.setConfig(proxySettings.getConfig());
        this.applyCommonHeadersTo(put);
        this.logRequest(put);
        HttpClient client = proxySettings.getClient();
        HttpResponse response = client.execute(put);
        int result = response.getStatusLine().getStatusCode();
        this.logResponse(response, result);
        return this.isSuccess(result);
    }

    private boolean isSuccess(int resultCode) {
        return resultCode >= 200 && resultCode < 300;
    }

    @Override
    public void asyncNotifyBuildEvent(final String appPackageName, final String instanceId, final String orgId, final String buildSecretOrNull) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RestfulWebApi.this.notifyBuildEvent(appPackageName, instanceId, orgId, buildSecretOrNull);
            }
        }, "Build Event Notification").start();
    }

    public void notifyBuildEvent(String appPackageName, String instanceId, String orgId, String buildSecretOrNull) {
        DeveloperTools.logD("Build Event: " + appPackageName + " ID:" + instanceId + " ApiKey:" + orgId + " Tool:" + this._toolId + " " + this._toolVersion + " " + this._toolDetail + " API Secret Null? " + (buildSecretOrNull == null));
        try {
            String url = this.getBaseApiUrl() + "/spi/v1/platforms/android/apps/" + appPackageName + "/built";
            ContentType mimeContentType = ContentType.create(TEXT_PLAIN);
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader(API_CLIENT_ID, this._toolId);
            httpPost.setHeader(API_CLIENT_BUILD_VERSION, this._toolVersion);
            httpPost.setHeader(API_CLIENT_DISPLAY_VERSION, this._toolVersion);
            httpPost.setHeader(ACCEPT_HEADER, APPLICATION_JSON);
            httpPost.setHeader(API_KEY_HEADER, orgId);
            if (buildSecretOrNull != null) {
                httpPost.setHeader(BUILD_SECRET_HEADER, buildSecretOrNull);
            }
            this.applyCommonHeadersTo(httpPost);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addPart("app_name", new StringBody(appPackageName, mimeContentType));
            httpPost.setEntity(builder.build());
            ProxySettings settings = ProxySettings.create(ProtocolScheme.getType(httpPost));
            HttpClient client = this.getClient(settings);
            httpPost.setConfig(settings.getConfig());
            this.logRequest(httpPost);
            HttpResponse response = client.execute(httpPost);
            int result = response.getStatusLine().getStatusCode();
            DeveloperTools.logD("POST response: [reqId=" + RestfulWebApi.getRequestId(response) + "] " + result);
        }
        catch (IOException e) {
            int result = -1;
            DeveloperTools.logD("Crashlytics was unable to notify of build event. " + e.getClass() + ": " + e.getMessage());
        }
    }

    @Override
    public void setToolId(String toolId) {
        this._toolId = toolId;
    }

    @Override
    public void setToolVersion(String toolVersion) {
        this._toolVersion = toolVersion;
    }

    @Override
    public void setOperatingSystem(String os) {
        this._toolDetail = os;
    }

    @Override
    public App getApp(String packageName) throws IOException, AuthenticationException {
        if (packageName != null) {
            for (App app : this.getApps(false)) {
                if (!packageName.equals(app.getName())) continue;
                return app;
            }
        }
        return null;
    }

    @Override
    public Organization getOrg(String apiKey) throws IOException, AuthenticationException {
        if (apiKey != null) {
            for (Organization org : this.getOrgs(false)) {
                if (!apiKey.equals(org.getApiKey())) continue;
                return org;
            }
        }
        return null;
    }

    public static class ProxySettings {
        private final String _proxyHost;
        private final Integer _proxyPort;
        private final String _proxyUser;
        private final String _proxyPassword;

        public ProxySettings(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword) {
            this._proxyHost = proxyHost;
            this._proxyPort = proxyPort;
            this._proxyUser = proxyUser;
            this._proxyPassword = proxyPassword;
        }

        public static ProxySettings create(ProtocolScheme scheme) throws IOException {
            String proxyHost = scheme.getHost();
            String proxyUser = scheme.getUser();
            String proxyPassword = scheme.getPassword();
            String proxyPortString = scheme.getPort();
            Integer proxyPort = null;
            if (proxyPortString != null) {
                try {
                    proxyPort = Integer.parseInt(proxyPortString);
                }
                catch (NumberFormatException e) {
                    throw new IOException("Crashlytics could not read proxy port string.");
                }
            }
            return new ProxySettings(proxyHost, proxyPort, proxyUser, proxyPassword);
        }

        public RequestConfig getConfig() {
            if (this._proxyHost != null && this._proxyPort != null) {
                DeveloperTools.logD("Crashlytics using custom proxy settings: " + this._proxyHost + ":" + this._proxyPort);
                HttpHost proxy = new HttpHost(this._proxyHost, (int)this._proxyPort);
                return RequestConfig.custom().setProxy(proxy).build();
            }
            return RequestConfig.DEFAULT;
        }

        public HttpClient getClient() throws IOException {
            if (this._proxyHost != null && this._proxyPort != null && this._proxyUser != null && this._proxyPassword != null) {
                DeveloperTools.logD("Crashlytics using proxy auth:" + this._proxyUser);
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this._proxyUser, this._proxyPassword);
                AuthScope authScope = new AuthScope(this._proxyHost, this._proxyPort);
                credsProvider.setCredentials(authScope, credentials);
                CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider(credsProvider).build();
                return httpclient;
            }
            return HttpClients.createDefault();
        }
    }

    public static enum ProtocolScheme {
        HTTP("http.proxyHost", "http.proxyUser", "http.proxyPassword", "http.proxyPort"),
        HTTPS("https.proxyHost", "https.proxyUser", "https.proxyPassword", "https.proxyPort"),
        Other(null, null, null, null);

        private String _proxyHostProp;
        private String _proxyUserProp;
        private String _proxyPasswordProp;
        private String _proxyPortProp;

        private ProtocolScheme(String hostProp, String userProp, String passwordProp, String portProp) {
            this._proxyHostProp = hostProp;
            this._proxyUserProp = userProp;
            this._proxyPasswordProp = passwordProp;
            this._proxyPortProp = portProp;
        }

        public static ProtocolScheme getType(HttpRequestBase request) {
            return ProtocolScheme.getType(request.getURI().getScheme());
        }

        public static ProtocolScheme getType(URL url) {
            return ProtocolScheme.getType(url.getProtocol());
        }

        public static ProtocolScheme getType(String protocolString) {
            if (protocolString.equalsIgnoreCase("HTTP")) {
                return HTTP;
            }
            if (protocolString.equalsIgnoreCase("HTTPS")) {
                return HTTPS;
            }
            return Other;
        }

        public String getHost() {
            return this._proxyHostProp == null ? null : System.getProperty(this._proxyHostProp);
        }

        public String getUser() {
            return this._proxyUserProp == null ? null : System.getProperty(this._proxyUserProp);
        }

        public String getPassword() {
            return this._proxyPasswordProp == null ? null : System.getProperty(this._proxyPasswordProp);
        }

        public String getPort() {
            return this._proxyPortProp == null ? null : System.getProperty(this._proxyPortProp);
        }
    }
}

