/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.utils.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class BuildSecretMaintainer {
    private final String _buildSecret;
    private final File _propertiesPath;

    public BuildSecretMaintainer(String buildSecret, File propertiesPath) {
        this._buildSecret = buildSecret;
        this._propertiesPath = propertiesPath;
    }

    public void maintainBuildSecret() throws IOException {
        if (this._buildSecret != null && this._propertiesPath != null) {
            if (!this._propertiesPath.exists()) {
                this._propertiesPath.createNewFile();
            }
            try {
                Properties props = new Properties();
                props.put("apiSecret", this._buildSecret);
                PropertiesUtils.injectPropertyInFile(this._propertiesPath, props, "Contains API Secret used to validate your application. Commit to internal source control; avoid making secret public.");
            }
            catch (IOException io) {
                DeveloperTools.logD("Crashlytics was unable to inject property into file: " + this._propertiesPath);
            }
        }
    }
}

